/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import java.util.HashMap;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.search.MatchQuery;
import org.opensearch.protobufs.MultiMatchQuery;
import org.opensearch.protobufs.Operator;
import org.opensearch.transport.grpc.proto.request.search.OperatorProtoUtils;

class MultiMatchQueryBuilderProtoUtils {
    private MultiMatchQueryBuilderProtoUtils() {
    }

    static MultiMatchQueryBuilder fromProto(MultiMatchQuery multiMatchQueryProto) {
        String value = multiMatchQueryProto.getQuery();
        HashMap<String, Float> fieldsBoosts = new HashMap<String, Float>();
        MultiMatchQueryBuilder.Type type = MultiMatchQueryBuilder.DEFAULT_TYPE;
        String analyzer = null;
        int slop = 0;
        Fuzziness fuzziness = null;
        int prefixLength = 0;
        int maxExpansions = 50;
        org.opensearch.index.query.Operator operator = MultiMatchQueryBuilder.DEFAULT_OPERATOR;
        String minimumShouldMatch = null;
        String fuzzyRewrite = null;
        Float tieBreaker = null;
        Boolean lenient = null;
        MatchQuery.ZeroTermsQuery zeroTermsQuery = MultiMatchQueryBuilder.DEFAULT_ZERO_TERMS_QUERY;
        boolean autoGenerateSynonymsPhraseQuery = true;
        boolean fuzzyTranspositions = true;
        float boost = 1.0f;
        String queryName = null;
        if (multiMatchQueryProto.getFieldsCount() > 0) {
            for (String field : multiMatchQueryProto.getFieldsList()) {
                fieldsBoosts.put(field, Float.valueOf(1.0f));
            }
        }
        if (multiMatchQueryProto.hasType()) {
            switch (multiMatchQueryProto.getType()) {
                case TEXT_QUERY_TYPE_BEST_FIELDS: {
                    type = MultiMatchQueryBuilder.Type.BEST_FIELDS;
                    break;
                }
                case TEXT_QUERY_TYPE_MOST_FIELDS: {
                    type = MultiMatchQueryBuilder.Type.MOST_FIELDS;
                    break;
                }
                case TEXT_QUERY_TYPE_CROSS_FIELDS: {
                    type = MultiMatchQueryBuilder.Type.CROSS_FIELDS;
                    break;
                }
                case TEXT_QUERY_TYPE_PHRASE: {
                    type = MultiMatchQueryBuilder.Type.PHRASE;
                    break;
                }
                case TEXT_QUERY_TYPE_PHRASE_PREFIX: {
                    type = MultiMatchQueryBuilder.Type.PHRASE_PREFIX;
                    break;
                }
                case TEXT_QUERY_TYPE_BOOL_PREFIX: {
                    type = MultiMatchQueryBuilder.Type.BOOL_PREFIX;
                    break;
                }
            }
        }
        if (multiMatchQueryProto.hasAnalyzer()) {
            analyzer = multiMatchQueryProto.getAnalyzer();
        }
        if (multiMatchQueryProto.hasBoost()) {
            boost = multiMatchQueryProto.getBoost();
        }
        if (multiMatchQueryProto.hasSlop()) {
            slop = multiMatchQueryProto.getSlop();
        }
        if (multiMatchQueryProto.hasFuzziness()) {
            org.opensearch.protobufs.Fuzziness fuzzinessProto = multiMatchQueryProto.getFuzziness();
            if (fuzzinessProto.hasString()) {
                fuzziness = Fuzziness.build((Object)fuzzinessProto.getString());
            } else if (fuzzinessProto.hasInt32()) {
                fuzziness = Fuzziness.fromEdits((int)fuzzinessProto.getInt32());
            }
        }
        if (multiMatchQueryProto.hasPrefixLength()) {
            prefixLength = multiMatchQueryProto.getPrefixLength();
        }
        if (multiMatchQueryProto.hasMaxExpansions()) {
            maxExpansions = multiMatchQueryProto.getMaxExpansions();
        }
        if (multiMatchQueryProto.hasOperator() && multiMatchQueryProto.getOperator() != Operator.OPERATOR_UNSPECIFIED) {
            operator = OperatorProtoUtils.fromEnum(multiMatchQueryProto.getOperator());
        }
        if (multiMatchQueryProto.hasMinimumShouldMatch()) {
            if (multiMatchQueryProto.getMinimumShouldMatch().hasString()) {
                minimumShouldMatch = multiMatchQueryProto.getMinimumShouldMatch().getString();
            } else if (multiMatchQueryProto.getMinimumShouldMatch().hasInt32()) {
                minimumShouldMatch = String.valueOf(multiMatchQueryProto.getMinimumShouldMatch().getInt32());
            }
        }
        if (multiMatchQueryProto.hasFuzzyRewrite()) {
            fuzzyRewrite = multiMatchQueryProto.getFuzzyRewrite();
        }
        if (multiMatchQueryProto.hasTieBreaker()) {
            tieBreaker = Float.valueOf(multiMatchQueryProto.getTieBreaker());
        }
        if (multiMatchQueryProto.hasLenient()) {
            lenient = multiMatchQueryProto.getLenient();
        }
        if (multiMatchQueryProto.hasZeroTermsQuery()) {
            switch (multiMatchQueryProto.getZeroTermsQuery()) {
                case ZERO_TERMS_QUERY_NONE: {
                    zeroTermsQuery = MatchQuery.ZeroTermsQuery.NONE;
                    break;
                }
                case ZERO_TERMS_QUERY_ALL: {
                    zeroTermsQuery = MatchQuery.ZeroTermsQuery.ALL;
                    break;
                }
                case ZERO_TERMS_QUERY_UNSPECIFIED: {
                    break;
                }
            }
        }
        if (multiMatchQueryProto.hasXName()) {
            queryName = multiMatchQueryProto.getXName();
        }
        if (multiMatchQueryProto.hasAutoGenerateSynonymsPhraseQuery()) {
            autoGenerateSynonymsPhraseQuery = multiMatchQueryProto.getAutoGenerateSynonymsPhraseQuery();
        }
        if (multiMatchQueryProto.hasFuzzyTranspositions()) {
            fuzzyTranspositions = multiMatchQueryProto.getFuzzyTranspositions();
        }
        if (slop != 0 && type == MultiMatchQueryBuilder.Type.BOOL_PREFIX) {
            throw new IllegalArgumentException("slop not allowed for type [" + String.valueOf(type) + "]");
        }
        MultiMatchQueryBuilder builder = ((MultiMatchQueryBuilder)((MultiMatchQueryBuilder)new MultiMatchQueryBuilder((Object)value, new String[0]).fields(fieldsBoosts).type(type).analyzer(analyzer).fuzziness(fuzziness).fuzzyRewrite(fuzzyRewrite).maxExpansions(maxExpansions).minimumShouldMatch(minimumShouldMatch).operator(operator).prefixLength(prefixLength).slop(slop).tieBreaker(tieBreaker).zeroTermsQuery(zeroTermsQuery).autoGenerateSynonymsPhraseQuery(autoGenerateSynonymsPhraseQuery).boost(boost)).queryName(queryName)).fuzzyTranspositions(fuzzyTranspositions);
        if (lenient != null) {
            builder.lenient(lenient.booleanValue());
        }
        return builder;
    }
}

