/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.admin.cluster.crypto.CryptoSettings;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@ExperimentalApi
public class CryptoMetadata
implements Writeable {
    public static final String CRYPTO_METADATA_KEY = "crypto_metadata";
    public static final String KEY_PROVIDER_NAME_KEY = "key_provider_name";
    public static final String KEY_PROVIDER_TYPE_KEY = "key_provider_type";
    public static final String SETTINGS_KEY = "settings";
    private static final String KMS_KEY_ARN_SETTING = "kms.key_arn";
    private static final String KMS_ENCRYPTION_CONTEXT_SETTING = "kms.encryption_context";
    private final String keyProviderName;
    private final String keyProviderType;
    private final Settings settings;

    public CryptoMetadata(String keyProviderName, String keyProviderType, Settings settings) {
        this.keyProviderName = keyProviderName;
        this.keyProviderType = keyProviderType;
        this.settings = settings;
    }

    public String keyProviderName() {
        return this.keyProviderName;
    }

    public String keyProviderType() {
        return this.keyProviderType;
    }

    public Settings settings() {
        return this.settings;
    }

    public Optional<String> getKeyArn() {
        return Optional.ofNullable(this.settings.get(KMS_KEY_ARN_SETTING));
    }

    public Optional<String> getEncryptionContext() {
        return Optional.ofNullable(this.settings.get(KMS_ENCRYPTION_CONTEXT_SETTING));
    }

    public CryptoMetadata(StreamInput in) throws IOException {
        this.keyProviderName = in.readString();
        this.keyProviderType = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
    }

    public static CryptoMetadata fromRequest(CryptoSettings cryptoSettings) {
        if (cryptoSettings == null) {
            return null;
        }
        return new CryptoMetadata(cryptoSettings.getKeyProviderName(), cryptoSettings.getKeyProviderType(), cryptoSettings.getSettings());
    }

    public static CryptoMetadata fromIndexSettings(Settings indexSettings) {
        String keyProviderName = indexSettings.get("index.store.crypto.key_provider");
        if (keyProviderName == null) {
            return null;
        }
        String keyProviderType = indexSettings.get("index.store.crypto.key_provider_type", "aws-kms");
        Settings cryptoSettings = indexSettings.getAsSettings("index.store.crypto");
        return new CryptoMetadata(keyProviderName, keyProviderType, cryptoSettings);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.keyProviderName);
        out.writeString(this.keyProviderType);
        Settings.writeSettingsToStream(this.settings, out);
    }

    public static CryptoMetadata fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String keyProviderType = null;
        Settings settings = null;
        String keyProviderName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (KEY_PROVIDER_NAME_KEY.equals(currentFieldName)) {
                    if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                        throw new OpenSearchParseException("failed to parse crypto metadata [{}], unknown type", new Object[0]);
                    }
                    keyProviderName = parser.text();
                    continue;
                }
                if (KEY_PROVIDER_TYPE_KEY.equals(currentFieldName)) {
                    if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                        throw new OpenSearchParseException("failed to parse crypto metadata [{}], unknown type", new Object[0]);
                    }
                    keyProviderType = parser.text();
                    continue;
                }
                if (SETTINGS_KEY.equals(currentFieldName)) {
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new OpenSearchParseException("failed to parse crypto metadata [{}], unknown type", new Object[0]);
                    }
                    settings = Settings.fromXContent(parser);
                    continue;
                }
                throw new OpenSearchParseException("failed to parse crypto metadata, unknown field [{}]", new Object[]{currentFieldName});
            }
            throw new OpenSearchParseException("failed to parse repositories", new Object[0]);
        }
        return new CryptoMetadata(keyProviderName, keyProviderType, settings);
    }

    public void toXContent(CryptoMetadata cryptoMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(CRYPTO_METADATA_KEY);
        builder.field(KEY_PROVIDER_NAME_KEY, cryptoMetadata.keyProviderName());
        builder.field(KEY_PROVIDER_TYPE_KEY, cryptoMetadata.keyProviderType());
        builder.startObject(SETTINGS_KEY);
        cryptoMetadata.settings().toXContent(builder, params);
        builder.endObject();
        builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CryptoMetadata that = (CryptoMetadata)o;
        if (!this.keyProviderName.equals(that.keyProviderName)) {
            return false;
        }
        if (!this.keyProviderType.equals(that.keyProviderType)) {
            return false;
        }
        return this.settings.equals(that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.keyProviderName, this.keyProviderType, this.settings);
    }

    public String toString() {
        return "CryptoMetadata{" + this.keyProviderName + "}{" + this.keyProviderType + "}{" + String.valueOf(this.settings) + "}";
    }
}

