/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.node.Node;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;

public final class ForkJoinPoolExecutorBuilder
extends ExecutorBuilder<ForkJoinPoolExecutorSettings> {
    private final Setting<Integer> parallelismSetting;
    private final Setting<Boolean> asyncModeSetting;
    private final Setting<String> threadFactorySetting;
    private final Setting<Boolean> enableExceptionHandlingSetting;
    private static final Logger logger = LogManager.getLogger(ForkJoinPoolExecutorBuilder.class);

    public ForkJoinPoolExecutorBuilder(String name, int parallelism) {
        this(name, parallelism, "thread_pool." + name);
    }

    public ForkJoinPoolExecutorBuilder(String name, int parallelism, String prefix) {
        super(name);
        this.parallelismSetting = Setting.intSetting(ForkJoinPoolExecutorBuilder.settingsKey(prefix, "parallelism"), parallelism, 1, Setting.Property.NodeScope);
        this.asyncModeSetting = Setting.boolSetting(ForkJoinPoolExecutorBuilder.settingsKey(prefix, "async_mode"), false, Setting.Property.NodeScope);
        this.threadFactorySetting = Setting.simpleString(ForkJoinPoolExecutorBuilder.settingsKey(prefix, "thread_factory"), "", Setting.Property.NodeScope);
        this.enableExceptionHandlingSetting = Setting.boolSetting(ForkJoinPoolExecutorBuilder.settingsKey(prefix, "enable_exception_handling"), true, Setting.Property.NodeScope);
    }

    @Override
    public List<Setting<?>> getRegisteredSettings() {
        return Arrays.asList(this.parallelismSetting, this.asyncModeSetting, this.threadFactorySetting, this.enableExceptionHandlingSetting);
    }

    @Override
    ForkJoinPoolExecutorSettings getSettings(Settings settings) {
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        int parallelism = this.parallelismSetting.get(settings);
        boolean asyncMode = this.asyncModeSetting.get(settings);
        String threadFactoryClassName = this.threadFactorySetting.get(settings);
        boolean enableExceptionHandling = this.enableExceptionHandlingSetting.get(settings);
        return new ForkJoinPoolExecutorSettings(nodeName, parallelism, asyncMode, threadFactoryClassName, enableExceptionHandling);
    }

    @Override
    ThreadPool.ExecutorHolder build(ForkJoinPoolExecutorSettings settings, ThreadContext threadContext) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory;
        int parallelism = settings.parallelism;
        boolean asyncMode = settings.asyncMode;
        String threadFactoryClassName = settings.threadFactoryClassName;
        boolean enableExceptionHandling = settings.enableExceptionHandling;
        if (threadFactoryClassName != null && !threadFactoryClassName.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(threadFactoryClassName);
                factory = (ForkJoinPool.ForkJoinWorkerThreadFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.warn("Unable to instantiate custom ForkJoinWorkerThreadFactory '{}', using default. Error: {}", (Object)threadFactoryClassName, (Object)e.toString());
                factory = pool -> {
                    ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                    worker.setName(OpenSearchExecutors.threadName(settings.nodeName, this.name()));
                    return worker;
                };
            }
        } else {
            factory = pool -> {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName(OpenSearchExecutors.threadName(settings.nodeName, this.name()));
                return worker;
            };
        }
        Thread.UncaughtExceptionHandler exceptionHandler = enableExceptionHandling ? (thread, throwable) -> logger.error("Uncaught exception in ForkJoinPool thread [" + thread.getName() + "]", throwable) : null;
        ForkJoinPool executor = new ForkJoinPool(parallelism, factory, exceptionHandler, asyncMode);
        ThreadPool.Info info = new ThreadPool.Info(this.name(), ThreadPool.ThreadPoolType.FORK_JOIN, parallelism, parallelism, null, null);
        return new ThreadPool.ExecutorHolder(executor, info);
    }

    @Override
    String formatInfo(ThreadPool.Info info) {
        return String.format(Locale.ROOT, "name [%s], parallelism [%d]", info.getName(), info.getMax());
    }

    static class ForkJoinPoolExecutorSettings
    extends ExecutorBuilder.ExecutorSettings {
        private final int parallelism;
        private final boolean asyncMode;
        private final String threadFactoryClassName;
        private final boolean enableExceptionHandling;

        ForkJoinPoolExecutorSettings(String nodeName, int parallelism, boolean asyncMode, String threadFactoryClassName, boolean enableExceptionHandling) {
            super(nodeName);
            this.parallelism = parallelism;
            this.asyncMode = asyncMode;
            this.threadFactoryClassName = threadFactoryClassName;
            this.enableExceptionHandling = enableExceptionHandling;
        }
    }
}

