/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.opensearch.action.search.AbstractSearchAsyncAction;
import org.opensearch.action.search.SearchPhaseController;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestContext;
import org.opensearch.action.search.SearchRequestOperationsCompositeListenerFactory;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchShardIterator;
import org.opensearch.action.search.SearchTask;
import org.opensearch.action.search.SearchType;
import org.opensearch.action.search.StreamQueryPhaseResultConsumer;
import org.opensearch.action.search.StreamSearchQueryThenFetchAsyncAction;
import org.opensearch.action.search.StreamSearchTransportService;
import org.opensearch.action.search.TransportSearchAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.GroupShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.SearchService;
import org.opensearch.search.internal.AliasFilter;
import org.opensearch.search.pipeline.SearchPipelineService;
import org.opensearch.tasks.TaskResourceTrackingService;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.StreamTransportService;
import org.opensearch.transport.Transport;
import org.opensearch.transport.client.node.NodeClient;

public class StreamTransportSearchAction
extends TransportSearchAction {
    @Inject
    public StreamTransportSearchAction(NodeClient client, ThreadPool threadPool, CircuitBreakerService circuitBreakerService, @Nullable StreamTransportService transportService, SearchService searchService, @Nullable StreamSearchTransportService searchTransportService, SearchPhaseController searchPhaseController, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedWriteableRegistry namedWriteableRegistry, SearchPipelineService searchPipelineService, MetricsRegistry metricsRegistry, SearchRequestOperationsCompositeListenerFactory searchRequestOperationsCompositeListenerFactory, Tracer tracer, TaskResourceTrackingService taskResourceTrackingService) {
        super(client, threadPool, circuitBreakerService, transportService, searchService, searchTransportService, searchPhaseController, clusterService, actionFilters, indexNameExpressionResolver, namedWriteableRegistry, searchPipelineService, metricsRegistry, searchRequestOperationsCompositeListenerFactory, tracer, taskResourceTrackingService);
    }

    @Override
    AbstractSearchAsyncAction<? extends SearchPhaseResult> searchAsyncAction(SearchTask task, SearchRequest searchRequest, Executor executor, GroupShardsIterator<SearchShardIterator> shardIterators, TransportSearchAction.SearchTimeProvider timeProvider, BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Map<String, Set<String>> indexRoutings, ActionListener<SearchResponse> listener, boolean preFilter, ThreadPool threadPool, SearchResponse.Clusters clusters, SearchRequestContext searchRequestContext) {
        if (preFilter) {
            throw new IllegalStateException("Search pre-filter is not supported in streaming");
        }
        StreamQueryPhaseResultConsumer queryResultConsumer = this.searchPhaseController.newStreamSearchPhaseResults(executor, this.circuitBreaker, task.getProgressListener(), searchRequest, shardIterators.size(), exc -> this.cancelTask(task, (Exception)exc));
        return switch (searchRequest.searchType()) {
            case SearchType.QUERY_THEN_FETCH -> new StreamSearchQueryThenFetchAsyncAction(this.logger, this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, indexRoutings, this.searchPhaseController, executor, queryResultConsumer, searchRequest, listener, shardIterators, timeProvider, clusterState, task, clusters, searchRequestContext, this.tracer);
            default -> throw new IllegalStateException("Unknown search type: [" + String.valueOf((Object)searchRequest.searchType()) + "]");
        };
    }
}

