/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.listeners;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.protobufs.SearchResponse;
import org.opensearch.transport.grpc.proto.response.search.SearchResponseProtoUtils;
import org.opensearch.transport.grpc.util.GrpcErrorHandler;

public class SearchRequestActionListener
implements ActionListener<org.opensearch.action.search.SearchResponse> {
    private static final Logger logger = LogManager.getLogger(SearchRequestActionListener.class);
    private final StreamObserver<SearchResponse> responseObserver;

    public SearchRequestActionListener(StreamObserver<SearchResponse> responseObserver) {
        this.responseObserver = responseObserver;
    }

    public void onResponse(org.opensearch.action.search.SearchResponse response) {
        try {
            SearchResponse protoResponse = SearchResponseProtoUtils.toProto(response);
            this.responseObserver.onNext((Object)protoResponse);
            this.responseObserver.onCompleted();
        }
        catch (IOException | RuntimeException e) {
            logger.error("Failed to convert search response to protobuf: " + e.getMessage());
            StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError(e);
            this.responseObserver.onError((Throwable)grpcError);
        }
    }

    public void onFailure(Exception e) {
        logger.error("SearchRequestActionListener failed to process search request: " + e.getMessage());
        StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError(e);
        this.responseObserver.onError((Throwable)grpcError);
    }
}

