/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.javafx2.editor.completion.model.EventHandler;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxObjectBase;
import org.netbeans.modules.javafx2.editor.completion.model.FxScriptFragment;
import org.netbeans.modules.javafx2.editor.completion.model.PropertySetter;
import org.netbeans.modules.javafx2.editor.completion.model.PropertyValue;
import org.netbeans.modules.javafx2.editor.completion.model.StaticProperty;

public abstract class FxInstance
extends FxObjectBase {
    private String id;
    private Map<String, PropertyValue> properties = Collections.emptyMap();
    private Map<String, StaticProperty> staticProperties = Collections.emptyMap();
    private Map<String, EventHandler> eventHandlers = Collections.emptyMap();
    private List<FxScriptFragment> scripts = Collections.emptyList();

    public String getId() {
        return this.id;
    }

    void addProperty(PropertyValue p) {
        if (this.properties.isEmpty()) {
            this.properties = new HashMap<String, PropertyValue>();
        }
        this.properties.put(p.getPropertyName(), p);
    }

    void addStaticProperty(StaticProperty p) {
        if (this.staticProperties.isEmpty()) {
            this.staticProperties = new HashMap<String, StaticProperty>();
        }
        this.staticProperties.put(p.getPropertyName(), p);
    }

    void addEvent(EventHandler p) {
        if (this.eventHandlers.isEmpty()) {
            this.eventHandlers = new HashMap<String, EventHandler>();
        }
        this.eventHandlers.put(p.getEvent(), p);
    }

    void addScript(FxScriptFragment script) {
        if (this.scripts.isEmpty()) {
            this.scripts = new LinkedList<FxScriptFragment>();
        }
        this.scripts.add(script);
    }

    public List<FxScriptFragment> getScripts() {
        return Collections.unmodifiableList(this.scripts);
    }

    public Collection<String> getEventNames() {
        return Collections.unmodifiableCollection(this.eventHandlers.keySet());
    }

    public EventHandler getEventHandler(String n) {
        return this.eventHandlers.get(n);
    }

    public PropertyValue getProperty(String n) {
        PropertyValue p = this.properties.get(n);
        if (p == null) {
            p = this.staticProperties.get(n);
        }
        return p;
    }

    public Collection<? extends EventHandler> getEvents() {
        return Collections.unmodifiableCollection(this.eventHandlers.values());
    }

    public Collection<PropertyValue> getProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    public Collection<StaticProperty> getStaticProperties() {
        return Collections.unmodifiableCollection(this.staticProperties.values());
    }

    FxInstance withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    void detachChild(FxNode child) {
        if (child instanceof StaticProperty) {
            this.staticProperties.remove(((StaticProperty)child).getPropertyName());
        } else if (child instanceof PropertySetter) {
            this.properties.remove(((PropertySetter)child).getPropertyName());
        }
    }

    @Override
    void addChild(FxNode child) {
        super.addChild(child);
        if (child instanceof StaticProperty) {
            this.addStaticProperty((StaticProperty)child);
        } else if (child instanceof PropertyValue) {
            this.addProperty((PropertyValue)child);
        } else if (child instanceof EventHandler) {
            this.addEvent((EventHandler)child);
        } else if (child instanceof FxScriptFragment) {
            this.addScript((FxScriptFragment)child);
        } else {
            throw new IllegalArgumentException();
        }
    }

    void propertyRenamed(PropertyValue pv) {
        if (this.properties.values().remove(pv)) {
            this.properties.put(pv.getPropertyName(), pv);
        }
    }
}

