/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Parent;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.project.dependency.ProjectOperationException;
import org.netbeans.modules.project.dependency.ProjectReload;
import org.netbeans.modules.project.dependency.spi.ProjectReloadImplementation;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.Cancellable;
import org.openide.util.lookup.Lookups;

public class MavenPrimingReloadImplementation
implements ProjectReloadImplementation {
    private static final Logger LOG = Logger.getLogger(MavenPrimingReloadImplementation.class.getName());
    private Set<String> placeholderArtifactNames = new HashSet<String>();
    private Reference<ProjectReloadImplementation.ProjectStateData> lastData = new WeakReference<Object>(null);

    private ProjectReload.Quality getProjectQuality(MavenProject mp) {
        if (MavenProjectCache.isFallbackproject(mp)) {
            MavenProject fallback = MavenProjectCache.getPartialProject(mp);
            return fallback != null ? ProjectReload.Quality.BROKEN : ProjectReload.Quality.NONE;
        }
        if (!MavenProjectCache.getPlaceholderArtifacts(mp).isEmpty()) {
            return ProjectReload.Quality.LOADED;
        }
        return ProjectReload.Quality.RESOLVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectReloadImplementation.ProjectStateData createStateData(MavenProject mp) {
        MavenPrimingReloadImplementation mavenPrimingReloadImplementation = this;
        synchronized (mavenPrimingReloadImplementation) {
            ModelHolder h;
            ProjectReloadImplementation.ProjectStateData d2 = this.lastData.get();
            if (d2 != null && (h = (ModelHolder)d2.getProjectData()) != null && h.p == mp) {
                return d2;
            }
        }
        ProjectReloadImplementation.ProjectStateBuilder builder = ProjectReloadImplementation.ProjectStateData.builder((ProjectReload.Quality)this.getProjectQuality(mp)).timestamp(-2L);
        builder.data((Object)new ModelHolder(mp));
        builder.attachLookup(Lookups.fixed((Object[])new Object[]{mp}));
        ProjectReloadImplementation.ProjectStateData d = builder.build();
        MavenPrimingReloadImplementation mavenPrimingReloadImplementation2 = this;
        synchronized (mavenPrimingReloadImplementation2) {
            ProjectReloadImplementation.ProjectStateData d2 = this.lastData.get();
            if (d2 != null) {
                if (d2.getProjectData() == mp) {
                    return d2;
                }
                d2.fireChanged(true, false);
            }
            this.lastData = new WeakReference<ProjectReloadImplementation.ProjectStateData>(d);
        }
        return d;
    }

    static boolean checkForMissingArtifacts(MavenProject p) {
        return p == null || !MavenProjectCache.isIncompleteProject(p) || MavenProjectCache.getPlaceholderArtifacts(p).isEmpty();
    }

    static String artifactGav(Artifact a) {
        if (a == null) {
            return null;
        }
        String gav = String.format("%s:%s", a.getGroupId(), a.getArtifactId());
        if (a.getClassifier() != null && !a.getClassifier().isEmpty()) {
            return gav + ":" + a.getClassifier();
        }
        return gav;
    }

    private static String artifactList(Collection<String> gavs) {
        ArrayList<String> sorted = new ArrayList<String>(gavs);
        Collections.sort(sorted);
        String s = String.join((CharSequence)", ", sorted.subList(0, Math.min(sorted.size(), 5)));
        return sorted.size() > 5 ? s + ", ..." : s;
    }

    private CompletableFuture<ProjectReloadImplementation.ProjectStateData> reportMissingArtifacts(Project project, ProjectReload.StateRequest request, MavenProject p, Collection<String> gavs) {
        String msg = this.placeholderArtifactNames.containsAll(gavs) ? Bundle.ERR_IncompleteProjectRepeated(project, MavenPrimingReloadImplementation.artifactList(gavs)) : Bundle.ERR_IncompleteProjectDownload(ProjectUtils.getInformation((Project)project).getDisplayName(), MavenPrimingReloadImplementation.artifactList(gavs));
        ProjectReloadImplementation.PartialLoadException ex = new ProjectReloadImplementation.PartialLoadException(this.createStateData(p), msg, (Throwable)new ProjectOperationException(project, request.isOfflineOperation() ? ProjectOperationException.State.OFFLINE : ProjectOperationException.State.BROKEN, msg));
        CompletableFuture<ProjectReloadImplementation.ProjectStateData> future = new CompletableFuture<ProjectReloadImplementation.ProjectStateData>();
        future.completeExceptionally((Throwable)ex);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture reload(final Project project, ProjectReload.StateRequest request, final ProjectReloadImplementation.LoadContext context) {
        Object msg;
        Parent pp;
        final MavenProject p = (MavenProject)context.stateLookup().lookup(MavenProject.class);
        LC lc = (LC)context.ensureLoadContext(LC.class, LC::new);
        boolean ok = MavenPrimingReloadImplementation.checkForMissingArtifacts(p);
        if (ok) {
            MavenPrimingReloadImplementation mavenPrimingReloadImplementation = this;
            synchronized (mavenPrimingReloadImplementation) {
                this.placeholderArtifactNames.clear();
            }
            LOG.log(Level.FINE, "Project {0}: no missing artifacts", project);
            return CompletableFuture.completedFuture(null);
        }
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        Collection<Artifact> placeholders = MavenProjectCache.getPlaceholderArtifacts(p);
        HashSet<String> gavs = new HashSet<String>();
        placeholders.forEach(a -> {
            if (a != null) {
                gavs.add(MavenPrimingReloadImplementation.artifactGav(a));
            }
        });
        Object parentGav = MavenPrimingReloadImplementation.artifactGav(p.getParentArtifact());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Project {0}: missing artifacts reported: {1}", new Object[]{project, gavs});
        }
        final CompletableFuture<ProjectReloadImplementation.ProjectStateData> future = new CompletableFuture<ProjectReloadImplementation.ProjectStateData>();
        if (parentGav == null && (pp = p.getModel().getParent()) != null) {
            parentGav = pp.getGroupId() + ":" + pp.getArtifactId();
        }
        if ((gavs.contains(parentGav) || parentGav != null && p.getParentArtifact() == null) && (request.getTargetQuality().isWorseThan(ProjectReload.Quality.RESOLVED) || request.isOfflineOperation())) {
            msg = this.placeholderArtifactNames.contains(parentGav) ? Bundle.ERR_IncompleteProjectRepeated(project, Collections.singletonList(parentGav)) : (request.isOfflineOperation() ? Bundle.ERR_UnprimedInOfflineMode(ProjectUtils.getInformation((Project)project).getDisplayName()) : Bundle.ERR_ParentPomMissing(ProjectUtils.getInformation((Project)project).getDisplayName(), parentGav));
            ProjectOperationException pex = new ProjectOperationException(project, request.isOfflineOperation() ? ProjectOperationException.State.OFFLINE : ProjectOperationException.State.BROKEN, (String)msg);
            ProjectReloadImplementation.PartialLoadException ex = new ProjectReloadImplementation.PartialLoadException(this.createStateData(p), (String)msg, (Throwable)pex);
            future.completeExceptionally((Throwable)ex);
            return future;
        }
        if (request.getTargetQuality().isWorseThan(ProjectReload.Quality.RESOLVED)) {
            future.complete(this.createStateData(p));
            return future;
        }
        if (request.getMinQuality().isWorseThan(ProjectReload.Quality.RESOLVED) || request.isOfflineOperation()) {
            return this.reportMissingArtifacts(project, request, p, gavs);
        }
        msg = this;
        synchronized (msg) {
            if (!gavs.isEmpty() && this.placeholderArtifactNames.containsAll(gavs) && !request.isForceReload()) {
                return this.reportMissingArtifacts(project, request, p, gavs);
            }
            this.placeholderArtifactNames = gavs;
        }
        lc.firstRun = false;
        class CancelSignalDelegator
        implements Consumer<Cancellable>,
        Cancellable {
            private final AtomicReference<Cancellable> ref = new AtomicReference();

            CancelSignalDelegator() {
            }

            @Override
            public void accept(Cancellable other) {
                this.ref.set(other);
            }

            public boolean cancel() {
                Cancellable other = this.ref.get();
                return other != null && other.cancel();
            }
        }
        CancelSignalDelegator csd = new CancelSignalDelegator();
        context.setCancellable((Cancellable)csd);
        ActionProgress prg = new ActionProgress(this){
            final /* synthetic */ MavenPrimingReloadImplementation this$0;
            {
                this.this$0 = this$0;
            }

            protected void started() {
            }

            public void finished(boolean success) {
                if (success) {
                    context.retryReload();
                    future.complete(null);
                } else if (context.isCancelled()) {
                    future.completeExceptionally(context.getCancelled());
                } else {
                    String n = ProjectUtils.getInformation((Project)project).getDisplayName();
                    ProjectOperationException cause = new ProjectOperationException(project, ProjectOperationException.State.BROKEN, Bundle.ERR_PrimingBuildFailed(n));
                    ProjectReloadImplementation.ProjectStateData partialdata = this.this$0.createStateData(p);
                    ProjectReloadImplementation.PartialLoadException ex = new ProjectReloadImplementation.PartialLoadException(partialdata, Bundle.ERR_PrimingBuildFailed(n), (Throwable)cause);
                    future.completeExceptionally((Throwable)ex);
                }
            }
        };
        if (context.isCancelled()) {
            future.cancel(true);
            return future;
        }
        ap.invokeAction("prime", Lookups.fixed((Object[])new Object[]{prg, csd}));
        return future;
    }

    private static class ModelHolder {
        final MavenProject p;

        public ModelHolder(MavenProject p) {
            this.p = p;
        }

        public int hashCode() {
            int hash = 3;
            hash = 59 * hash + Objects.hashCode(this.p);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModelHolder other = (ModelHolder)obj;
            return Objects.equals(this.p, other.p);
        }
    }

    static class LC {
        boolean firstRun = true;

        LC() {
        }
    }
}

