/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.lib.chrome_devtools_protocol.debugger.GetScriptSourceRequest;
import org.netbeans.modules.javascript.cdtdebug.Bundle;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.CDTScript;
import org.netbeans.modules.javascript2.debug.sources.SourceContent;
import org.netbeans.modules.javascript2.debug.sources.SourceFilesCache;
import org.netbeans.modules.web.common.sourcemap.SourceMapsScanner;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class ScriptsHandler {
    private static final Logger LOG = Logger.getLogger(ScriptsHandler.class.getName());
    private static final boolean USE_SOURCE_MAPS = Boolean.parseBoolean(System.getProperty("javascript.debugger.useSourceMaps", "true"));
    private final Map<String, CDTScript> scriptsById = new HashMap<String, CDTScript>();
    private final Map<URL, CDTScript> scriptsByURL = new HashMap<URL, CDTScript>();
    private final SourceMapsTranslator smt;
    private final String remotePathPrefix;
    private final boolean doPathTranslation;
    private final String[] localPathPrefixes;
    private final String[] serverPathPrefixes;
    @NullAllowed
    private final FileObject[] localRoots;
    @NullAllowed
    private final FileObject[] localPathExclusionFilters;
    private final CDTDebugger dbg;

    ScriptsHandler(@NullAllowed List<String> localPaths, @NullAllowed List<String> serverPaths, Collection<String> localPathExclusionFilters, @NullAllowed CDTDebugger dbg) {
        FileObject localRoot;
        int i;
        this.remotePathPrefix = dbg != null ? dbg.getWebSocketDebuggerUrl().getHost() + "_" + dbg.getWebSocketDebuggerUrl().getPort() + "/" : "";
        if (!(localPaths == null || localPaths.isEmpty() || serverPaths == null || serverPaths.isEmpty() || localPaths.equals(serverPaths))) {
            this.doPathTranslation = true;
            int n = localPaths.size();
            this.localPathPrefixes = new String[n];
            this.serverPathPrefixes = new String[n];
            for (i = 0; i < n; ++i) {
                this.localPathPrefixes[i] = ScriptsHandler.toUrl(localPaths.get(i));
            }
            for (i = 0; i < n; ++i) {
                this.serverPathPrefixes[i] = ScriptsHandler.toUrl(serverPaths.get(i));
            }
        } else {
            this.doPathTranslation = false;
            this.localPathPrefixes = null;
            this.serverPathPrefixes = null;
        }
        if (localPaths != null && !localPaths.isEmpty()) {
            FileObject[] lroots = new FileObject[localPaths.size()];
            i = 0;
            for (String localPath : localPaths) {
                localRoot = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(localPath)));
                if (localRoot == null) continue;
                lroots[i++] = localRoot;
            }
            if (i < localPaths.size()) {
                lroots = Arrays.copyOf(lroots, i);
            }
            this.localRoots = lroots;
            this.smt = USE_SOURCE_MAPS ? SourceMapsScanner.getInstance().scan(this.localRoots) : null;
        } else {
            this.localRoots = null;
            this.smt = USE_SOURCE_MAPS ? SourceMapsTranslator.create() : null;
        }
        if (!localPathExclusionFilters.isEmpty()) {
            FileObject[] lpefs = new FileObject[localPathExclusionFilters.size()];
            i = 0;
            for (String lpef : localPathExclusionFilters) {
                localRoot = FileUtil.toFileObject((File)new File(lpef));
                if (localRoot != null) {
                    lpefs[i++] = localRoot;
                    continue;
                }
                lpefs = Arrays.copyOf(lpefs, lpefs.length - 1);
            }
            this.localPathExclusionFilters = lpefs.length > 0 ? lpefs : null;
        } else {
            this.localPathExclusionFilters = null;
        }
        LOG.log(Level.FINE, "ScriptsHandler: doPathTranslation = {0}, localPathPrefixes = {1},serverPathPrefixes = {2},localRoots = {3}, localPathExclusionFilters = {4}.", new Object[]{this.doPathTranslation, Arrays.toString(this.localPathPrefixes), Arrays.toString(this.serverPathPrefixes), Arrays.toString(this.localRoots), Arrays.toString(this.localPathExclusionFilters)});
        this.dbg = dbg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(CDTScript script) {
        Map<String, CDTScript> map = this.scriptsById;
        synchronized (map) {
            this.scriptsById.put(script.getScriptId(), script);
        }
    }

    @CheckForNull
    public SourceMapsTranslator getSourceMapsTranslator() {
        return this.smt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public CDTScript getScript(String id) {
        Map<String, CDTScript> map = this.scriptsById;
        synchronized (map) {
            return this.scriptsById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Collection<CDTScript> getScripts() {
        Map<String, CDTScript> map = this.scriptsById;
        synchronized (map) {
            return new ArrayList<CDTScript>(this.scriptsById.values());
        }
    }

    public boolean containsLocalFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        if ("js-scripts".equals(fo.toURL().getProtocol())) {
            return true;
        }
        if (this.localPathExclusionFilters != null) {
            for (FileObject lpef : this.localPathExclusionFilters) {
                if (!FileUtil.isParentOf((FileObject)lpef, (FileObject)fo)) continue;
                return false;
            }
        }
        if (this.localRoots == null) {
            return true;
        }
        for (FileObject localRoot : this.localRoots) {
            if (!FileUtil.isParentOf((FileObject)localRoot, (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRemoteFile(URL url) {
        int index;
        String path;
        if (!"js-scripts".equals(url.getProtocol())) {
            return false;
        }
        try {
            path = url.toURI().getPath();
        }
        catch (URISyntaxException usex) {
            return false;
        }
        int l = path.length();
        for (index = 0; index < l && path.charAt(index) == '/'; ++index) {
        }
        int begin = path.indexOf(47, index);
        if (begin > 0) {
            return path.regionMatches(begin + 1, this.remotePathPrefix, 0, this.remotePathPrefix.length());
        }
        return false;
    }

    @CheckForNull
    public FileObject getFile(String scriptId) {
        CDTScript script = this.getScript(scriptId);
        if (script == null) {
            return null;
        }
        return this.getFile(script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile(@NonNull CDTScript script) {
        String url;
        block10: {
            url = script.getUrl();
            if (url == null) {
                return null;
            }
            String lp = this.getLocalPath(url);
            if (lp != null) {
                try {
                    FileObject localFile = URLMapper.findFileObject((URL)new URI(lp).toURL());
                    if (localFile == null) break block10;
                    Map<URL, CDTScript> map = this.scriptsByURL;
                    synchronized (map) {
                        this.scriptsByURL.put(localFile.toURL(), script);
                    }
                    return localFile;
                }
                catch (MalformedURLException | URISyntaxException localFile) {
                    // empty catch block
                }
            }
        }
        String name = this.remotePathPrefix + url;
        URL sourceURL = SourceFilesCache.getDefault().getSourceFile(name, script.getHash(), (SourceContent)new ScriptContentLoader(script, this.dbg));
        Map<URL, CDTScript> map = this.scriptsByURL;
        synchronized (map) {
            this.scriptsByURL.put(sourceURL, script);
        }
        return URLMapper.findFileObject((URL)sourceURL);
    }

    @CheckForNull
    public String getServerPath(@NonNull FileObject fo) {
        if (!this.doPathTranslation) {
            return this.toTripleSlashUri(fo.toURI()).toString();
        }
        URL url = fo.toURL();
        if ("js-scripts".equals(url.getProtocol())) {
            String path = fo.getPath();
            int begin = path.indexOf(47);
            if (begin > 0) {
                if ((path = path.substring(begin + 1)).startsWith(this.remotePathPrefix)) {
                    String serverPath = path.substring(this.remotePathPrefix.length());
                } else {
                    Object serverPath = null;
                }
            } else {
                Object serverPath = null;
            }
        } else {
            String fileUri = this.toTripleSlashUri(fo.toURI()).toString();
            for (int i = 0; i < this.localPathPrefixes.length; ++i) {
                if (!fileUri.startsWith(this.localPathPrefixes[i])) continue;
                return this.serverPathPrefixes[i] + fileUri.substring(this.localPathPrefixes[i].length());
            }
        }
        return null;
    }

    public String getLocalPath(@NonNull String serverPath) {
        if (!this.doPathTranslation) {
            return serverPath;
        }
        for (int i = 0; i < this.serverPathPrefixes.length; ++i) {
            if (!serverPath.startsWith(this.serverPathPrefixes[i])) continue;
            return this.localPathPrefixes[i] + serverPath.substring(this.serverPathPrefixes[i].length());
        }
        return null;
    }

    public File[] getLocalRoots() {
        if (this.localRoots == null) {
            return new File[0];
        }
        int l = this.localRoots.length;
        File[] roots = new File[l];
        for (int i = 0; i < l; ++i) {
            roots[i] = FileUtil.toFile((FileObject)this.localRoots[i]);
        }
        return roots;
    }

    private static String toUrl(String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        try {
            URI fileUri = new URI("file", "", ((String)path).replace("\\", "/"), null);
            String fileString = fileUri.toString();
            if (!fileString.endsWith("/")) {
                return fileString + "/";
            }
            return fileString;
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private URI toTripleSlashUri(URI inputUri) {
        if (!"file".equals(inputUri.getScheme()) || inputUri.getHost() != null) {
            return inputUri;
        }
        try {
            return new URI(inputUri.getScheme(), "", inputUri.getRawPath(), null);
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static final class ScriptContentLoader
    implements SourceContent {
        private final CDTScript script;
        private final CDTDebugger dbg;
        private String content;
        private final Object contentLock = new Object();
        private String contentLoadError;

        public ScriptContentLoader(CDTScript script, CDTDebugger dbg) {
            this.script = script;
            this.dbg = dbg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getContent() throws IOException {
            if (this.content != null) {
                return this.content;
            }
            GetScriptSourceRequest gssr = new GetScriptSourceRequest();
            gssr.setScriptId(this.script.getScriptId());
            this.dbg.getConnection().getDebugger().getScriptSource(gssr).handle((res, thr) -> {
                Object object = this.contentLock;
                synchronized (object) {
                    if (thr != null) {
                        this.contentLoadError = Bundle.ERR_ScriptFailedToLoad();
                    } else if (res == null || res.getScriptSource() == null) {
                        this.contentLoadError = Bundle.ERR_ScriptHasNoSource();
                    } else {
                        this.content = res.getScriptSource();
                    }
                    this.contentLock.notifyAll();
                }
                return null;
            });
            Object object = this.contentLock;
            synchronized (object) {
                if (this.content == null && this.contentLoadError == null) {
                    try {
                        this.contentLock.wait();
                    }
                    catch (InterruptedException iex) {
                        throw new IOException(Bundle.ERR_Interrupted(), iex);
                    }
                }
                if (this.contentLoadError != null) {
                    throw new IOException(this.contentLoadError);
                }
                return this.content;
            }
        }

        public long getLength() {
            if (this.content != null) {
                return this.content.length();
            }
            return this.script.getLength();
        }
    }
}

