/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.ElementTransformation;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TreeElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.codegen.CGSGenerator;
import org.netbeans.modules.php.editor.codegen.CodegenUtils;
import org.netbeans.modules.php.editor.codegen.MethodProperty;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.api.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class CGSInfo {
    private String className = null;
    private boolean hasConstructor;
    private final List<Property> properties = new ArrayList<Property>();
    private final List<Property> instanceProperties = new ArrayList<Property>();
    private final List<Property> possibleGetters = new ArrayList<Property>();
    private final List<Property> possibleSetters = new ArrayList<Property>();
    private final List<Property> possibleGettersSetters = new ArrayList<Property>();
    private final List<MethodProperty> possibleMethods = new ArrayList<MethodProperty>();
    private final JTextComponent textComp;
    private final PhpVersion phpVersion;
    private CGSGenerator.GenWay howToGenerate;
    private boolean generateDoc;
    private boolean fluentSetter;
    private boolean isPublicModifier;
    @NullAllowed
    private ElementQuery.Index index;

    private CGSInfo(JTextComponent textComp, PhpVersion phpVersion) {
        this.textComp = textComp;
        this.hasConstructor = false;
        this.generateDoc = true;
        this.fluentSetter = false;
        this.isPublicModifier = true;
        this.howToGenerate = CGSGenerator.GenWay.AS_JAVA;
        this.phpVersion = phpVersion != null ? phpVersion : PhpVersion.getDefault();
    }

    public static CGSInfo getCGSInfo(JTextComponent textComp) {
        PhpVersion phpVersion = null;
        FileObject file = NavUtils.getFile(textComp.getDocument());
        if (file != null) {
            phpVersion = CodeUtils.getPhpVersion(file);
        }
        return CGSInfo.getCGSInfo(textComp, phpVersion);
    }

    static CGSInfo getCGSInfo(JTextComponent textComp, PhpVersion phpVersion) {
        CGSInfo info = new CGSInfo(textComp, phpVersion);
        info.findPropertyInScope();
        return info;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Property> getInstanceProperties() {
        return this.instanceProperties;
    }

    public List<MethodProperty> getPossibleMethods() {
        return this.possibleMethods;
    }

    public List<Property> getPossibleGetters() {
        return this.possibleGetters;
    }

    public List<Property> getPossibleGettersSetters() {
        return this.possibleGettersSetters;
    }

    public List<Property> getPossibleSetters() {
        return this.possibleSetters;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean hasConstructor() {
        return this.hasConstructor;
    }

    public CGSGenerator.GenWay getHowToGenerate() {
        return this.howToGenerate;
    }

    public void setHowToGenerate(CGSGenerator.GenWay howGenerate) {
        this.howToGenerate = howGenerate;
    }

    public boolean isGenerateDoc() {
        return this.generateDoc;
    }

    public void setGenerateDoc(boolean generateDoc) {
        this.generateDoc = generateDoc;
    }

    public boolean isFluentSetter() {
        return this.fluentSetter;
    }

    public void setFluentSetter(boolean fluentSetter) {
        this.fluentSetter = fluentSetter;
    }

    public boolean isPublicModifier() {
        return this.isPublicModifier;
    }

    public void setPublicModifier(boolean isPublicModifier) {
        this.isPublicModifier = isPublicModifier;
    }

    public JTextComponent getComponent() {
        return this.textComp;
    }

    public PhpVersion getPhpVersion() {
        return this.phpVersion;
    }

    @CheckForNull
    public ElementQuery.Index getIndex() {
        return this.index;
    }

    public TypeNameResolver createTypeNameResolver(MethodElement method) {
        Model model;
        TypeNameResolver result = method.getParameters().isEmpty() ? TypeNameResolverImpl.forNull() : ((model = ModelUtils.getModel(Source.create((Document)this.getComponent().getDocument()), 300)) == null ? TypeNameResolverImpl.forNull() : CodegenUtils.createSmarterTypeNameResolver(method, model, this.getComponent().getCaretPosition()));
        return result;
    }

    private void findPropertyInScope() {
        FileObject file = NavUtils.getFile(this.textComp.getDocument());
        if (file == null) {
            return;
        }
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)this.textComp.getDocument())), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CGSInfo.this.initProperties(resultIterator);
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initProperties(ResultIterator resultIterator) throws ParseException {
        int caretOffset;
        ASTNode typeDecl;
        PHPParseResult info = (PHPParseResult)resultIterator.getParserResult();
        if (info != null && (typeDecl = this.findEnclosingType(info, caretOffset = this.textComp.getCaretPosition())) != null) {
            this.className = this.getTypeName(typeDecl);
            if (this.className != null) {
                FileObject fileObject = info.getSnapshot().getSource().getFileObject();
                this.index = ElementQueryFactory.getIndexQuery(info);
                ElementFilter forFilesFilter = ElementFilter.forFiles(fileObject);
                QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(this.className), caretOffset, info.getModel().getVariableScope(caretOffset));
                Set<TypeElement> types = forFilesFilter.filter(this.index.getTypes(NameKind.exact(fullyQualifiedName)));
                for (TypeElement typeElement : types) {
                    ElementFilter forNotDeclared = ElementFilter.forExcludedElements(this.index.getDeclaredMethods(typeElement));
                    HashSet<MethodElement> accessibleMethods = new HashSet<MethodElement>();
                    accessibleMethods.addAll(forNotDeclared.filter(this.index.getAccessibleMethods(typeElement, typeElement)));
                    if (typeElement instanceof ClassElement) {
                        accessibleMethods.addAll(ElementFilter.forExcludedElements(accessibleMethods).filter(forNotDeclared.filter(this.index.getConstructors((ClassElement)typeElement))));
                    }
                    accessibleMethods.addAll(ElementFilter.forExcludedElements(accessibleMethods).filter(forNotDeclared.filter(this.index.getAccessibleMagicMethods(typeElement))));
                    Set<TypeElement> preferedTypes = forFilesFilter.prefer(ElementTransformation.toMemberTypes().transform(accessibleMethods));
                    TreeElement<TypeElement> enclosingType = this.index.getInheritedTypesAsTree(typeElement, preferedTypes);
                    ArrayList<MethodProperty> methodProperties = new ArrayList<MethodProperty>();
                    Set methods = ElementFilter.forMembersOfTypes(preferedTypes).filter(accessibleMethods);
                    for (MethodElement methodElement : methods) {
                        if (methodElement.isFinal()) continue;
                        methodProperties.add(new MethodProperty(methodElement, enclosingType, this.phpVersion));
                    }
                    Collections.sort(methodProperties, MethodProperty.getComparator());
                    this.getPossibleMethods().addAll(methodProperties);
                }
            }
            ArrayList<String> existingGetters = new ArrayList<String>();
            ArrayList<String> existingSetters = new ArrayList<String>();
            PropertiesVisitor visitor = new PropertiesVisitor(existingGetters, existingSetters, Utils.getRoot(info));
            visitor.scan(typeDecl);
            if (typeDecl instanceof EnumDeclaration) {
                this.hasConstructor = true;
            }
            for (Property property : this.getProperties()) {
                String propertyName = property.getName().toLowerCase();
                boolean existGetter = existingGetters.contains(propertyName);
                boolean existSetter = existingSetters.contains(propertyName);
                if (!existGetter && !existSetter) {
                    this.getPossibleGettersSetters().add(property);
                    this.getPossibleGetters().add(property);
                    this.getPossibleSetters().add(property);
                    continue;
                }
                if (!existGetter) {
                    this.getPossibleGetters().add(property);
                    continue;
                }
                if (existSetter) continue;
                this.getPossibleSetters().add(property);
            }
        }
    }

    @CheckForNull
    private ASTNode findEnclosingType(ParserResult info, int offset) {
        List<ASTNode> nodes = NavUtils.underCaret(info, offset);
        int count = nodes.size();
        if (count > 2) {
            ASTNode declaration = nodes.get(count - 2);
            ASTNode block = nodes.get(count - 1);
            if (block instanceof Block && this.isValidEnclosingType(declaration)) {
                return declaration;
            }
        }
        return null;
    }

    private boolean isValidEnclosingType(ASTNode typeDeclaration) {
        return typeDeclaration instanceof ClassDeclaration || typeDeclaration instanceof TraitDeclaration || typeDeclaration instanceof EnumDeclaration || typeDeclaration instanceof ClassInstanceCreation && ((ClassInstanceCreation)typeDeclaration).isAnonymous();
    }

    @CheckForNull
    private String getTypeName(@NullAllowed ASTNode typeDeclaration) {
        if (typeDeclaration == null) {
            return null;
        }
        String typeName = null;
        if (typeDeclaration instanceof TypeDeclaration) {
            typeName = ((TypeDeclaration)typeDeclaration).getName().getName();
        } else if (typeDeclaration instanceof ClassInstanceCreation) {
            typeName = CodeUtils.extractClassName((ClassInstanceCreation)typeDeclaration);
        } else assert (false) : "Expected: TypeDeclaration or ClassInstanceCreation, but got" + String.valueOf(typeDeclaration.getClass());
        return typeName;
    }

    private class PropertiesVisitor
    extends DefaultVisitor {
        private final List<String> existingGetters;
        private final List<String> existingSetters;
        private final Program program;

        public PropertiesVisitor(List<String> existingGetters, List<String> existingSetters, Program program) {
            this.existingGetters = existingGetters;
            this.existingSetters = existingSetters;
            this.program = program;
        }

        @Override
        public void visit(FieldsDeclaration node) {
            List<SingleFieldDeclaration> fields = node.getFields();
            for (SingleFieldDeclaration singleFieldDeclaration : fields) {
                Variable variable = singleFieldDeclaration.getName();
                if (variable == null || !(variable.getName() instanceof Identifier)) continue;
                String name = ((Identifier)variable.getName()).getName();
                String type = this.getPropertyType(node, singleFieldDeclaration);
                Property property = new Property(name, node.getModifier(), type);
                if (!BodyDeclaration.Modifier.isStatic(node.getModifier())) {
                    CGSInfo.this.getInstanceProperties().add(property);
                }
                CGSInfo.this.getProperties().add(property);
            }
        }

        private String getPropertyType(FieldsDeclaration fieldsDeclaration, SingleFieldDeclaration singleFieldDeclaration) {
            Object type = "";
            if (fieldsDeclaration.getFieldType() == null || !CGSInfo.this.phpVersion.hasPropertyTypes()) {
                type = this.getPropertyType(singleFieldDeclaration);
            } else {
                if (fieldsDeclaration.getFieldType() instanceof UnionType) {
                    type = VariousUtils.getUnionType((UnionType)fieldsDeclaration.getFieldType());
                } else if (fieldsDeclaration.getFieldType() instanceof IntersectionType) {
                    type = VariousUtils.getIntersectionType((IntersectionType)fieldsDeclaration.getFieldType());
                } else {
                    QualifiedName qualifiedName = QualifiedName.create(fieldsDeclaration.getFieldType());
                    if (qualifiedName != null) {
                        type = qualifiedName.toString();
                        if (fieldsDeclaration.getFieldType() instanceof NullableType) {
                            type = "?" + (String)type;
                        }
                    }
                }
                assert (!((String)type).isEmpty()) : "couldn't get the qualified name from the field type(" + String.valueOf(fieldsDeclaration.getFieldType()) + ")";
            }
            return type;
        }

        private String getPropertyType(ASTNode node) {
            String result = "";
            Comment comment = Utils.getCommentForNode(this.program, node);
            if (comment instanceof PHPDocBlock) {
                result = this.getFirstTypeFromBlock((PHPDocBlock)comment);
            }
            return result;
        }

        private String getFirstTypeFromBlock(PHPDocBlock phpDoc) {
            String result = "";
            for (PHPDocTag pHPDocTag : phpDoc.getTags()) {
                if (pHPDocTag instanceof PHPDocTypeTag && pHPDocTag.getKind().equals((Object)PHPDocTag.Type.VAR) && !(result = this.getFirstTypeFromTag((PHPDocTypeTag)pHPDocTag)).isEmpty()) break;
            }
            return result;
        }

        private String getFirstTypeFromTag(PHPDocTypeTag typeTag) {
            boolean canBeNull = this.canBeNull(typeTag);
            Object result = "";
            for (PHPDocTypeNode typeNode : typeTag.getTypes()) {
                String type = typeNode.getValue();
                if (CGSInfo.this.phpVersion.hasScalarAndReturnTypes() && !VariousUtils.isSpecialClassName(type) && !Type.isInvalidPropertyType(type)) {
                    Object object = result = typeNode.isArray() ? "array" : type;
                    if (!canBeNull || !CGSInfo.this.phpVersion.hasNullableTypes()) break;
                    result = "?" + (String)result;
                    break;
                }
                if (Type.isPrimitive(type) || VariousUtils.isSpecialClassName(type)) continue;
                result = typeNode.isArray() ? "array" : type;
                break;
            }
            return result;
        }

        private boolean canBeNull(PHPDocTypeTag typeTag) {
            boolean canBeNull = false;
            if (typeTag.getTypes().size() > 1) {
                for (PHPDocTypeNode typeNode : typeTag.getTypes()) {
                    String type = typeNode.getValue().toLowerCase(Locale.ROOT);
                    if (!type.equals("null")) continue;
                    canBeNull = true;
                    break;
                }
            }
            return canBeNull;
        }

        @Override
        public void visit(MethodDeclaration node) {
            String name = node.getFunction().getFunctionName().getName();
            if (CodeUtils.isConstructor(node)) {
                for (FormalParameter parameter : node.getFunction().getFormalParameters()) {
                    FieldsDeclaration fieldsDeclaration = FieldsDeclaration.create(parameter);
                    if (fieldsDeclaration == null) continue;
                    this.scan(fieldsDeclaration);
                }
            }
            if (name != null) {
                if (name.startsWith("get")) {
                    String possibleProperty = name.substring("get".length());
                    this.existingGetters.addAll(this.getAllPossibleProperties(possibleProperty));
                } else if (name.startsWith("set")) {
                    String possibleProperty = name.substring("get".length());
                    this.existingSetters.addAll(this.getAllPossibleProperties(possibleProperty));
                } else if (CGSInfo.this.className != null && (CGSInfo.this.className.equals(name) || "__construct".equals(name))) {
                    CGSInfo.this.hasConstructor = true;
                }
            }
        }

        private List<String> getAllPossibleProperties(String possibleProperty) {
            LinkedList<String> allPossibleProperties = new LinkedList<String>();
            String lowerCasePossibleProperty = possibleProperty.toLowerCase(Locale.ROOT);
            allPossibleProperties.add(lowerCasePossibleProperty);
            if (lowerCasePossibleProperty.startsWith("_")) {
                allPossibleProperties.add(lowerCasePossibleProperty.substring(1));
            } else {
                allPossibleProperties.add("_" + lowerCasePossibleProperty);
            }
            return allPossibleProperties;
        }
    }
}

