/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

enum Progress {
    COMPUTE_INSTANCES,
    COMPUTE_REFERENCES,
    FILL_HEAP_TAG_BOUNDS,
    COMPUTE_GC_ROOTS;

    private static List<Listener> listeners;

    Handle start() {
        return new Handle(this);
    }

    static synchronized void register(Listener onChange) {
        if (listeners.isEmpty()) {
            listeners = Collections.singletonList(onChange);
        } else {
            ArrayList<Listener> copy = new ArrayList<Listener>(listeners);
            copy.add(onChange);
            listeners = copy;
        }
    }

    private static synchronized void notifyUpdates(Handle h, Type type) {
        block4: for (Listener onChange : listeners) {
            switch (type.ordinal()) {
                case 0: {
                    onChange.started(h);
                    continue block4;
                }
                case 1: {
                    onChange.progress(h);
                    continue block4;
                }
            }
            onChange.finished(h);
        }
    }

    static {
        listeners = Collections.emptyList();
    }

    static final class Handle
    implements AutoCloseable {
        final Progress type;
        private long value;
        private long startOffset;
        private long endOffset;

        private Handle(Progress type) {
            this.type = type;
            Progress.notifyUpdates(this, Type.STARTED);
        }

        void progress(long value, long endValue) {
            this.progress(value, 0L, value, endValue);
        }

        void progress(long counter, long startOffset, long value, long endOffset) {
            if (counter % 100000L == 0L) {
                this.doProgress(value, startOffset, endOffset);
            }
        }

        @Override
        public void close() {
            Progress.notifyUpdates(this, Type.FINISHED);
        }

        private void doProgress(long value, long startOffset, long endOffset) {
            this.value = value;
            this.endOffset = endOffset;
            this.startOffset = startOffset;
            Progress.notifyUpdates(this, Type.PROGRESS);
        }

        long getValue() {
            return this.value;
        }

        long getStartOffset() {
            return this.startOffset;
        }

        long getEndOffset() {
            return this.endOffset;
        }
    }

    private static enum Type {
        STARTED,
        PROGRESS,
        FINISHED;

    }

    static interface Listener {
        public void started(Handle var1);

        public void progress(Handle var1);

        public void finished(Handle var1);
    }
}

