/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.crlf;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.impl.crlf.Bundle;
import org.openide.awt.StatusLineElementProvider;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;

public class CRLFStatus {
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    private static final JLabel GLOBAL_CRLF = new JLabel("    ");
    private static final Map<String, String> LINE_ENDINGS_DN = new HashMap<String, String>();
    private static final String UNKNOWN = Bundle.LBL_Unknown();

    private static void updateCRLFComponent() {
        JTextComponent comp = EditorRegistry.focusedComponent();
        if (comp != null) {
            CRLFStatus.showLE(comp.getDocument(), GLOBAL_CRLF);
        } else {
            GLOBAL_CRLF.setText("    ");
        }
    }

    private static void showLE(Document doc, JLabel l) {
        String dn = LINE_ENDINGS_DN.get(doc.getProperty("__EndOfLine__"));
        if (dn == null) {
            dn = UNKNOWN;
        }
        l.setText(dn);
    }

    private static void initMinDimension(Iterable<? extends String> maxStrings) {
        FontMetrics fm = GLOBAL_CRLF.getFontMetrics(GLOBAL_CRLF.getFont());
        int minWidth = 0;
        for (String string : maxStrings) {
            minWidth = Math.max(minWidth, fm.stringWidth(string));
        }
        Border b = GLOBAL_CRLF.getBorder();
        Insets insets = b != null ? b.getBorderInsets(GLOBAL_CRLF) : NULL_INSETS;
        int minHeight = fm.getHeight() + insets.top + insets.bottom;
        GLOBAL_CRLF.setMinimumSize(new Dimension(minWidth += insets.left + insets.right, minHeight));
        GLOBAL_CRLF.setPreferredSize(new Dimension(minWidth, minHeight));
    }

    static Component panelWithSeparator(JLabel cell) {
        JSeparator separator = new JSeparator(1){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(3, 3);
            }
        };
        separator.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)separator, "West");
        panel.add(cell);
        return panel;
    }

    static {
        LINE_ENDINGS_DN.put("\r", Bundle.LBL_CR());
        LINE_ENDINGS_DN.put("\r\n", Bundle.LBL_CRLF());
        LINE_ENDINGS_DN.put("\n", Bundle.LBL_LF());
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CRLFStatus.updateCRLFComponent();
            }
        });
        GLOBAL_CRLF.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                final JTextComponent comp = EditorRegistry.focusedComponent();
                if (comp == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                final JList<Object> l = new JList<Object>();
                DefaultListModel<String> model = new DefaultListModel<String>();
                for (String k : LINE_ENDINGS_DN.keySet()) {
                    model.addElement(k);
                }
                l.setModel(model);
                l.setSelectedValue(comp.getDocument().getProperty("__EndOfLine__"), true);
                l.setCellRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        return super.getListCellRendererComponent((JList<?>)list, LINE_ENDINGS_DN.get(value), index, isSelected, cellHasFocus);
                    }
                });
                l.setBorder(new LineBorder(Color.GRAY, 1));
                Point labelStart = GLOBAL_CRLF.getLocationOnScreen();
                int x = Math.min(labelStart.x, labelStart.x + GLOBAL_CRLF.getSize().width - l.getPreferredSize().width);
                int y = labelStart.y - l.getPreferredSize().height;
                final Popup popup = PopupFactory.getSharedInstance().getPopup(GLOBAL_CRLF, l, x, y);
                AWTEventListener multicastListener = new AWTEventListener(){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void eventDispatched(AWTEvent event) {
                        if (event instanceof MouseEvent && ((MouseEvent)event).getClickCount() > 0) {
                            popup.hide();
                            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                        }
                    }
                };
                Toolkit.getDefaultToolkit().addAWTEventListener(multicastListener, 16L);
                l.addListSelectionListener(new ListSelectionListener(){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        comp.getDocument().putProperty("__EndOfLine__", l.getSelectedValue());
                        DataObject dataObject = NbEditorUtilities.getDataObject(comp.getDocument());
                        if (dataObject != null) {
                            try {
                                EditorCookie ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                                Method notifyModified = CloneableEditorSupport.class.getDeclaredMethod("callNotifyModified", new Class[0]);
                                notifyModified.setAccessible(true);
                                notifyModified.invoke((Object)ec, new Object[0]);
                            }
                            catch (ReflectiveOperationException | SecurityException ex) {
                                Logger.getLogger(CRLFStatus.class.getName()).log(Level.FINE, null, ex);
                            }
                        }
                        CRLFStatus.showLE(comp.getDocument(), GLOBAL_CRLF);
                    }
                });
                popup.show();
            }
        });
        ArrayList<String> dimensions = new ArrayList<String>(LINE_ENDINGS_DN.values());
        dimensions.add(UNKNOWN);
        CRLFStatus.initMinDimension(dimensions);
    }

    public static final class StatusLineElementProviderImpl
    implements StatusLineElementProvider {
        public Component getStatusLineElement() {
            return CRLFStatus.panelWithSeparator(GLOBAL_CRLF);
        }
    }
}

