/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.project.api.ClientSideDevelopmentSupport;
import org.netbeans.modules.javaee.project.api.WhiteListUpdater;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.CopyOnSave;
import org.netbeans.modules.maven.j2ee.execution.ExecutionChecker;
import org.netbeans.modules.maven.j2ee.utils.LoggingUtils;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.common.api.CssPreprocessors;
import org.netbeans.modules.web.common.api.CssPreprocessorsListener;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class ProjectHookImpl
extends ProjectOpenedHook {
    private static final RequestProcessor RP = new RequestProcessor(ProjectHookImpl.class);
    private final Project project;
    private PreferenceChangeListener preferencesListener;
    private PropertyChangeListener refreshListener;
    private J2eeModuleProvider lastJ2eeProvider;
    private Preferences preferences;
    private final WindowSystemListener windowSystemListener = new WindowSystemListener(){

        public void beforeLoad(WindowSystemEvent event) {
        }

        public void afterLoad(WindowSystemEvent event) {
        }

        public void beforeSave(WindowSystemEvent event) {
            ClientSideDevelopmentSupport clientSideSupport = (ClientSideDevelopmentSupport)ProjectHookImpl.this.project.getLookup().lookup(ClientSideDevelopmentSupport.class);
            if (clientSideSupport != null) {
                clientSideSupport.close();
            }
        }

        public void afterSave(WindowSystemEvent event) {
        }
    };

    public ProjectHookImpl(Project project) {
        this.project = project;
    }

    protected void projectOpened() {
        WhiteListUpdater whiteListUpdater;
        CssPreprocessorsListener cssSupport;
        MavenProjectSupport.changeServer(this.project, false);
        CopyOnSave copyOnSave = (CopyOnSave)this.project.getLookup().lookup(CopyOnSave.class);
        if (copyOnSave != null) {
            copyOnSave.initialize();
        }
        if ((cssSupport = (CssPreprocessorsListener)this.project.getLookup().lookup(CssPreprocessorsListener.class)) != null) {
            CssPreprocessors.getDefault().addCssPreprocessorsListener(cssSupport);
        }
        if (this.refreshListener == null) {
            NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            this.refreshListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        MavenProjectSupport.changeServer(ProjectHookImpl.this.project, false);
                    }
                }
            };
            watcher.addPropertyChangeListener(this.refreshListener);
        }
        if ((whiteListUpdater = (WhiteListUpdater)this.project.getLookup().lookup(WhiteListUpdater.class)) != null) {
            whiteListUpdater.checkWhiteLists();
        }
        if (this.preferencesListener == null) {
            this.preferencesListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    WhiteListUpdater whiteListUpdater;
                    ClientSideDevelopmentSupport clientSideSupport;
                    if ("netbeans.selected.browser".equals(evt.getKey()) && (clientSideSupport = (ClientSideDevelopmentSupport)ProjectHookImpl.this.project.getLookup().lookup(ClientSideDevelopmentSupport.class)) != null) {
                        clientSideSupport.resetBrowserSupport();
                    }
                    if ("netbeans.deployment.server.id".equals(evt.getKey()) && (whiteListUpdater = (WhiteListUpdater)ProjectHookImpl.this.project.getLookup().lookup(WhiteListUpdater.class)) != null) {
                        whiteListUpdater.checkWhiteLists();
                    }
                }
            };
            this.getPreferences().addPreferenceChangeListener(this.preferencesListener);
        }
        WindowManager windowManager = WindowManager.getDefault();
        windowManager.addWindowSystemListener((WindowSystemListener)WeakListeners.create(WindowSystemListener.class, (EventListener)this.windowSystemListener, (Object)windowManager));
        RP.post(new Runnable(){

            @Override
            public void run() {
                LoggingUtils.logUsage(ExecutionChecker.class, "USG_PROJECT_OPEN_MAVEN_EE", new Object[]{ProjectHookImpl.this.getServerName(), ProjectHookImpl.this.getEEversion(), ProjectHookImpl.this.getProjectType()}, "maven");
            }
        });
    }

    protected void projectClosed() {
        ClientSideDevelopmentSupport clientSideSupport;
        CssPreprocessorsListener cssSupport;
        CopyOnSave copyOnSave;
        if (this.refreshListener != null) {
            NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watcher.removePropertyChangeListener(this.refreshListener);
            this.refreshListener = null;
        }
        if (this.preferencesListener != null) {
            this.getPreferences().removePreferenceChangeListener(this.preferencesListener);
            this.preferencesListener = null;
        }
        if (this.lastJ2eeProvider != null) {
            Deployment.getDefault().disableCompileOnSaveSupport(this.lastJ2eeProvider);
            this.lastJ2eeProvider = null;
        }
        if ((copyOnSave = (CopyOnSave)this.project.getLookup().lookup(CopyOnSave.class)) != null) {
            copyOnSave.cleanup();
        }
        if ((cssSupport = (CssPreprocessorsListener)this.project.getLookup().lookup(CssPreprocessorsListener.class)) != null) {
            CssPreprocessors.getDefault().removeCssPreprocessorsListener(cssSupport);
        }
        if ((clientSideSupport = (ClientSideDevelopmentSupport)this.project.getLookup().lookup(ClientSideDevelopmentSupport.class)) != null) {
            clientSideSupport.close();
        }
    }

    private Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = MavenProjectSupport.getPreferences(this.project, false);
        }
        return this.preferences;
    }

    private String getServerName() {
        String serverName = MavenProjectSupport.obtainServerName(this.project);
        if (serverName == null) {
            serverName = NbBundle.getMessage(ProjectHookImpl.class, (String)"MSG_No_Server");
        }
        return serverName;
    }

    private String getEEversion() {
        Profile profile = null;
        String projectType = this.getProjectType();
        if (projectType != null) {
            switch (projectType) {
                case "ear": {
                    Ear earProj = Ear.getEar((FileObject)this.project.getProjectDirectory());
                    if (earProj == null) break;
                    profile = earProj.getJ2eeProfile();
                    break;
                }
                case "war": {
                    WebModule webM = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
                    if (webM == null) break;
                    profile = webM.getJ2eeProfile();
                    break;
                }
                case "ejb": {
                    EjbJar ejbProj = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
                    if (ejbProj == null) break;
                    profile = ejbProj.getJ2eeProfile();
                }
            }
        }
        if (profile != null) {
            return profile.toPropertiesString();
        }
        return NbBundle.getMessage(ProjectHookImpl.class, (String)"TXT_UnknownEEVersion");
    }

    private String getProjectType() {
        NbMavenProject mavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (mavenProject != null) {
            return mavenProject.getPackagingType();
        }
        return null;
    }
}

