/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.support;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.LibrariesHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.SoapClientJavaOperationInfo;
import org.netbeans.modules.websvc.saas.codegen.java.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.RestClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class JavaUtil {
    private static final String JAXB_LIB = "jaxb";
    public static final Modifier[] PUBLIC = new Modifier[]{Modifier.PUBLIC};
    public static final Modifier[] PRIVATE = new Modifier[]{Modifier.PRIVATE};
    public static final Modifier[] PROTECTED = new Modifier[]{Modifier.PROTECTED};
    public static final Modifier[] PRIVATE_STATIC = new Modifier[]{Modifier.PRIVATE, Modifier.STATIC};
    public static final Modifier[] PUBLIC_STATIC = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
    public static final Modifier[] PUBLIC_STATIC_FINAL = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL};

    public static boolean isJava(DataObject d) {
        return d != null && "java".equals(d.getPrimaryFile().getExt());
    }

    public static SourceGroup getClassSourceGroup(Project project, String fqClassName) {
        SourceGroup[] sourceGroups;
        String classFile = fqClassName.replace('.', '/') + "." + "java";
        for (SourceGroup sourceGroup : sourceGroups = SourceGroupSupport.getJavaSourceGroups(project)) {
            FileObject classFO = sourceGroup.getRootFolder().getFileObject(classFile);
            if (classFO == null) continue;
            return sourceGroup;
        }
        return null;
    }

    public static SourceGroup[] getSourceGroups(Project project) {
        SourceGroup[] sourceGroups = null;
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] docRoot = sources.getSourceGroups("doc_root");
        SourceGroup[] srcRoots = SourceGroupSupport.getJavaSourceGroups(project);
        if (docRoot != null && srcRoots != null) {
            sourceGroups = new SourceGroup[docRoot.length + srcRoots.length];
            System.arraycopy(docRoot, 0, sourceGroups, 0, docRoot.length);
            System.arraycopy(srcRoots, 0, sourceGroups, docRoot.length, srcRoots.length);
        }
        if (sourceGroups == null || sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("generic");
        }
        return sourceGroups;
    }

    public static boolean isProjectOpened(Project p) {
        if (OpenProjects.getDefault() == null) {
            return true;
        }
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].equals((Object)p)) continue;
            return true;
        }
        return false;
    }

    public static void addClientJars(SaasBean bean, Project p, FileObject target) throws IOException {
        if (bean instanceof RestClientSaasBean) {
            if (p == null || bean == null || ((RestClientSaasBean)bean).getMethod() == null) {
                throw new IllegalArgumentException("Cannot create JAXB classes, since project|bean is null.");
            }
            LibrariesHelper.addClientJars(p, target, ((RestClientSaasBean)bean).getMethod().getSaas());
        }
    }

    @Deprecated
    public static void addJaxbLib(Project p) throws IOException {
    }

    public static void addImportsToSource(JavaSource source, List<String> imports) throws IOException {
        for (final String imp : imports) {
            ModificationResult result = source.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

                public void run(WorkingCopy copy) throws IOException {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    JavaSourceHelper.addImports(copy, new String[]{imp});
                }
            });
            result.commit();
        }
    }

    public static void addInputParamField(JavaSource source, final ParameterInfo p, final String[] annotations, final Object[] annotationAttrs) throws IOException {
        ModificationResult result = source.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy copy) throws IOException {
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree initial = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                ClassTree modifiedTree = JavaSourceHelper.addField(copy, initial, PRIVATE, annotations, annotationAttrs, Util.getParameterName((ParameterInfo)p, (boolean)true, (boolean)true, (boolean)true), p.getTypeName(), Util.getParamValue((ParameterInfo)p));
                copy.rewrite((Tree)initial, (Tree)modifiedTree);
            }
        });
        result.commit();
    }

    public static void addInputParamFields(JavaSource source, final List<ParameterInfo> params) throws IOException {
        ModificationResult result = source.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy copy) throws IOException {
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                JavaSourceHelper.addFields(copy, Util.getParamNames((List)params), Util.getParamTypeNames((List)params), Util.getParamValues((List)params));
            }
        });
        result.commit();
    }

    public static void addInputParamFields(JavaSource source, final List<ParameterInfo> params, final Modifier[] modifier) throws IOException {
        ModificationResult result = source.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy copy) throws IOException {
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ArrayList<ParameterInfo> addList = new ArrayList<ParameterInfo>();
                for (ParameterInfo p : params) {
                    if (JavaSourceHelper.getField((CompilationController)copy, Util.getParameterName((ParameterInfo)p, (boolean)true, (boolean)true, (boolean)true)) != null) continue;
                    addList.add(p);
                }
                JavaSourceHelper.addFields(copy, Util.getParamNames(addList), Util.getParamTypeNames(addList), Util.getParamValues(addList), modifier);
            }
        });
        result.commit();
    }

    public static Class getType(Project project, String typeName) {
        List<ClassPath> classPaths = SourceGroupSupport.gerClassPath(project);
        for (ClassPath cp : classPaths) {
            try {
                Class ret = Util.getPrimitiveType((String)typeName);
                if (ret != null) {
                    return ret;
                }
                ClassLoader cl = cp.getClassLoader(true);
                ret = Util.getGenericRawType((String)typeName, (ClassLoader)cl);
                if (ret != null) {
                    return ret;
                }
                if (cl == null) continue;
                return cl.loadClass(typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public static SoapClientJavaOperationInfo[] toJaxwsOperationInfos(WsdlSaasMethod m, Project project) {
        ArrayList<SoapClientJavaOperationInfo> infos = new ArrayList<SoapClientJavaOperationInfo>();
        infos.add(new SoapClientJavaOperationInfo(m, project));
        return infos.toArray(new SoapClientJavaOperationInfo[0]);
    }
}

