/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;

abstract class DeployData {
    private static final Logger LOG = Logger.getLogger(DeployData.class.getName());
    WebApp webApp = null;
    String className = null;
    boolean makeEntry = true;
    FileObject ddObject = null;

    DeployData() {
    }

    void setWebApp(FileObject fo) {
        LOG.finer("setWebApp()");
        this.ddObject = fo;
        if (fo == null) {
            this.webApp = null;
            return;
        }
        try {
            this.webApp = DDProvider.getDefault().getDDRoot(fo);
            LOG.finer("webApp = " + this.webApp);
        }
        catch (IOException ioex) {
            LOG.log(Level.FINE, "Couldn't get the web app!", ioex);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Couldn't get the web app!", ex);
        }
    }

    String getClassName() {
        if (this.className == null) {
            return "";
        }
        return this.className;
    }

    void setClassName(String name) {
        this.className = name;
    }

    boolean makeEntry() {
        return this.makeEntry;
    }

    void setMakeEntry(boolean makeEntry) {
        this.makeEntry = makeEntry;
    }

    void writeChanges() throws IOException {
        LOG.finer("writeChanges()");
        if (this.webApp == null) {
            return;
        }
        LOG.finer("now writing...");
        this.webApp.write(this.ddObject);
    }

    abstract boolean isValid();

    abstract void createDDEntries();

    abstract String getErrorMessage();

    public static FileObject getWebAppFor(FileObject folder) {
        if (folder == null) {
            return null;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)folder);
        if (webModule == null) {
            return null;
        }
        return webModule.getDeploymentDescriptor();
    }

    public boolean hasDD() {
        return this.webApp != null;
    }
}

