/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.client.ClientJavaSourceHelper;
import org.netbeans.modules.websvc.rest.client.RESTResourcesPanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RESTClientGenerator
implements CodeGenerator {
    private FileObject targetSource;
    private JTextComponent targetComponent;

    RESTClientGenerator(FileObject targetSource, JTextComponent targetComponent) {
        this.targetSource = targetSource;
        this.targetComponent = targetComponent;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RESTClientGenerator.class, (String)"LBL_GenerateRESTClient");
    }

    public void invoke() {
        Node resourceNode;
        RESTResourcesPanel resourcesPanel = new RESTResourcesPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)resourcesPanel, NbBundle.getMessage(RESTClientGenerator.class, (String)"TTL_RESTResources"));
        resourcesPanel.setDescriptor(descriptor);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor).equals(NotifyDescriptor.OK_OPTION) && (resourceNode = resourcesPanel.getResourceNode()) != null) {
            ClientJavaSourceHelper.generateJerseyClient(resourceNode, this.targetSource, resourcesPanel.getClassName(), resourcesPanel.getSecurity());
            Object[] params = new Object[]{"JAX-RS", "GENERATE REST RESOURCE"};
            LogUtils.logWsAction((Object[])params);
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            ArrayList<RESTClientGenerator> ret = new ArrayList<RESTClientGenerator>();
            if (controller != null) {
                try {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    FileObject targetSource = controller.getFileObject();
                    if (targetSource != null) {
                        JTextComponent targetComponent = (JTextComponent)context.lookup(JTextComponent.class);
                        ret.add(new RESTClientGenerator(targetSource, targetComponent));
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return ret;
        }
    }
}

