/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.spec;

import java.security.spec.KeySpec;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;

public class EdDSAPublicKeySpec
implements KeySpec {
    private final GroupElement A;
    private final GroupElement Aneg;
    private final EdDSAParameterSpec spec;

    public EdDSAPublicKeySpec(byte[] byArray, EdDSAParameterSpec edDSAParameterSpec) {
        if (byArray.length != edDSAParameterSpec.getCurve().getField().getb() / 8) {
            throw new IllegalArgumentException("public-key length is wrong");
        }
        this.A = new GroupElement(edDSAParameterSpec.getCurve(), byArray);
        this.Aneg = this.A.negate();
        this.Aneg.precompute(false);
        this.spec = edDSAParameterSpec;
    }

    public EdDSAPublicKeySpec(GroupElement groupElement, EdDSAParameterSpec edDSAParameterSpec) {
        this.A = groupElement;
        this.Aneg = groupElement.negate();
        this.Aneg.precompute(false);
        this.spec = edDSAParameterSpec;
    }

    public GroupElement getA() {
        return this.A;
    }

    public GroupElement getNegativeA() {
        return this.Aneg;
    }

    public EdDSAParameterSpec getParams() {
        return this.spec;
    }
}

