/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.TemporalType;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindingTypeResolver;
import org.hibernate.query.spi.QueryParameterBindingValidator;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.expression.NullSqmExpressible;
import org.hibernate.type.BindableType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.internal.BindingTypeHelper;
import org.hibernate.type.spi.TypeConfiguration;

public class QueryParameterBindingImpl<T>
implements QueryParameterBinding<T>,
JavaType.CoercionContext {
    private final QueryParameter<T> queryParameter;
    private final SessionFactoryImplementor sessionFactory;
    private boolean isBound;
    private boolean isMultiValued;
    private BindableType<? super T> bindType;
    private MappingModelExpressible<T> type;
    private TemporalType explicitTemporalPrecision;
    private Object bindValue;
    private Collection<? extends T> bindValues;

    protected QueryParameterBindingImpl(QueryParameter<T> queryParameter, SessionFactoryImplementor sessionFactory) {
        this(queryParameter, sessionFactory, queryParameter.getHibernateType());
    }

    public QueryParameterBindingImpl(QueryParameter<T> queryParameter, SessionFactoryImplementor sessionFactory, BindableType<? super T> bindType) {
        this.queryParameter = queryParameter;
        this.sessionFactory = sessionFactory;
        this.bindType = bindType;
    }

    private QueryParameterBindingTypeResolver getParameterBindingTypeResolver() {
        return this.sessionFactory.getMappingMetamodel();
    }

    @Override
    public BindableType<? super T> getBindType() {
        return this.bindType;
    }

    @Override
    public TemporalType getExplicitTemporalPrecision() {
        return this.explicitTemporalPrecision;
    }

    @Override
    public boolean isBound() {
        return this.isBound;
    }

    @Override
    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    @Override
    public QueryParameter<T> getQueryParameter() {
        return this.queryParameter;
    }

    private NodeBuilder getCriteriaBuilder() {
        return this.sessionFactory.getQueryEngine().getCriteriaBuilder();
    }

    @Override
    public T getBindValue() {
        if (this.isMultiValued) {
            throw new IllegalStateException("Binding is multi-valued; illegal call to #getBindValue");
        }
        return (T)this.bindValue;
    }

    @Override
    public void setBindValue(T value, boolean resolveJdbcTypeIfNecessary) {
        if (!this.handleAsMultiValue(value, null)) {
            Object coerced = this.coerceIfNotJpa(value);
            this.validate(coerced);
            if (value == null) {
                this.bindNull(resolveJdbcTypeIfNecessary);
            } else {
                this.bindValue(coerced);
            }
        }
    }

    private void bindNull(boolean resolveJdbcTypeIfNecessary) {
        this.isBound = true;
        this.bindValue = null;
        if (resolveJdbcTypeIfNecessary && this.bindType == null) {
            this.bindType = this.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType("null");
        }
    }

    private boolean handleAsMultiValue(T value, BindableType<T> bindableType) {
        if (this.queryParameter.allowsMultiValuedBinding() && value instanceof Collection && !(bindableType != null ? bindableType.getJavaType().isInstance(value) : this.isRegisteredAsBasicType(value.getClass()))) {
            this.setBindValues((Collection)value);
            return true;
        }
        return false;
    }

    private boolean isRegisteredAsBasicType(Class<?> valueClass) {
        return this.getTypeConfiguration().getBasicTypeForJavaType(valueClass) != null;
    }

    private void bindValue(Object value) {
        this.isBound = true;
        this.bindValue = value;
        if (QueryParameterBindingImpl.canBindValueBeSet(value, this.bindType)) {
            this.bindType = this.getParameterBindingTypeResolver().resolveParameterBindType(value);
        }
    }

    @Override
    public void setBindValue(T value, BindableType<T> clarifiedType) {
        if (!this.handleAsMultiValue(value, clarifiedType)) {
            if (clarifiedType != null) {
                this.bindType = clarifiedType;
            }
            Object coerced = this.coerce(value);
            this.validate(coerced, clarifiedType);
            this.bindValue(coerced);
        }
    }

    @Override
    public void setBindValue(T value, TemporalType temporalTypePrecision) {
        if (!this.handleAsMultiValue(value, null)) {
            if (this.bindType == null) {
                this.bindType = this.queryParameter.getHibernateType();
            }
            Object coerced = this.coerceIfNotJpa(value);
            this.validate(coerced, temporalTypePrecision);
            this.bindValue(coerced);
            this.setExplicitTemporalPrecision(temporalTypePrecision);
        }
    }

    @Override
    public Collection<? extends T> getBindValues() {
        if (!this.isMultiValued) {
            throw new IllegalStateException("Binding is not multi-valued; illegal call to #getBindValues");
        }
        return this.bindValues;
    }

    @Override
    public void setBindValues(Collection<? extends T> values) {
        if (!this.queryParameter.allowsMultiValuedBinding()) {
            throw new IllegalArgumentException("Illegal attempt to bind a collection value to a single-valued parameter");
        }
        this.isBound = true;
        this.isMultiValued = true;
        this.bindValue = null;
        this.bindValues = values;
        Iterator<T> iterator = values.iterator();
        Object value = null;
        while (value == null && iterator.hasNext()) {
            value = iterator.next();
        }
        if (QueryParameterBindingImpl.canBindValueBeSet(value, this.bindType)) {
            this.bindType = this.getParameterBindingTypeResolver().resolveParameterBindType(value);
        }
    }

    @Override
    public void setBindValues(Collection<? extends T> values, BindableType<T> clarifiedType) {
        if (clarifiedType != null) {
            this.bindType = clarifiedType;
        }
        this.setBindValues(values);
    }

    @Override
    public void setBindValues(Collection<? extends T> values, TemporalType temporalTypePrecision, TypeConfiguration typeConfiguration) {
        this.setBindValues(values);
        this.setExplicitTemporalPrecision(temporalTypePrecision);
    }

    private void setExplicitTemporalPrecision(TemporalType precision) {
        this.explicitTemporalPrecision = precision;
        if (this.bindType == null || JavaTypeHelper.isTemporal(this.determineJavaType(this.bindType))) {
            this.bindType = BindingTypeHelper.resolveTemporalPrecision(precision, this.bindType, this.getCriteriaBuilder());
        }
    }

    private JavaType<? super T> determineJavaType(BindableType<? super T> bindType) {
        SqmBindableType sqmExpressible = this.getCriteriaBuilder().resolveExpressible(bindType);
        assert (sqmExpressible != null);
        return sqmExpressible.getExpressibleJavaType();
    }

    @Override
    public MappingModelExpressible<T> getType() {
        return this.type;
    }

    @Override
    public boolean setType(MappingModelExpressible<T> type) {
        this.type = type;
        if (this.bindType == null || this.bindType.getJavaType() == Object.class || type instanceof ModelPart) {
            BasicValuedMapping basicValuedMapping;
            JdbcMapping jdbcMapping;
            if (type instanceof BindableType) {
                boolean changed = this.bindType != null && type != this.bindType;
                this.bindType = (BindableType)((Object)type);
                return changed;
            }
            if (type instanceof BasicValuedMapping && (jdbcMapping = (basicValuedMapping = (BasicValuedMapping)type).getJdbcMapping()) instanceof BindableType) {
                boolean changed = this.bindType != null && jdbcMapping != this.bindType;
                this.bindType = (BindableType)((Object)jdbcMapping);
                return changed;
            }
        }
        return false;
    }

    private void validate(Object value) {
        QueryParameterBindingValidator.INSTANCE.validate(this.getBindType(), value, this.getCriteriaBuilder());
    }

    private void validate(Object value, BindableType<?> clarifiedType) {
        QueryParameterBindingValidator.INSTANCE.validate(clarifiedType, value, this.getCriteriaBuilder());
    }

    private void validate(Object value, TemporalType clarifiedTemporalType) {
        QueryParameterBindingValidator.INSTANCE.validate(this.getBindType(), value, clarifiedTemporalType, this.getCriteriaBuilder());
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.sessionFactory.getTypeConfiguration();
    }

    private Object coerceIfNotJpa(T value) {
        return this.sessionFactory.getSessionFactoryOptions().getJpaCompliance().isLoadByIdComplianceEnabled() ? value : this.coerce(value);
    }

    private Object coerce(T value) {
        try {
            if (QueryParameterBindingImpl.canValueBeCoerced(this.bindType)) {
                return this.coerce(value, this.bindType);
            }
            if (QueryParameterBindingImpl.canValueBeCoerced(this.queryParameter.getHibernateType())) {
                return this.coerce(value, this.queryParameter.getHibernateType());
            }
            return value;
        }
        catch (HibernateException ex) {
            throw new IllegalArgumentException(String.format("Parameter value [%s] did not match expected type [%s]", value, this.bindType), (Throwable)((Object)ex));
        }
    }

    private Object coerce(T value, BindableType<? super T> parameterType) {
        if (value == null) {
            return null;
        }
        SqmBindableType sqmExpressible = this.getCriteriaBuilder().resolveExpressible(parameterType);
        assert (sqmExpressible != null);
        return sqmExpressible.getExpressibleJavaType().coerce(value, this);
    }

    private static boolean canValueBeCoerced(BindableType<?> bindType) {
        return bindType != null && !(bindType instanceof NullSqmExpressible);
    }

    private static boolean canBindValueBeSet(Object value, BindableType<?> bindType) {
        return value != null && (bindType == null || bindType instanceof NullSqmExpressible);
    }
}

