/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Supplier;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.batch.JdbcBatchLogging;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.internal.MutationStatementPreparerImpl;
import org.hibernate.engine.jdbc.internal.ResultSetReturnImpl;
import org.hibernate.engine.jdbc.internal.StatementPreparerImpl;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.JdbcWrapper;
import org.hibernate.engine.jdbc.spi.MutationStatementPreparer;
import org.hibernate.engine.jdbc.spi.ResultSetReturn;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.resource.jdbc.internal.AbstractLogicalConnectionImplementor;
import org.hibernate.resource.jdbc.internal.LogicalConnectionManagedImpl;
import org.hibernate.resource.jdbc.internal.LogicalConnectionProvidedImpl;
import org.hibernate.resource.jdbc.internal.ResourceRegistryStandardImpl;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.resource.transaction.backend.jdbc.spi.JdbcResourceTransaction;

public class JdbcCoordinatorImpl
implements JdbcCoordinator {
    private static final boolean TRACE_ENABLED = JdbcLogging.JDBC_MESSAGE_LOGGER.isTraceEnabled();
    private final transient LogicalConnectionImplementor logicalConnection;
    private final transient JdbcSessionOwner owner;
    private final transient JdbcServices jdbcServices;
    private transient Batch currentBatch;
    private transient long transactionTimeOutInstant = -1L;
    private Statement lastQuery;
    private final boolean isUserSuppliedConnection;
    private boolean releasesEnabled = true;
    private int flushDepth;
    private transient StatementPreparer statementPreparer;
    private transient MutationStatementPreparer mutationStatementPreparer;
    private transient ResultSetReturn resultSetExtractor;

    public JdbcCoordinatorImpl(Connection userSuppliedConnection, JdbcSessionOwner owner, JdbcServices jdbcServices) {
        this.owner = owner;
        this.jdbcServices = jdbcServices;
        this.isUserSuppliedConnection = userSuppliedConnection != null;
        this.logicalConnection = JdbcCoordinatorImpl.createLogicalConnection(userSuppliedConnection, owner);
        if (TRACE_ENABLED) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.createdJdbcCoordinator(this.hashCode());
        }
    }

    private static LogicalConnectionImplementor createLogicalConnection(Connection userSuppliedConnection, JdbcSessionOwner owner) {
        ResourceRegistryStandardImpl resourceRegistry = new ResourceRegistryStandardImpl(owner.getJdbcSessionContext().getEventHandler());
        return userSuppliedConnection == null ? new LogicalConnectionManagedImpl(owner, resourceRegistry) : new LogicalConnectionProvidedImpl(userSuppliedConnection, resourceRegistry);
    }

    private JdbcCoordinatorImpl(LogicalConnectionImplementor logicalConnection, boolean isUserSuppliedConnection, JdbcSessionOwner owner) {
        this.logicalConnection = logicalConnection;
        this.isUserSuppliedConnection = isUserSuppliedConnection;
        this.owner = owner;
        this.jdbcServices = owner.getJdbcSessionContext().getJdbcServices();
        if (TRACE_ENABLED) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.createdJdbcCoordinator(this.hashCode());
        }
    }

    @Override
    public LogicalConnectionImplementor getLogicalConnection() {
        return this.logicalConnection;
    }

    public SqlExceptionHelper sqlExceptionHelper() {
        return this.jdbcServices.getSqlExceptionHelper();
    }

    @Override
    public void flushBeginning() {
        if (this.flushDepth == 0) {
            this.releasesEnabled = false;
        }
        ++this.flushDepth;
    }

    @Override
    public void flushEnding() {
        --this.flushDepth;
        if (this.flushDepth < 0) {
            throw new HibernateException("Mismatched flush handling");
        }
        if (this.flushDepth == 0) {
            this.releasesEnabled = true;
        }
        this.afterStatementExecution();
    }

    @Override
    public Connection close() {
        Connection connection;
        if (TRACE_ENABLED) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.closingJdbcCoordinator(this.hashCode());
        }
        try {
            if (this.currentBatch != null) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.closingUnreleasedBatch(this.hashCode());
                this.currentBatch.release();
            }
        }
        finally {
            connection = this.logicalConnection.close();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Batch getBatch(BatchKey key, Integer batchSize, Supplier<PreparedStatementGroup> statementGroupSupplier) {
        if (this.currentBatch != null) {
            if (this.currentBatch.getKey().equals(key)) {
                return this.currentBatch;
            }
            try {
                this.currentBatch.execute();
            }
            finally {
                this.currentBatch.release();
            }
        }
        this.currentBatch = this.owner.getJdbcSessionContext().getBatchBuilder().buildBatch(key, batchSize, statementGroupSupplier, this);
        return this.currentBatch;
    }

    @Override
    public void executeBatch() {
        if (this.currentBatch != null) {
            try {
                this.currentBatch.execute();
            }
            finally {
                this.currentBatch.release();
            }
        }
    }

    @Override
    public void conditionallyExecuteBatch(BatchKey key) {
        if (this.currentBatch != null && !this.currentBatch.getKey().equals(key)) {
            JdbcBatchLogging.BATCH_MESSAGE_LOGGER.conditionallyExecuteBatch(this.currentBatch.getKey().toLoggableString());
            try {
                this.currentBatch.execute();
            }
            finally {
                this.currentBatch.release();
            }
        }
    }

    @Override
    public void abortBatch() {
        if (this.currentBatch != null) {
            JdbcBatchLogging.BATCH_MESSAGE_LOGGER.abortBatch(this.currentBatch.getKey().toLoggableString());
            this.currentBatch.release();
        }
    }

    @Override
    public StatementPreparer getStatementPreparer() {
        if (this.statementPreparer == null) {
            this.statementPreparer = new StatementPreparerImpl(this, this.jdbcServices);
        }
        return this.statementPreparer;
    }

    @Override
    public MutationStatementPreparer getMutationStatementPreparer() {
        if (this.mutationStatementPreparer == null) {
            this.mutationStatementPreparer = new MutationStatementPreparerImpl(this, this.jdbcServices);
        }
        return this.mutationStatementPreparer;
    }

    @Override
    public ResultSetReturn getResultSetReturn() {
        if (this.resultSetExtractor == null) {
            this.resultSetExtractor = new ResultSetReturnImpl(this, this.jdbcServices);
        }
        return this.resultSetExtractor;
    }

    @Override
    public void setTransactionTimeOut(int seconds) {
        this.transactionTimeOutInstant = System.currentTimeMillis() + (long)seconds * 1000L;
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        this.getJdbcSessionOwner().flushBeforeTransactionCompletion();
    }

    @Override
    public int determineRemainingTransactionTimeOutPeriod() {
        if (this.transactionTimeOutInstant < 0L) {
            return -1;
        }
        long millisecondsRemaining = this.transactionTimeOutInstant - System.currentTimeMillis();
        if (millisecondsRemaining <= 0L) {
            throw new TransactionException("Transaction timeout expired");
        }
        return Math.max((int)(millisecondsRemaining / 1000L), 1);
    }

    @Override
    public void afterStatementExecution() {
        ConnectionReleaseMode connectionReleaseMode = this.connectionReleaseMode();
        if (TRACE_ENABLED) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.statementExecutionComplete(connectionReleaseMode, this.hashCode());
        }
        if (connectionReleaseMode == ConnectionReleaseMode.AFTER_STATEMENT) {
            if (!this.releasesEnabled) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.trace("Skipping aggressive release due to manual disabling");
            } else if (this.hasRegisteredResources()) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.trace("Skipping aggressive release due to registered resources");
            } else {
                this.getLogicalConnection().afterStatement();
            }
        }
    }

    @Override
    public void afterTransaction() {
        this.transactionTimeOutInstant = -1L;
        switch (this.connectionReleaseMode()) {
            case AFTER_STATEMENT: 
            case AFTER_TRANSACTION: 
            case BEFORE_TRANSACTION_COMPLETION: {
                this.logicalConnection.afterTransaction();
            }
        }
    }

    private ConnectionReleaseMode connectionReleaseMode() {
        return this.getLogicalConnection().getConnectionHandlingMode().getReleaseMode();
    }

    private boolean hasRegisteredResources() {
        return this.getLogicalConnection().getResourceRegistry().hasRegisteredResources();
    }

    @Override
    public <T> T coordinateWork(WorkExecutorVisitable<T> work) {
        Connection connection = this.getLogicalConnection().getPhysicalConnection();
        try {
            T result = work.accept(new WorkExecutor(), connection);
            this.afterStatementExecution();
            return result;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "Error executing work");
        }
    }

    @Override
    public boolean isReadyForSerialization() {
        return this.isUserSuppliedConnection ? !this.getLogicalConnection().isPhysicallyConnected() : !this.hasRegisteredResources();
    }

    @Override
    public void registerLastQuery(Statement statement) {
        if (statement instanceof JdbcWrapper) {
            JdbcWrapper wrapper = (JdbcWrapper)((Object)statement);
            this.registerLastQuery((Statement)wrapper.getWrappedObject());
        } else {
            this.lastQuery = statement;
        }
    }

    @Override
    public void cancelLastQuery() {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException sqle) {
            throw this.safeSqlExceptionHelper().convert(sqle, "Cannot cancel query");
        }
        finally {
            this.lastQuery = null;
        }
    }

    private SqlExceptionHelper safeSqlExceptionHelper() {
        SqlExceptionHelper sqlExceptionHelper = this.sqlExceptionHelper();
        return sqlExceptionHelper == null ? new SqlExceptionHelper(false) : sqlExceptionHelper;
    }

    @Override
    public void enableReleases() {
        this.releasesEnabled = true;
    }

    @Override
    public void disableReleases() {
        this.releasesEnabled = false;
    }

    @Override
    public boolean isActive() {
        return this.owner.getJdbcSessionContext().isActive();
    }

    @Override
    public void afterTransactionBegin() {
        if (TRACE_ENABLED) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.transactionAfterBegin(this.hashCode());
        }
        this.owner.afterTransactionBegin();
    }

    @Override
    public void beforeTransactionCompletion() {
        if (TRACE_ENABLED) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.transactionBeforeCompletion(this.hashCode());
        }
        this.owner.beforeTransactionCompletion();
        this.logicalConnection.beforeTransactionCompletion();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        if (TRACE_ENABLED) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.transactionAfterCompletion(successful ? "successful" : "unsuccessful", this.hashCode());
        }
        this.afterTransaction();
        this.owner.afterTransactionCompletion(successful, delayed);
    }

    @Override
    public JdbcSessionOwner getJdbcSessionOwner() {
        return this.owner;
    }

    @Override
    public JdbcResourceTransaction getResourceLocalTransaction() {
        return this.logicalConnection.getPhysicalJdbcTransaction();
    }

    @Override
    public void serialize(ObjectOutputStream oos) throws IOException {
        if (!this.isReadyForSerialization()) {
            throw new HibernateException("Cannot serialize Session while connected");
        }
        oos.writeBoolean(this.isUserSuppliedConnection);
        this.logicalConnection.serialize(oos);
    }

    public static JdbcCoordinatorImpl deserialize(ObjectInputStream ois, JdbcSessionOwner owner) throws IOException, ClassNotFoundException {
        boolean isUserSuppliedConnection = ois.readBoolean();
        AbstractLogicalConnectionImplementor logicalConnection = isUserSuppliedConnection ? LogicalConnectionProvidedImpl.deserialize(ois) : LogicalConnectionManagedImpl.deserialize(ois, owner);
        return new JdbcCoordinatorImpl(logicalConnection, isUserSuppliedConnection, owner);
    }
}

