/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import org.jboss.logging.Logger;
import org.keycloak.OAuthErrorException;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.AccessTokenIntrospectionProvider;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.util.UserSessionUtil;

public class RefreshTokenIntrospectionProvider
extends AccessTokenIntrospectionProvider<RefreshToken> {
    private static final Logger logger = Logger.getLogger(RefreshTokenIntrospectionProvider.class);

    public RefreshTokenIntrospectionProvider(KeycloakSession session) {
        super(session);
    }

    @Override
    protected Class<RefreshToken> getTokenClass() {
        return RefreshToken.class;
    }

    @Override
    protected UserSessionUtil.UserSessionValidationResult verifyUserSession() {
        return UserSessionUtil.findValidSessionForRefreshToken(this.session, this.realm, (RefreshToken)this.token, this.client, invalidUserSession -> {});
    }

    @Override
    protected boolean verifyTokenReuse() {
        String tokenType = ((RefreshToken)this.token).getType();
        if (this.realm.isRevokeRefreshToken() && (tokenType.equals("Refresh") || tokenType.equals("Offline")) && !this.validateTokenReuse()) {
            logger.debugf("Introspection access token for %s client: failed to validate Token reuse for introspection", (Object)((RefreshToken)this.token).getIssuedFor());
            this.eventBuilder.detail("reason", "Realm revoke refresh token, token type is " + tokenType + " and token is not eligible for introspection");
            this.eventBuilder.error("invalid_token");
            return false;
        }
        return true;
    }

    private boolean validateTokenReuse() {
        AuthenticatedClientSessionModel clientSession = this.userSession.getAuthenticatedClientSessionByClient(this.client.getId());
        try {
            this.tokenManager.validateTokenReuse(this.session, this.realm, this.token, clientSession, false);
            return true;
        }
        catch (OAuthErrorException e) {
            logger.debug((Object)"validateTokenReuseForIntrospection is false", (Throwable)e);
            return false;
        }
    }
}

