/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RegisterControllerRecord;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListenerInfo {
    private static final Logger log = LoggerFactory.getLogger(ListenerInfo.class);
    private final Map<String, Endpoint> listeners;

    public static ListenerInfo fromControllerRegistrationRequest(ControllerRegistrationRequestData.ListenerCollection collection) {
        LinkedHashMap<String, Endpoint> listeners = new LinkedHashMap<String, Endpoint>();
        collection.forEach(listener -> {
            SecurityProtocol protocol = SecurityProtocol.forId((short)listener.securityProtocol());
            if (protocol == null) {
                throw new RuntimeException("Unknown security protocol " + listener.securityProtocol() + " in listener " + listener.name());
            }
            listeners.put(listener.name(), new Endpoint(listener.name(), protocol, listener.host(), listener.port()));
        });
        return new ListenerInfo(listeners);
    }

    public static ListenerInfo fromControllerRegistrationRecord(RegisterControllerRecord.ControllerEndpointCollection collection) {
        LinkedHashMap<String, Endpoint> listeners = new LinkedHashMap<String, Endpoint>();
        collection.forEach(listener -> {
            SecurityProtocol protocol = SecurityProtocol.forId((short)listener.securityProtocol());
            if (protocol == null) {
                throw new RuntimeException("Unknown security protocol " + listener.securityProtocol() + " in listener " + listener.name());
            }
            listeners.put(listener.name(), new Endpoint(listener.name(), protocol, listener.host(), listener.port()));
        });
        return new ListenerInfo(listeners);
    }

    public static ListenerInfo fromBrokerRegistrationRequest(BrokerRegistrationRequestData.ListenerCollection collection) {
        LinkedHashMap<String, Endpoint> listeners = new LinkedHashMap<String, Endpoint>();
        collection.forEach(listener -> {
            SecurityProtocol protocol = SecurityProtocol.forId((short)listener.securityProtocol());
            if (protocol == null) {
                throw new RuntimeException("Unknown security protocol " + listener.securityProtocol() + " in listener " + listener.name());
            }
            listeners.put(listener.name(), new Endpoint(listener.name(), protocol, listener.host(), listener.port()));
        });
        return new ListenerInfo(listeners);
    }

    public static ListenerInfo fromBrokerRegistrationRecord(RegisterBrokerRecord.BrokerEndpointCollection collection) {
        LinkedHashMap<String, Endpoint> listeners = new LinkedHashMap<String, Endpoint>();
        collection.forEach(listener -> {
            SecurityProtocol protocol = SecurityProtocol.forId((short)listener.securityProtocol());
            if (protocol == null) {
                throw new RuntimeException("Unknown security protocol " + listener.securityProtocol() + " in listener " + listener.name());
            }
            listeners.put(listener.name(), new Endpoint(listener.name(), protocol, listener.host(), listener.port()));
        });
        return new ListenerInfo(listeners);
    }

    public static ListenerInfo create(List<Endpoint> rawListeners) {
        return ListenerInfo.create(Optional.empty(), rawListeners);
    }

    public static ListenerInfo create(Optional<String> firstListenerName, List<Endpoint> rawListeners) {
        String name;
        LinkedHashMap<String, Endpoint> listeners = new LinkedHashMap<String, Endpoint>();
        for (Endpoint listener : rawListeners) {
            name = listener.listener();
            if (!Optional.of(name).equals(firstListenerName)) continue;
            listeners.put(name, listener);
            break;
        }
        for (Endpoint listener : rawListeners) {
            name = listener.listener();
            if (Optional.of(name).equals(firstListenerName)) continue;
            listeners.put(name, listener);
        }
        return new ListenerInfo(listeners);
    }

    private ListenerInfo(Map<String, Endpoint> listeners) {
        this.listeners = Collections.unmodifiableMap(listeners);
    }

    public Map<String, Endpoint> listeners() {
        return this.listeners;
    }

    public Endpoint firstListener() {
        if (this.listeners.isEmpty()) {
            throw new RuntimeException("No listeners found.");
        }
        return this.listeners.values().iterator().next();
    }

    public ListenerInfo withWildcardHostnamesResolved() throws UnknownHostException {
        LinkedHashMap<String, Endpoint> newListeners = new LinkedHashMap<String, Endpoint>();
        for (Map.Entry<String, Endpoint> entry : this.listeners.entrySet()) {
            if (entry.getValue().host() == null || entry.getValue().host().trim().isEmpty()) {
                String newHost = InetAddress.getLocalHost().getCanonicalHostName();
                Endpoint prevEndpoint = entry.getValue();
                newListeners.put(entry.getKey(), new Endpoint(prevEndpoint.listener(), prevEndpoint.securityProtocol(), newHost, prevEndpoint.port()));
                log.info("{}: resolved wildcard host to {}", (Object)entry.getValue().listener(), (Object)newHost);
                continue;
            }
            newListeners.put(entry.getKey(), entry.getValue());
        }
        return new ListenerInfo(newListeners);
    }

    public ListenerInfo withEphemeralPortsCorrected(Function<String, Integer> getBoundPortCallback) {
        LinkedHashMap<String, Endpoint> newListeners = new LinkedHashMap<String, Endpoint>();
        for (Map.Entry<String, Endpoint> entry : this.listeners.entrySet()) {
            if (entry.getValue().port() == 0) {
                Endpoint prevEndpoint = entry.getValue();
                int newPort = getBoundPortCallback.apply(entry.getKey());
                ListenerInfo.checkPortIsSerializable(newPort);
                log.info("{}: resolved ephemeral port to {}", (Object)entry.getValue().listener(), (Object)newPort);
                newListeners.put(entry.getKey(), new Endpoint(prevEndpoint.listener(), prevEndpoint.securityProtocol(), prevEndpoint.host(), newPort));
                continue;
            }
            newListeners.put(entry.getKey(), entry.getValue());
        }
        return new ListenerInfo(newListeners);
    }

    private static void checkPortIsSerializable(int port) {
        if (port == 0) {
            throw new RuntimeException("Cannot serialize ephemeral port 0 in ListenerInfo.");
        }
        if (port < 0) {
            throw new RuntimeException("Cannot serialize negative port number " + port + " in ListenerInfo.");
        }
        if (port > 65535) {
            throw new RuntimeException("Cannot serialize invalid port number " + port + " in ListenerInfo.");
        }
    }

    private static void checkHostIsSerializable(String host) {
        if (host == null) {
            throw new RuntimeException("Cannot serialize null host in ListenerInfo.");
        }
        if (host.trim().isEmpty()) {
            throw new RuntimeException("Cannot serialize empty host in ListenerInfo.");
        }
    }

    public ControllerRegistrationRequestData.ListenerCollection toControllerRegistrationRequest() {
        ControllerRegistrationRequestData.ListenerCollection collection = new ControllerRegistrationRequestData.ListenerCollection();
        this.listeners.values().forEach(endpoint -> {
            ListenerInfo.checkPortIsSerializable(endpoint.port());
            ListenerInfo.checkHostIsSerializable(endpoint.host());
            collection.add((ImplicitLinkedHashCollection.Element)new ControllerRegistrationRequestData.Listener().setHost(endpoint.host()).setName(endpoint.listener()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id));
        });
        return collection;
    }

    public RegisterControllerRecord.ControllerEndpointCollection toControllerRegistrationRecord() {
        RegisterControllerRecord.ControllerEndpointCollection collection = new RegisterControllerRecord.ControllerEndpointCollection();
        this.listeners.values().forEach(endpoint -> {
            ListenerInfo.checkPortIsSerializable(endpoint.port());
            ListenerInfo.checkHostIsSerializable(endpoint.host());
            collection.add(new RegisterControllerRecord.ControllerEndpoint().setHost(endpoint.host()).setName(endpoint.listener()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id));
        });
        return collection;
    }

    public BrokerRegistrationRequestData.ListenerCollection toBrokerRegistrationRequest() {
        BrokerRegistrationRequestData.ListenerCollection collection = new BrokerRegistrationRequestData.ListenerCollection();
        this.listeners.values().forEach(endpoint -> {
            ListenerInfo.checkPortIsSerializable(endpoint.port());
            ListenerInfo.checkHostIsSerializable(endpoint.host());
            collection.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Listener().setHost(endpoint.host()).setName(endpoint.listener()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id));
        });
        return collection;
    }

    public RegisterBrokerRecord.BrokerEndpointCollection toBrokerRegistrationRecord() {
        RegisterBrokerRecord.BrokerEndpointCollection collection = new RegisterBrokerRecord.BrokerEndpointCollection();
        this.listeners.values().forEach(endpoint -> {
            ListenerInfo.checkPortIsSerializable(endpoint.port());
            ListenerInfo.checkHostIsSerializable(endpoint.host());
            collection.add(new RegisterBrokerRecord.BrokerEndpoint().setHost(endpoint.host()).setName(endpoint.listener()).setPort(endpoint.port()).setSecurityProtocol(endpoint.securityProtocol().id));
        });
        return collection;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(ListenerInfo.class)) {
            return false;
        }
        ListenerInfo other = (ListenerInfo)o;
        return this.listeners.equals(other.listeners) && this.firstListener().equals((Object)other.firstListener());
    }

    public int hashCode() {
        return Objects.hash(this.listeners);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("ListenerInfo(");
        String prefix = "";
        for (Endpoint endpoint : this.listeners.values()) {
            bld.append(prefix).append(endpoint);
            prefix = ", ";
        }
        bld.append(")");
        return bld.toString();
    }
}

