/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.InformationDialog;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSPrefs;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.SamplerEngine;

public class JSChannelsDefaultSettingsPane
extends JPanel {
    private final JLabel lDefaultEngine = new JLabel(StdI18n.i18n.getLabel("JSChannelsDefaultSettingsPane.lDefaultEngine"));
    private final JLabel lMidiInput = new JLabel(StdI18n.i18n.getLabel("JSChannelsDefaultSettingsPane.lMidiInput"));
    private final JLabel lAudioOutput = new JLabel(StdI18n.i18n.getLabel("JSChannelsDefaultSettingsPane.lAudioOutput"));
    private final JLabel lChannelVolume = new JLabel(StdI18n.i18n.getLabel("JSChannelsDefaultSettingsPane.lChannelVolume"));
    private final JLabel lMidiMap = new JLabel(StdI18n.i18n.getLabel("JSChannelsDefaultSettingsPane.lMidiMap"));
    private final JComboBox cbDefaultEngine = new JComboBox();
    private final JComboBox cbMidiInput = new JComboBox();
    private final JComboBox cbAudioOutput = new JComboBox();
    private final JSlider slChannelVolume = new JSlider(0, 100);
    private final JComboBox cbMidiMap = new JComboBox();
    private final JLabel lVolume = new JLabel();
    private static final String strFirstDevice = StdI18n.i18n.getLabel("JSChannelsDefaultSettingsPane.strFirstDevice");
    private static final String strFirstDeviceNextChannel = StdI18n.i18n.getLabel("JSChannelsDefaultSettingsPane.strFirstDeviceNextChannel");
    private NoMap noMap = new NoMap();
    private DefaultMap defaultMap = new DefaultMap();
    private static NumberFormat numberFormat = NumberFormat.getInstance();

    public JSChannelsDefaultSettingsPane() {
        numberFormat.setMaximumFractionDigits(1);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lDefaultEngine, gridBagConstraints);
        this.add(this.lDefaultEngine);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lMidiInput, gridBagConstraints);
        this.add(this.lMidiInput);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lAudioOutput, gridBagConstraints);
        this.add(this.lAudioOutput);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lMidiMap, gridBagConstraints);
        this.add(this.lMidiMap);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.lChannelVolume, gridBagConstraints);
        this.add(this.lChannelVolume);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cbDefaultEngine, gridBagConstraints);
        this.add(this.cbDefaultEngine);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.cbMidiInput, gridBagConstraints);
        this.add(this.cbMidiInput);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.cbAudioOutput, gridBagConstraints);
        this.add(this.cbAudioOutput);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.cbMidiMap, gridBagConstraints);
        this.add(this.cbMidiMap);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        Dimension dimension = this.slChannelVolume.getPreferredSize();
        this.slChannelVolume.setMaximumSize(new Dimension(dimension.width > 300 ? dimension.width : 300, dimension.height));
        this.slChannelVolume.setOpaque(false);
        jPanel.add(this.slChannelVolume);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.lVolume.setHorizontalAlignment(4);
        this.lVolume.setText("100000%");
        this.lVolume.setPreferredSize(this.lVolume.getPreferredSize());
        this.lVolume.setMinimumSize(this.lVolume.getPreferredSize());
        jPanel.add(this.lVolume);
        this.slChannelVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSChannelsDefaultSettingsPane.this.updateVolume();
            }
        });
        int n = JSChannelsDefaultSettingsPane.preferences().getIntProperty("defaultChannelVolume");
        this.slChannelVolume.setValue(n);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        for (SamplerEngine samplerEngine : CC.getSamplerModel().getEngines()) {
            this.cbDefaultEngine.addItem(samplerEngine);
        }
        String string = JSChannelsDefaultSettingsPane.preferences().getStringProperty("defaultEngine");
        for (SamplerEngine samplerEngine : CC.getSamplerModel().getEngines()) {
            if (!samplerEngine.getName().equals(string)) continue;
            this.cbDefaultEngine.setSelectedItem(samplerEngine);
        }
        this.cbDefaultEngine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSChannelsDefaultSettingsPane.this.changeDefaultEngine();
            }
        });
        this.cbMidiInput.addItem(strFirstDevice);
        this.cbMidiInput.addItem(strFirstDeviceNextChannel);
        String string2 = JSChannelsDefaultSettingsPane.preferences().getStringProperty("defaultMidiInput");
        if (string2.equals("firstDevice")) {
            this.cbMidiInput.setSelectedItem(strFirstDevice);
        } else if (string2.equals("firstDeviceNextChannel")) {
            this.cbMidiInput.setSelectedItem(strFirstDeviceNextChannel);
        }
        this.cbMidiInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSChannelsDefaultSettingsPane.this.changeDefaultMidiInput();
            }
        });
        this.cbAudioOutput.addItem(strFirstDevice);
        this.cbAudioOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSChannelsDefaultSettingsPane.this.changeDefaultAudioOutput();
            }
        });
        this.cbMidiMap.addItem(this.noMap);
        this.cbMidiMap.addItem(this.defaultMap);
        String string3 = JSChannelsDefaultSettingsPane.preferences().getStringProperty("defaultMidiInstrumentMap");
        if (string3.equals("midiInstrumentMap.none")) {
            this.cbMidiMap.setSelectedItem(this.noMap);
        } else if (string3.equals("midiInstrumentMap.default")) {
            this.cbMidiMap.setSelectedItem(this.defaultMap);
        }
        this.cbMidiMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSChannelsDefaultSettingsPane.this.changeDefaultMidiMap();
            }
        });
    }

    public JDialog createDialog(Dialog dialog) {
        String string = StdI18n.i18n.getLabel("JSChannelsDefaultSettingsPane.title");
        InformationDialog informationDialog = new InformationDialog(dialog, string, (Container)this);
        return informationDialog;
    }

    private void changeDefaultEngine() {
        Object object = this.cbDefaultEngine.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = ((SamplerEngine)object).getName();
        JSChannelsDefaultSettingsPane.preferences().setStringProperty("defaultEngine", string);
    }

    private void changeDefaultMidiInput() {
        Object object = this.cbMidiInput.getSelectedItem();
        if (object == null) {
            return;
        }
        if (object == strFirstDevice) {
            JSChannelsDefaultSettingsPane.preferences().setStringProperty("defaultMidiInput", "firstDevice");
        } else if (object == strFirstDeviceNextChannel) {
            JSChannelsDefaultSettingsPane.preferences().setStringProperty("defaultMidiInput", "firstDeviceNextChannel");
        }
    }

    private void changeDefaultAudioOutput() {
        Object object = this.cbAudioOutput.getSelectedItem();
        if (object == null) {
            return;
        }
        if (object == strFirstDevice) {
            JSChannelsDefaultSettingsPane.preferences().setStringProperty("defaultAudioOutput", "firstDevice");
        }
    }

    private void changeDefaultMidiMap() {
        Object object = this.cbMidiMap.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = "defaultMidiInstrumentMap";
        if (object == this.noMap) {
            JSChannelsDefaultSettingsPane.preferences().setStringProperty(string, "midiInstrumentMap.none");
        } else if (object == this.defaultMap) {
            JSChannelsDefaultSettingsPane.preferences().setStringProperty(string, "midiInstrumentMap.default");
        }
    }

    private void updateVolume() {
        int n = this.slChannelVolume.getValue();
        if (CC.getViewConfig().isMeasurementUnitDecibel()) {
            double d = HF.percentsToDecibels(n);
            this.lVolume.setText(numberFormat.format(d) + "dB");
        } else {
            this.lVolume.setText(String.valueOf(n) + '%');
        }
        if (this.slChannelVolume.getValueIsAdjusting()) {
            return;
        }
        JSChannelsDefaultSettingsPane.preferences().setIntProperty("defaultChannelVolume", this.slChannelVolume.getValue());
    }

    private static JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    private class DefaultMap {
        private DefaultMap() {
        }

        public String toString() {
            return "[Default]";
        }
    }

    private class NoMap {
        private NoMap() {
        }

        public String toString() {
            return "[None]";
        }
    }
}

