/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.c;

public enum STR {
    NOT(-1, -8355712),
    NONE(0, -1),
    TURN(1, -10452737),
    SHEET(2, -14336),
    HELIX(3, -65408),
    DNA(4, -5373698),
    RNA(5, -196254),
    CARBOHYDRATE(6, -5855494),
    HELIX310(7, -6291328),
    HELIXALPHA(8, -65408),
    HELIXPI(9, -10485632),
    ANNOTATION(-2, 0);

    private int id;
    private int color;

    private STR(int id, int color) {
        this.id = id;
        this.color = color;
    }

    public int getId() {
        return this.id;
    }

    public int getColor() {
        return this.color;
    }

    public static final STR getProteinStructureType(String name) {
        for (STR item : STR.values()) {
            if (!name.equalsIgnoreCase(item.name())) continue;
            return item.isProtein() ? item : NOT;
        }
        return NOT;
    }

    public String getBioStructureTypeName(boolean isGeneric) {
        return this.id < 0 ? "" : (isGeneric && this.isProtein() ? "protein" : this.name());
    }

    private boolean isProtein() {
        return this.id >= 0 && this.id <= 3 || this.id >= 7;
    }
}

