#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger
version:              1.51.2
visibility:           public
id:                   hledger-1.51.2-6Qh1OigerWi29xeGzZpdY7
key:                  hledger-1.51.2-6Qh1OigerWi29xeGzZpdY7
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  d22671c6847e4712bbb582f96d99111b
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anchor Hledger.Cli.Anon
    Hledger.Cli.CliOptions Hledger.Cli.Commands
    Hledger.Cli.Commands.Accounts Hledger.Cli.Commands.Activity
    Hledger.Cli.Commands.Add Hledger.Cli.Commands.Aregister
    Hledger.Cli.Commands.Balance Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Run
    Hledger.Cli.Commands.Setup Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.Conf Hledger.Cli.DocFiles Hledger.Cli.Script
    Hledger.Cli.Utils Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-1.51.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-1.51.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-1.51.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.51.2-6Qh1OigerWi29xeGzZpdY7
depends:
    Decimal-0.5.2-JXrePV1lvreIVHPnZS1jqh
    Diff-0.5-9iFzYwbbznxCTrvC5fevGO
    aeson-2.2.0.0-4qLATSA6nfj1RfgXH6DMKK
    ansi-terminal-1.1-6H4MdlQ9LS5JB7dL181Y6t base-4.18.2.1
    bytestring-0.11.5.3 cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    containers-0.6.7 data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz
    directory-1.3.8.5 extra-1.7.16-6e0wBrlA2xu66mkOtGwbe0
    filepath-1.4.300.1 githash-0.1.6.3-I67lp2I8Vnr6v6Q6s23zsl
    hashable-1.4.7.0-LE3bCdm1Wgy6IgVYkRoAlQ haskeline-0.8.2.1
    hledger-lib-1.51.2-1f3dxtl3hgjC4pjNtisLuO
    http-client-0.7.19-4rucZD6prn1Bn7NkqCpiFR
    http-types-0.12.4-Hj8jLUhN6rtnIgKEy5ynr
    lucid-2.11.20250303-ELP7KB36nnKA8CT38tPAXr
    math-functions-0.3.4.4-ELJYOCHeZCo3AbQJsZAY0E
    megaparsec-9.7.0-4yWx9K7i1Xa7WY3KCISRfK
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    modern-uri-0.3.6.1-LWycNW3JUadA2mgPMAL49n mtl-2.3.1
    process-1.6.19.0 regex-tdfa-1.3.2.5-4Nt33WWCOhH70pmXr5RVz
    req-3.13.4-7odbnR29xY31FvJ8xzWP6k safe-0.3.21-WYqCEMpsX24yfPdI1X0Hh
    shakespeare-2.1.7-CFRzD7VNGIS74GFY2KG4F1
    split-0.2.5-9bPPlQ4mlHj6gKeWe5Fjp8
    tabular-0.2.2.8-Ly9fepE9sHFB2l1Bgv9bkV
    tasty-1.5.2-8UD20z9n5eiHm9q6FlO2Zy
    temporary-1.3-7FXkQQKerYU7UfmRyKNwo9 text-2.0.2
    text-ansi-0.3.0.1-38fV9HRSuPvJsLiLchSAzk time-1.12.2
    timeit-2.0-DwmItJuhuSm6aktMh1S1ZM transformers-0.6.1.0
    unordered-containers-0.2.20.1-I6eyTXb69D2BhxejMtPouo
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    utility-ht-0.0.17.2-HbCwTDUiMmdBgY2yAWi26t
    wizards-1.0.3-EMndOhiYuHdGTEqrX5mo0v

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

