#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 LambdaHack
version:              0.11.0.1
visibility:           public
id:                   LambdaHack-0.11.0.1-DaOGfs4I1HJ5twaLQHP9lA
key:                  LambdaHack-0.11.0.1-DaOGfs4I1HJ5twaLQHP9lA
license:              BSD-3-Clause
maintainer:           Mikolaj Konarski <mikolaj.konarski@funktory.com>
author:               Andres Loeh, Mikolaj Konarski and others
homepage:             https://lambdahack.github.io
synopsis:
    A game engine library for tactical squad ASCII roguelike dungeon crawlers

description:
    LambdaHack is a Haskell game engine library for ASCII roguelike
    games of arbitrary theme, size and complexity, with optional
    tactical squad combat. It'\''s packaged together with a sample
    dungeon crawler in a quirky fantasy setting. The sample game can be
    tried out in the browser at <http://lambdahack.github.io>.

    Please see the changelog file for recent improvements
    and the issue tracker for short-term plans. Long term goals
    include multiplayer tactical squad combat, in-game content
    creation, auto-balancing and persistent content modification
    based on player behaviour. Contributions are welcome.

    Other games known to use the LambdaHack library:

    * Allure of the Stars, a near-future Sci-Fi game,
    <http://hackage.haskell.org/package/Allure>

    Note: All modules in this library are kept visible,
    to let games override and reuse them.
    OTOH, to reflect that some modules are implementation details
    relative to others, the source code adheres to the following
    convention. If a module has the same name as a directory,
    the module is the exclusive interface to the directory.
    No references to the modules in the directory are allowed
    except from the interface module. This policy is only binding
    when developing the library --- library users are free
    to access any modules, since the library authors are in
    no position to guess their particular needs.

    This is a workaround .cabal file, flattened to eliminate
    internal libraries until generating haddocks for them
    is fixed. The original .cabal file is in .cabal.bkp file.

category:             Game Engine, Game
abi:                  56a6c8727d01098e11b98523dda8e5cb
exposed:              True
exposed-modules:
    Client.UI.Content.Input Client.UI.Content.Screen Content.CaveKind
    Content.FactionKind Content.ItemKind Content.ItemKindActor
    Content.ItemKindBlast Content.ItemKindEmbed Content.ItemKindOrgan
    Content.ItemKindTemporary Content.ModeKind Content.PlaceKind
    Content.RuleKind Content.TileKind Game.LambdaHack.Atomic
    Game.LambdaHack.Atomic.CmdAtomic
    Game.LambdaHack.Atomic.HandleAtomicWrite
    Game.LambdaHack.Atomic.MonadStateWrite
    Game.LambdaHack.Atomic.PosAtomicRead Game.LambdaHack.Client
    Game.LambdaHack.Client.AI Game.LambdaHack.Client.AI.ConditionM
    Game.LambdaHack.Client.AI.PickActionM
    Game.LambdaHack.Client.AI.PickActorM
    Game.LambdaHack.Client.AI.PickTargetM
    Game.LambdaHack.Client.AI.Strategy Game.LambdaHack.Client.Bfs
    Game.LambdaHack.Client.BfsM Game.LambdaHack.Client.CommonM
    Game.LambdaHack.Client.HandleAtomicM
    Game.LambdaHack.Client.HandleResponseM Game.LambdaHack.Client.LoopM
    Game.LambdaHack.Client.MonadClient
    Game.LambdaHack.Client.Preferences Game.LambdaHack.Client.Request
    Game.LambdaHack.Client.Response Game.LambdaHack.Client.State
    Game.LambdaHack.Client.UI Game.LambdaHack.Client.UI.ActorUI
    Game.LambdaHack.Client.UI.Animation
    Game.LambdaHack.Client.UI.Content.Input
    Game.LambdaHack.Client.UI.Content.Screen
    Game.LambdaHack.Client.UI.ContentClientUI
    Game.LambdaHack.Client.UI.DrawM
    Game.LambdaHack.Client.UI.EffectDescription
    Game.LambdaHack.Client.UI.Frame Game.LambdaHack.Client.UI.FrameM
    Game.LambdaHack.Client.UI.Frontend
    Game.LambdaHack.Client.UI.Frontend.ANSI
    Game.LambdaHack.Client.UI.Frontend.Common
    Game.LambdaHack.Client.UI.Frontend.Sdl
    Game.LambdaHack.Client.UI.Frontend.Teletype
    Game.LambdaHack.Client.UI.HandleHelperM
    Game.LambdaHack.Client.UI.HandleHumanGlobalM
    Game.LambdaHack.Client.UI.HandleHumanLocalM
    Game.LambdaHack.Client.UI.HandleHumanM
    Game.LambdaHack.Client.UI.HumanCmd
    Game.LambdaHack.Client.UI.InventoryM
    Game.LambdaHack.Client.UI.ItemDescription
    Game.LambdaHack.Client.UI.Key Game.LambdaHack.Client.UI.KeyBindings
    Game.LambdaHack.Client.UI.MonadClientUI
    Game.LambdaHack.Client.UI.Msg Game.LambdaHack.Client.UI.MsgM
    Game.LambdaHack.Client.UI.Overlay Game.LambdaHack.Client.UI.PointUI
    Game.LambdaHack.Client.UI.RunM Game.LambdaHack.Client.UI.SessionUI
    Game.LambdaHack.Client.UI.Slideshow
    Game.LambdaHack.Client.UI.SlideshowM
    Game.LambdaHack.Client.UI.TutorialHints
    Game.LambdaHack.Client.UI.UIOptions
    Game.LambdaHack.Client.UI.UIOptionsParse
    Game.LambdaHack.Client.UI.Watch
    Game.LambdaHack.Client.UI.Watch.WatchCommonM
    Game.LambdaHack.Client.UI.Watch.WatchQuitM
    Game.LambdaHack.Client.UI.Watch.WatchSfxAtomicM
    Game.LambdaHack.Client.UI.Watch.WatchUpdAtomicM
    Game.LambdaHack.Common.Actor Game.LambdaHack.Common.ActorState
    Game.LambdaHack.Common.Analytics Game.LambdaHack.Common.Area
    Game.LambdaHack.Common.ClientOptions Game.LambdaHack.Common.Faction
    Game.LambdaHack.Common.File Game.LambdaHack.Common.HighScore
    Game.LambdaHack.Common.Item Game.LambdaHack.Common.ItemAspect
    Game.LambdaHack.Common.Kind Game.LambdaHack.Common.Level
    Game.LambdaHack.Common.Misc Game.LambdaHack.Common.MonadStateRead
    Game.LambdaHack.Common.Perception Game.LambdaHack.Common.Point
    Game.LambdaHack.Common.PointArray Game.LambdaHack.Common.ReqFailure
    Game.LambdaHack.Common.RingBuffer Game.LambdaHack.Common.Save
    Game.LambdaHack.Common.State Game.LambdaHack.Common.Thread
    Game.LambdaHack.Common.Tile Game.LambdaHack.Common.Time
    Game.LambdaHack.Common.Types Game.LambdaHack.Common.Vector
    Game.LambdaHack.Content.CaveKind
    Game.LambdaHack.Content.FactionKind
    Game.LambdaHack.Content.ItemKind Game.LambdaHack.Content.ModeKind
    Game.LambdaHack.Content.PlaceKind Game.LambdaHack.Content.RuleKind
    Game.LambdaHack.Content.TileKind Game.LambdaHack.Core.Dice
    Game.LambdaHack.Core.Frequency Game.LambdaHack.Core.Prelude
    Game.LambdaHack.Core.Random Game.LambdaHack.Definition.Ability
    Game.LambdaHack.Definition.Color
    Game.LambdaHack.Definition.ContentData
    Game.LambdaHack.Definition.Defs
    Game.LambdaHack.Definition.DefsInternal
    Game.LambdaHack.Definition.Flavour Game.LambdaHack.Server
    Game.LambdaHack.Server.BroadcastAtomic
    Game.LambdaHack.Server.Commandline Game.LambdaHack.Server.CommonM
    Game.LambdaHack.Server.DebugM Game.LambdaHack.Server.DungeonGen
    Game.LambdaHack.Server.DungeonGen.AreaRnd
    Game.LambdaHack.Server.DungeonGen.Cave
    Game.LambdaHack.Server.DungeonGen.Place Game.LambdaHack.Server.Fov
    Game.LambdaHack.Server.FovDigital
    Game.LambdaHack.Server.HandleAtomicM
    Game.LambdaHack.Server.HandleEffectM
    Game.LambdaHack.Server.HandleRequestM Game.LambdaHack.Server.ItemM
    Game.LambdaHack.Server.ItemRev Game.LambdaHack.Server.LoopM
    Game.LambdaHack.Server.MonadServer Game.LambdaHack.Server.PeriodicM
    Game.LambdaHack.Server.ProtocolM
    Game.LambdaHack.Server.ServerOptions Game.LambdaHack.Server.StartM
    Game.LambdaHack.Server.State
    Implementation.MonadClientImplementation
    Implementation.MonadServerImplementation TieKnot

hidden-modules:       Paths_LambdaHack Game.LambdaHack.Common.HSFile
import-dirs:          /usr/lib/ghc-9.6.6/site-local/LambdaHack-0.11.0.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/LambdaHack-0.11.0.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/LambdaHack-0.11.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lambdahack
hs-libraries:         HSLambdaHack-0.11.0.1-DaOGfs4I1HJ5twaLQHP9lA
depends:
    QuickCheck-2.15.0.1-6GEGPgW6PY5CA5PnU98uYH
    ansi-terminal-1.1-6H4MdlQ9LS5JB7dL181Y6t
    assert-failure-0.1.3.0-8hIsIdxrMWu8NrmIWkKjeE
    async-2.2.5-BExe3HBSFHr8hii1cT1bvS base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4 binary-0.8.9.1
    bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.1
    directory-1.3.8.5 enummapset-0.7.3.0-GaYcCgTTwTJ3ubBo2nlntJ
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    ghc-compact-0.1.0.0 hashable-1.4.7.0-LE3bCdm1Wgy6IgVYkRoAlQ
    hsini-0.5.2.2-JjSSYNW16HG2zv7Bo7MPbA
    keys-3.12.4-IPLRPIdgYluDu2HJOVGLs7
    miniutter-0.5.1.2-EGongeyaDQyGFhnlNVzWyV
    open-browser-0.2.1.1-LxNiN4VEneo8bxQiPfYDai
    optparse-applicative-0.18.1.0-9I3qDpNxi1rBTnWffPMXX3
    pretty-show-1.10-EXsS4VwIV5tJ56gbmVdfrR
    primitive-0.9.1.0-3wcULVX324m4b7zw32DKNg
    sdl2-2.5.5.1-3u3D3dPW4w01GTtVDTAJhk
    sdl2-ttf-2.1.3-ImVBncVjyBk7VwmvisBJ5F
    splitmix-0.1.3-87j9Z3zbWgUB3LG0YF5Tgd stm-2.5.1.0
    template-haskell-2.20.0.0 text-2.0.2
    th-lift-instances-0.1.20-Ej9sJgLZWdHHLklsPTxbOD time-1.12.2
    transformers-0.6.1.0
    unordered-containers-0.2.20.1-I6eyTXb69D2BhxejMtPouo
    vector-0.13.2.0-KFVS0U8K6eML5O0P7tVbRi
    vector-binary-instances-0.2.5.2-HZgfLZ0BeRq7aeVKAymBpS
    witch-1.2.0.2-KCfdEZJcUXX5HXuiPv5Ol1
    zlib-0.7.0.0-AoTprguvpA33AfeZgt1J6J

haddock-interfaces:   /usr/share/doc/haskell-lambdahack/html/LambdaHack.haddock
haddock-html:         /usr/share/doc/haskell-lambdahack/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

