/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import java.util.function.Function;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableModuleComponentMetaDataResolveResult<T>
extends DefaultResourceAwareResolveResult
implements BuildableModuleComponentMetaDataResolveResult<T> {
    private BuildableModuleComponentMetaDataResolveResult.State state = BuildableModuleComponentMetaDataResolveResult.State.Unknown;
    private ModuleVersionResolveException failure;
    private T metaData;
    private boolean authoritative;

    private void reset(BuildableModuleComponentMetaDataResolveResult.State state) {
        this.state = state;
        this.metaData = null;
        this.failure = null;
        this.authoritative = false;
    }

    public void reset() {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Unknown);
    }

    @Override
    public void resolved(T metaData) {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Resolved);
        this.failure = null;
        this.metaData = metaData;
        this.authoritative = true;
    }

    @Override
    public void setMetadata(T metaData) {
        this.assertResolved();
        this.metaData = metaData;
    }

    @Override
    public void missing() {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Missing);
        this.metaData = null;
        this.failure = null;
        this.authoritative = true;
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Failed);
        this.metaData = null;
        this.failure = failure;
        this.authoritative = true;
    }

    @Override
    public BuildableModuleComponentMetaDataResolveResult.State getState() {
        return this.state;
    }

    @Override
    public boolean hasResult() {
        return this.state != BuildableModuleComponentMetaDataResolveResult.State.Unknown;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    @Override
    public T getMetaData() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData;
    }

    @Override
    public boolean isAuthoritative() {
        this.assertHasResult();
        return this.authoritative;
    }

    @Override
    public void setAuthoritative(boolean authoritative) {
        this.assertHasResult();
        this.authoritative = authoritative;
    }

    @Override
    public void redirectToGradleMetadata() {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Redirect);
    }

    @Override
    public boolean shouldUseGradleMetatada() {
        return this.state == BuildableModuleComponentMetaDataResolveResult.State.Redirect;
    }

    public <S> void applyTo(BuildableModuleComponentMetaDataResolveResult<S> target, Function<T, S> resultMapper) {
        if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Resolved) {
            target.resolved(resultMapper.apply(this.metaData));
        } else if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Failed) {
            target.failed(this.failure);
        } else if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Redirect) {
            target.redirectToGradleMetadata();
        } else if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Missing) {
            target.missing();
        } else {
            throw new IllegalStateException();
        }
        target.setAuthoritative(this.authoritative);
        this.applyTo(target);
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }

    private void assertResolved() {
        if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Failed) {
            throw this.failure;
        }
        if (this.state != BuildableModuleComponentMetaDataResolveResult.State.Resolved) {
            throw new IllegalStateException("This module has not been resolved.");
        }
    }
}

