/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
class TestResultState {
    private final @Nullable TestResultState parent;
    private final AtomicLong totalCount = new AtomicLong(0L);
    private final AtomicLong successfulCount = new AtomicLong(0L);
    private final AtomicLong failureCount = new AtomicLong(0L);

    TestResultState(@Nullable TestResultState parent) {
        this.parent = parent;
    }

    long getTotalCount() {
        return this.totalCount.get();
    }

    void incrementTotalCount() {
        this.totalCount.incrementAndGet();
        if (this.parent != null) {
            this.parent.incrementTotalCount();
        }
    }

    long getSuccessfulCount() {
        return this.successfulCount.get();
    }

    void incrementSuccessfulCount() {
        this.successfulCount.incrementAndGet();
        if (this.parent != null) {
            this.parent.incrementSuccessfulCount();
        }
    }

    long getFailureCount() {
        return this.failureCount.get();
    }

    void incrementFailureCount() {
        this.failureCount.incrementAndGet();
        if (this.parent != null) {
            this.parent.incrementFailureCount();
        }
    }
}

