/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.util.ArrayList;
import java.util.List;
import org.freeplane.plugin.ai.chat.ChatListItemStatus;
import org.freeplane.plugin.ai.chat.LiveChatSessionId;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptId;
import org.freeplane.plugin.ai.chat.history.MapRootShortTextCount;

class ChatListItem {
    private final ChatListItemStatus status;
    private final LiveChatSessionId liveSessionId;
    private final ChatTranscriptId transcriptId;
    private final String displayName;
    private final List<MapRootShortTextCount> mapRootShortTextCounts;
    private final long lastUpdatedTimestamp;
    private final boolean currentLiveSession;

    ChatListItem(ChatListItemStatus status, LiveChatSessionId liveSessionId, ChatTranscriptId transcriptId, String displayName, List<MapRootShortTextCount> mapRootShortTextCounts, long lastUpdatedTimestamp, boolean currentLiveSession) {
        this.status = status;
        this.liveSessionId = liveSessionId;
        this.transcriptId = transcriptId;
        this.displayName = displayName;
        this.mapRootShortTextCounts = mapRootShortTextCounts == null ? new ArrayList() : mapRootShortTextCounts;
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        this.currentLiveSession = currentLiveSession;
    }

    ChatListItemStatus getStatus() {
        return this.status;
    }

    LiveChatSessionId getLiveSessionId() {
        return this.liveSessionId;
    }

    ChatTranscriptId getTranscriptId() {
        return this.transcriptId;
    }

    String getDisplayName() {
        return this.displayName;
    }

    List<MapRootShortTextCount> getMapRootShortTextCounts() {
        return new ArrayList<MapRootShortTextCount>(this.mapRootShortTextCounts);
    }

    long getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    boolean isCurrentLiveSession() {
        return this.currentLiveSession;
    }
}

