/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.mindmapmode.ClipboardAccessor;
import org.freeplane.features.icon.mindmapmode.JTagTree;
import org.freeplane.features.icon.mindmapmode.TagCategorySelection;

class TagTreeViewerFactory
implements IExtension {
    private final JTagTree tree;

    TagTreeViewerFactory(TagCategories tagCategories, Font tagFont) {
        this.tree = new JTagTree(tagCategories, tagFont);
        this.tree.setTransferHandler(new TreeTransferHandler());
        if (!GraphicsEnvironment.isHeadless()) {
            this.tree.setEditable(false);
            this.configureKeyBindings();
        }
    }

    private void configureKeyBindings() {
        ActionMap am = this.tree.getActionMap();
        AbstractAction copyNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagTreeViewerFactory.this.copyNodes();
            }
        };
        am.put(TransferHandler.getCopyAction().getValue("Name"), copyNodeAction);
    }

    boolean copyNodes() {
        TagCategorySelection t = this.tree.createTransferable();
        if (t != null) {
            Clipboard clipboard = ClipboardAccessor.getSystemClipboard();
            clipboard.setContents(t, null);
            return true;
        }
        return false;
    }

    JTagTree getTree() {
        return this.tree;
    }

    private class TreeTransferHandler
    extends TransferHandler {
        private TreeTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c != TagTreeViewerFactory.this.tree) {
                throw new IllegalArgumentException("Unexpected argument " + c);
            }
            return TagTreeViewerFactory.this.tree.createTransferable();
        }
    }
}

