/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.registry.AIPromptGeneratorDescriptor;

public class AIPromptGeneratorRegistry {
    private static final Log log = Log.getLog(AIPromptGeneratorRegistry.class);
    private static AIPromptGeneratorRegistry instance = null;
    private final Map<String, AIPromptGeneratorDescriptor> descriptorMap = new LinkedHashMap<String, AIPromptGeneratorDescriptor>();

    public static synchronized AIPromptGeneratorRegistry getInstance() {
        if (instance == null) {
            instance = new AIPromptGeneratorRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIPromptGeneratorRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.prompt")) {
            if (!"prompt".equals(ext.getName())) continue;
            AIPromptGeneratorDescriptor descriptor = new AIPromptGeneratorDescriptor(ext);
            this.descriptorMap.put(descriptor.getId(), descriptor);
        }
    }

    @Nullable
    public AIPromptGeneratorDescriptor getPromptGenerator(@NotNull String id) {
        return this.descriptorMap.get(id);
    }

    @NotNull
    public List<AIPromptGeneratorDescriptor> getAllPromptGenerator() {
        return this.descriptorMap.values().stream().toList();
    }
}

