/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.swt.events.SelectionEvent;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.forms.UIControlBuilder;
import org.jkiss.dbeaver.ui.forms.UIControlBuilderImpl;
import org.jkiss.dbeaver.ui.forms.UIObservable;
import org.jkiss.dbeaver.ui.forms.UIPanelBuilder;
import org.jkiss.dbeaver.ui.forms.UIPanelBuilderImpl;
import org.jkiss.dbeaver.ui.forms.UIRowBuilder;

final class UIRowBuilderImpl
implements UIRowBuilder {
    final List<UIControlBuilderImpl<?, ?>> controls = new ArrayList();
    final int indent;
    UIObservable<Boolean> visible;
    UIObservable<Boolean> enabled;

    UIRowBuilderImpl(int indent) {
        this.indent = indent;
    }

    @Override
    @NotNull
    public UIRowBuilder visible(@NotNull UIObservable<Boolean> binding) {
        this.visible = binding;
        return this;
    }

    @Override
    @NotNull
    public UIRowBuilder enabled(@NotNull UIObservable<Boolean> binding) {
        this.enabled = binding;
        return this;
    }

    @Override
    @NotNull
    public UIRowBuilder panel(@NotNull Consumer<? super UIPanelBuilder> handler) {
        UIPanelBuilderImpl builder = UIPanelBuilderImpl.panel();
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }

    @Override
    @NotNull
    public UIRowBuilder group(@NotNull String text, @NotNull Consumer<? super UIPanelBuilder> handler) {
        UIPanelBuilderImpl builder = UIPanelBuilderImpl.group(text);
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }

    @Override
    @NotNull
    public UIRowBuilder expandableGroup(@NotNull String text, boolean expanded, @NotNull Consumer<? super UIPanelBuilder> handler) {
        UIPanelBuilderImpl builder = UIPanelBuilderImpl.expandableGroup(text, expanded);
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }

    @Override
    @NotNull
    public UIRowBuilder label(@NotNull String text, @NotNull Consumer<? super UIControlBuilder.LabelBuilder> handler) {
        UIControlBuilderImpl.LabelBuilderImpl builder = new UIControlBuilderImpl.LabelBuilderImpl(text, 0);
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }

    @Override
    @NotNull
    public UIRowBuilder button(@NotNull String text, @NotNull Consumer<SelectionEvent> onSelect, @NotNull Consumer<? super UIControlBuilder.ButtonBuilder> handler) {
        UIControlBuilderImpl.ButtonBuilderImpl builder = new UIControlBuilderImpl.ButtonBuilderImpl(text, onSelect, 0);
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }

    @Override
    @NotNull
    public UIRowBuilder radioButton(@NotNull String text, @NotNull Consumer<? super UIControlBuilder.ButtonBuilder> handler) {
        UIControlBuilderImpl.ButtonBuilderImpl builder = new UIControlBuilderImpl.ButtonBuilderImpl(text, null, 16);
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }

    @Override
    @NotNull
    public UIRowBuilder checkBox(@NotNull String text, @NotNull Consumer<? super UIControlBuilder.ButtonBuilder> handler) {
        UIControlBuilderImpl.ButtonBuilderImpl builder = new UIControlBuilderImpl.ButtonBuilderImpl(text, null, 32);
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }

    @Override
    @NotNull
    public <T> UIRowBuilder textField(@NotNull UIObservable<T> binding, @NotNull Consumer<? super UIControlBuilder.TextBuilder<T>> handler) {
        UIControlBuilderImpl.TextBuilderImpl<T> builder = new UIControlBuilderImpl.TextBuilderImpl<T>(2048, binding);
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }

    @Override
    @NotNull
    public <T> UIRowBuilder passwordField(@NotNull UIObservable<T> binding, @NotNull Consumer<? super UIControlBuilder.TextBuilder<T>> handler) {
        UIControlBuilderImpl.TextBuilderImpl<T> builder = new UIControlBuilderImpl.TextBuilderImpl<T>(0x400800, binding);
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }

    @Override
    @NotNull
    public <T> UIRowBuilder comboBox(@NotNull List<? extends T> items, @NotNull UIObservable<T> binding, @NotNull Function<? super T, String> converter, @NotNull Consumer<? super UIControlBuilder.ComboBuilder<T>> handler) {
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Enum doesn't have any constants");
        }
        UIControlBuilderImpl.ComboBuilderImpl<? extends T> builder = new UIControlBuilderImpl.ComboBuilderImpl<T>(binding, converter, items, 2060);
        handler.accept(builder);
        this.controls.add(builder);
        return this;
    }
}

