/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.GroupTitle;
import java.util.Vector;

public class MergedGroupTitles
extends GroupTitle {
    private GroupTitle[] titles;
    private static long mergedGroupCount = 0L;

    public MergedGroupTitles(Bib2Gls bib2Gls, Vector<GroupTitle> vector) {
        super(bib2Gls, "", "", ++mergedGroupCount, null, null);
        if (vector.size() < 2) {
            throw new IllegalArgumentException("MergedGroupTitles requires 2 or more titles, list contains " + vector.size());
        }
        this.titles = new GroupTitle[vector.size()];
        for (int i = 0; i < this.titles.length; ++i) {
            this.titles[i] = vector.get(i);
        }
        this.type = this.titles[0].type;
        this.parent = this.titles[0].parent;
        this.level = this.titles[0].level;
        this.supportsHierarchy = this.titles[0].supportsHierarchy;
    }

    @Override
    protected String getNonHierCsSetName() {
        return "bibglssetmergedgrouptitle";
    }

    @Override
    protected String getNonHierCsLabelName() {
        return "bibglsmergedgroup";
    }

    @Override
    public String format(String string) {
        StringBuilder stringBuilder = new StringBuilder(String.format("{%d}{%s}{%d}{\\%s%s}{", this.getId(), this.type == null ? "" : this.type, this.titles.length, this.titles[0].getCsTitleName(), this.titles[0].toString()));
        int n = this.titles.length - 1;
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(String.format("{\\%s%s}", this.titles[i].getCsTitleName(), this.titles[i].toString()));
        }
        stringBuilder.append(String.format("}{\\%s%s}", this.titles[n].getCsTitleName(), this.titles[n].toString()));
        if (this.supportsHierarchy) {
            stringBuilder.append(String.format("{%s}{%d}", this.parent == null ? "" : this.parent, this.level));
        }
        return stringBuilder.toString();
    }

    public GroupTitle[] getGroupTitles() {
        return this.titles;
    }
}

