/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.image;

import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageWriter;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.WritableResourceSupport;
import org.apache.sis.internal.storage.image.WorldFileResource;
import org.apache.sis.internal.storage.image.WritableStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.apache.sis.storage.event.StoreListeners;

final class WritableResource
extends WorldFileResource
implements WritableGridCoverageResource {
    WritableResource(WritableStore writableStore, StoreListeners storeListeners, int n, GridGeometry gridGeometry) throws DataStoreException {
        super(writableStore, storeListeners, n, gridGeometry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(GridCoverage gridCoverage, WritableGridCoverageResource.Option ... optionArray) throws DataStoreException {
        WritableResourceSupport writableResourceSupport = new WritableResourceSupport(this, optionArray);
        WritableStore writableStore = (WritableStore)this.store();
        try {
            WritableStore writableStore2 = writableStore;
            synchronized (writableStore2) {
                if (this.getImageIndex() != 0 || writableStore.isMultiImages() != 0 && !writableResourceSupport.replace(null)) {
                    gridCoverage = writableResourceSupport.update(gridCoverage);
                }
                RenderedImage renderedImage = gridCoverage.render(null);
                writableStore.setGridGeometry(this.getImageIndex(), gridCoverage.getGridGeometry());
                this.setGridCoverage(gridCoverage);
                ImageWriter imageWriter = writableStore.writer();
                imageWriter.write(renderedImage);
            }
        }
        catch (IOException | RuntimeException exception) {
            throw new DataStoreException(writableStore.resources().getString((short)69, writableStore.getDisplayName()), exception);
        }
    }
}

