/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.NamedList;

public class SimpleOrderedMap<T>
extends NamedList<T>
implements Map<String, T> {
    private static final SimpleOrderedMap<Object> EMPTY = new SimpleOrderedMap(List.of());

    public SimpleOrderedMap() {
    }

    public SimpleOrderedMap(int sz) {
        super(sz);
    }

    private SimpleOrderedMap(List<Object> nameValuePairs) {
        super(nameValuePairs);
    }

    public SimpleOrderedMap(Map.Entry<String, T>[] nameValuePairs) {
        super(nameValuePairs);
    }

    public SimpleOrderedMap(MapWriter mapWriter) {
        try {
            mapWriter.writeMap(new MapWriter.EntryWriter(){

                @Override
                public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
                    SimpleOrderedMap.this.add(k.toString(), v);
                    return this;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SimpleOrderedMap<T> clone() {
        ArrayList<Object> newList = new ArrayList<Object>(this.nvPairs.size());
        newList.addAll(this.nvPairs);
        return new SimpleOrderedMap<T>(newList);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || new InnerMap().equals(obj);
    }

    @Override
    public int hashCode() {
        return new InnerMap().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.nvPairs.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOf((String)key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public T get(Object key) {
        return super.get((String)key);
    }

    @Override
    public T put(String key, T value) {
        int idx = this.indexOf(key);
        if (idx == -1) {
            this.add(key, value);
            return null;
        }
        Object t = this.get(key);
        this.setVal(idx, value);
        return t;
    }

    @Override
    public T remove(Object key) {
        return super.remove((String)key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        if (this.isEmpty()) {
            m.forEach(this::add);
        } else {
            m.forEach(this::put);
        }
    }

    @Override
    public Set<String> keySet() {
        return new InnerMap().keySet();
    }

    @Override
    public Collection<T> values() {
        return new InnerMap().values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return new AbstractSet<Map.Entry<String, T>>(){

            @Override
            public Iterator<Map.Entry<String, T>> iterator() {
                return SimpleOrderedMap.this.iterator();
            }

            @Override
            public int size() {
                return SimpleOrderedMap.this.size();
            }
        };
    }

    public static <T> SimpleOrderedMap<T> of(String name, T val) {
        return new SimpleOrderedMap<T>(List.of(name, val));
    }

    public static SimpleOrderedMap<Object> of() {
        return EMPTY;
    }

    private class InnerMap
    extends AbstractMap<String, T> {
        private InnerMap() {
        }

        @Override
        public Set<Map.Entry<String, T>> entrySet() {
            return SimpleOrderedMap.this.entrySet();
        }
    }
}

