/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Objects;
import org.apache.solr.common.cloud.ZkNodeProps;

public class ZkCoreNodeProps {
    private final ZkNodeProps nodeProps;

    public ZkCoreNodeProps(ZkNodeProps nodeProps) {
        this.nodeProps = nodeProps;
    }

    public String getCoreUrl() {
        return ZkCoreNodeProps.getCoreUrl(this.nodeProps);
    }

    public String getNodeName() {
        return this.nodeProps.getStr("node_name");
    }

    public String getState() {
        return this.nodeProps.getStr("state");
    }

    public String getBaseUrl() {
        return ZkCoreNodeProps.getBaseUrl(this.nodeProps);
    }

    public String getCoreName() {
        return this.nodeProps.getStr("core");
    }

    private static String getBaseUrl(ZkNodeProps nodeProps) {
        String baseUrl = nodeProps.getStr("base_url");
        if (baseUrl == null) {
            throw new IllegalStateException("base_url not set in: " + String.valueOf(nodeProps));
        }
        return baseUrl;
    }

    public static String getCoreUrl(ZkNodeProps nodeProps) {
        String baseUrl = ZkCoreNodeProps.getBaseUrl(nodeProps);
        return baseUrl != null ? ZkCoreNodeProps.getCoreUrl(baseUrl, nodeProps.getStr("core")) : null;
    }

    public static String getCoreUrl(String baseUrl, String coreName) {
        Objects.requireNonNull(baseUrl, "baseUrl must not be null");
        StringBuilder sb = new StringBuilder(baseUrl.length() + coreName.length() + 2);
        sb.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            sb.append("/");
        }
        sb.append(coreName != null ? coreName : "");
        if (!sb.substring(sb.length() - 1).equals("/")) {
            sb.append("/");
        }
        return sb.toString();
    }

    public String toString() {
        return this.nodeProps.toString();
    }

    public ZkNodeProps getNodeProps() {
        return this.nodeProps;
    }

    public boolean isLeader() {
        return this.nodeProps.containsKey("leader");
    }
}

