/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.trajectory.SingleTrajectoryObsDataset;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;

public class ZebraClassTrajectoryObsDataset
extends SingleTrajectoryObsDataset
implements TypedDatasetFactoryIF {
    private static String timeDimName = "time";
    private static String timeVarName = "time";
    private static String latVarName = "lat";
    private static String lonVarName = "lon";
    private static String elevVarName = "alt";
    private static String trajId = "trajectory data";

    public static boolean isValidFile(NetcdfDataset ncd) {
        return ZebraClassTrajectoryObsDataset.buildConfig(ncd) != null;
    }

    private static SingleTrajectoryObsDataset.Config buildConfig(NetcdfDataset ncd) {
        Attribute attrib = ncd.findGlobalAttributeIgnoreCase("zebra_platform");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        if (!attrib.getStringValue().equals("class")) {
            return null;
        }
        attrib = ncd.findGlobalAttributeIgnoreCase("history");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        if (!attrib.getStringValue().equals("ClassNcFile")) {
            return null;
        }
        attrib = ncd.findGlobalAttributeIgnoreCase("AvapsEditorVersion");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        attrib = ncd.findGlobalAttributeIgnoreCase("SoundingDescription");
        if (attrib == null) {
            return null;
        }
        if (!attrib.isString()) {
            return null;
        }
        List<Dimension> list = ncd.getRootGroup().getDimensions();
        if (list.size() != 1) {
            return null;
        }
        Dimension d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        SingleTrajectoryObsDataset.Config trajConfig = new SingleTrajectoryObsDataset.Config();
        trajConfig.setTimeDim(d);
        Variable var = ncd.getRootGroup().findVariable(timeVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        String units = var.findAttribute("units").getStringValue();
        Date date = DateUnit.getStandardDate("0 " + units);
        if (date == null) {
            return null;
        }
        trajConfig.setTimeVar(var);
        var = ncd.getRootGroup().findVariable(latVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "degrees_north")) {
            return null;
        }
        trajConfig.setLatVar(var);
        var = ncd.getRootGroup().findVariable(lonVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "degrees_east")) {
            return null;
        }
        trajConfig.setLonVar(var);
        var = ncd.getRootGroup().findVariable(elevVarName);
        if (var == null) {
            return null;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return null;
        }
        d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return null;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "meters")) {
            return null;
        }
        trajConfig.setElevVar(var);
        trajConfig.setTrajectoryId(trajId);
        return trajConfig;
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return ZebraClassTrajectoryObsDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new ZebraClassTrajectoryObsDataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.TRAJECTORY;
    }

    public ZebraClassTrajectoryObsDataset() {
    }

    public ZebraClassTrajectoryObsDataset(NetcdfDataset ncd) throws IOException {
        super(ncd);
        SingleTrajectoryObsDataset.Config trajConfig = ZebraClassTrajectoryObsDataset.buildConfig(ncd);
        this.setTrajectoryInfo(trajConfig);
    }
}

