/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.SphericalCS;

@XmlType(name="SphericalCSType")
@XmlRootElement(name="SphericalCS")
public class DefaultSphericalCS
extends AbstractCS
implements SphericalCS {
    private static final long serialVersionUID = 196295996465774477L;

    private DefaultSphericalCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    public DefaultSphericalCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    protected DefaultSphericalCS(SphericalCS sphericalCS) {
        super((CoordinateSystem)sphericalCS);
    }

    public static DefaultSphericalCS castOrCopy(SphericalCS sphericalCS) {
        return sphericalCS == null || sphericalCS instanceof DefaultSphericalCS ? (DefaultSphericalCS)sphericalCS : new DefaultSphericalCS(sphericalCS);
    }

    @Override
    final int validateAxis(AxisDirection axisDirection, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(axisDirection, false)) {
            return 1;
        }
        if (!Units.isAngular(unit) && !Units.isLinear(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends SphericalCS> getInterface() {
        return SphericalCS.class;
    }

    @Override
    public DefaultSphericalCS forConvention(AxesConvention axesConvention) {
        return (DefaultSphericalCS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCS createForAxes(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        switch (coordinateSystemAxisArray.length) {
            case 2: {
                return new DefaultPolarCS(map, coordinateSystemAxisArray);
            }
            case 3: {
                return new DefaultSphericalCS(map, coordinateSystemAxisArray);
            }
        }
        throw DefaultSphericalCS.unexpectedDimension(map, coordinateSystemAxisArray, 2);
    }

    private DefaultSphericalCS() {
    }
}

