/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.reporters;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import javax.management.MBeanServer;
import org.apache.solr.metrics.FilteringSolrMetricReporter;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.reporters.ReporterClientCache;
import org.apache.solr.metrics.reporters.jmx.JmxMetricsReporter;
import org.apache.solr.metrics.reporters.jmx.JmxObjectNameFactory;
import org.apache.solr.util.JmxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrJmxReporter
extends FilteringSolrMetricReporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final ReporterClientCache<MBeanServer> serviceRegistry = new ReporterClientCache();
    private String domain;
    private String agentId;
    private String serviceUrl;
    private String rootName;
    private MetricRegistry registry;
    private MBeanServer mBeanServer;
    private JmxMetricsReporter reporter;
    private String instanceTag;
    private boolean started;

    public SolrJmxReporter(SolrMetricManager metricManager, String registryName) {
        super(metricManager, registryName);
        this.period = 0;
        this.setDomain(registryName);
    }

    @Override
    protected synchronized void doInit() {
        if (this.serviceUrl != null && this.agentId != null) {
            this.mBeanServer = JmxUtil.findFirstMBeanServer();
            log.warn("No more than one of serviceUrl({}) and agentId({}) should be configured, using first MBeanServer {} instead of configuration.", new Object[]{this.serviceUrl, this.agentId, this.mBeanServer});
        } else if (this.serviceUrl != null) {
            this.mBeanServer = serviceRegistry.getOrCreate(this.serviceUrl, () -> JmxUtil.findMBeanServerForServiceUrl(this.serviceUrl));
        } else if (this.agentId != null) {
            this.mBeanServer = JmxUtil.findMBeanServerForAgentId(this.agentId);
        } else {
            this.mBeanServer = JmxUtil.findFirstMBeanServer();
            log.debug("No serviceUrl or agentId was configured, using first MBeanServer: {}", (Object)this.mBeanServer);
        }
        if (this.mBeanServer == null) {
            log.warn("No JMX server found. Not exposing Solr metrics via JMX.");
            return;
        }
        if (this.domain == null || this.domain.isEmpty()) {
            this.domain = this.registryName;
        }
        Object fullDomain = this.domain;
        if (this.rootName != null && !this.rootName.isEmpty()) {
            fullDomain = this.rootName + "." + this.domain;
        }
        JmxObjectNameFactory jmxObjectNameFactory = new JmxObjectNameFactory(this.pluginInfo.name, (String)fullDomain, new String[0]);
        this.registry = this.metricManager.registry(this.registryName);
        MetricFilter filter = this.newMetricFilter();
        this.instanceTag = Integer.toHexString(this.hashCode());
        this.reporter = JmxMetricsReporter.forRegistry(this.registry).registerWith(this.mBeanServer).inDomain((String)fullDomain).filter(filter).createsObjectNamesWith(jmxObjectNameFactory).withTag(this.instanceTag).build();
        this.reporter.start();
        this.started = true;
        log.debug("JMX monitoring for '{}' (registry '{}') enabled at server: {}", new Object[]{fullDomain, this.registryName, this.mBeanServer});
    }

    public String getInstanceTag() {
        return this.instanceTag;
    }

    @Override
    public synchronized void close() {
        log.debug("Closing reporter {} for registry {}/{}", new Object[]{this, this.registryName, this.registry});
        this.started = false;
        if (this.reporter != null) {
            this.reporter.close();
            this.reporter = null;
        }
    }

    @Override
    protected void validate() throws IllegalStateException {
        if (this.period != 0) {
            throw new IllegalStateException("Init argument 'period' is not supported for " + this.getClass().getCanonicalName());
        }
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void setDomain(String domain) {
        this.domain = domain != null ? domain : this.registryName;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getDomain() {
        return this.domain;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public boolean isActive() {
        return this.reporter != null;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public String toString() {
        return String.format(Locale.ENGLISH, "[%s@%s: rootName = %s, domain = %s, service url = %s, agent id = %s]", this.getClass().getName(), Integer.toHexString(this.hashCode()), this.rootName, this.domain, this.serviceUrl, this.agentId);
    }
}

