/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.solr.api.Api;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.CloneConfigsetRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.handler.configsets.CloneConfigSet;
import org.apache.solr.handler.configsets.ConfigSetAPIBase;
import org.apache.solr.handler.configsets.DeleteConfigSet;
import org.apache.solr.handler.configsets.ListConfigSets;
import org.apache.solr.handler.configsets.UploadConfigSet;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    public static final Boolean DISABLE_CREATE_AUTH_CHECKS = Boolean.getBoolean("solr.disableConfigSetsCreateAuthChecks");
    public static final String DEFAULT_CONFIGSET_NAME = "_default";
    public static final String AUTOCREATED_CONFIGSET_SUFFIX = ".AUTOCREATED";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    public static long CONFIG_SET_TIMEOUT = 300000L;

    public ConfigSetsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    public static String getSuffixedNameForAutoGeneratedConfigSet(String configName) {
        return configName + AUTOCREATED_CONFIGSET_SUFFIX;
    }

    public static boolean isAutoGeneratedConfigSet(String configName) {
        return configName != null && configName.endsWith(AUTOCREATED_CONFIGSET_SUFFIX);
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        this.checkErrors();
        RequiredSolrParams requiredSolrParams = req.getParams().required();
        String actionStr = requiredSolrParams.get("action");
        ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)actionStr);
        if (action == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + actionStr);
        }
        switch (action) {
            case DELETE: {
                DeleteConfigSet deleteConfigSetAPI = new DeleteConfigSet(this.coreContainer, req, rsp);
                SolrJerseyResponse deleteResponse = deleteConfigSetAPI.deleteConfigSet(req.getParams().required().get("name"));
                V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, deleteResponse);
                break;
            }
            case UPLOAD: {
                SolrJerseyResponse uploadResponse;
                UploadConfigSet uploadApi = new UploadConfigSet(this.coreContainer, req, rsp);
                String configSetName = req.getParams().required().get("name");
                boolean overwrite = req.getParams().getBool("overwrite", false);
                boolean cleanup = req.getParams().getBool("cleanup", false);
                InputStream configSetData = ConfigSetAPIBase.ensureNonEmptyInputStream(req);
                if (req.getParams().get("filePath", "").isEmpty()) {
                    uploadResponse = uploadApi.uploadConfigSet(configSetName, overwrite, cleanup, configSetData);
                } else {
                    String filePath = req.getParams().get("filePath");
                    uploadResponse = uploadApi.uploadConfigSetFile(configSetName, filePath, overwrite, cleanup, configSetData);
                }
                V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, uploadResponse);
                break;
            }
            case LIST: {
                ListConfigSets listConfigSetsAPI = new ListConfigSets(this.coreContainer);
                V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, listConfigSetsAPI.listConfigSet());
                break;
            }
            case CREATE: {
                String newConfigSetName = req.getParams().get("name");
                if (newConfigSetName == null || newConfigSetName.length() == 0) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ConfigSet name not specified");
                }
                CloneConfigsetRequestBody requestBody = new CloneConfigsetRequestBody();
                requestBody.name = newConfigSetName;
                requestBody.baseConfigSet = req.getParams().get("baseConfigSet") != null ? req.getParams().get("baseConfigSet") : DEFAULT_CONFIGSET_NAME;
                requestBody.properties = new HashMap();
                req.getParams().stream().filter(entry -> ((String)entry.getKey()).startsWith("configSetProp.")).forEach(entry -> {
                    String newKey = ((String)entry.getKey()).substring("configSetProp.".length());
                    Object value = ((String[])entry.getValue()).length == 1 ? ((String[])entry.getValue())[0] : entry.getValue();
                    requestBody.properties.put(newKey, value);
                });
                CloneConfigSet createConfigSetAPI = new CloneConfigSet(this.coreContainer, req, rsp);
                SolrJerseyResponse createResponse = createConfigSetAPI.cloneExistingConfigSet(requestBody);
                V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, createResponse);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected ConfigSetAction detected: " + String.valueOf(action));
            }
        }
        rsp.setHttpCaching(false);
    }

    protected void checkErrors() {
        if (this.coreContainer == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!this.coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud ConfigSets";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public Boolean registerV2() {
        return true;
    }

    @Override
    public Collection<Api> getApis() {
        return new ArrayList<Api>();
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        return List.of(ListConfigSets.class, CloneConfigSet.class, DeleteConfigSet.class, UploadConfigSet.class);
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String a = ctx.getParams().get("action");
        if (a != null) {
            ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)a);
            if (action == ConfigSetParams.ConfigSetAction.CREATE || action == ConfigSetParams.ConfigSetAction.DELETE || action == ConfigSetParams.ConfigSetAction.UPLOAD) {
                return PermissionNameProvider.Name.CONFIG_EDIT_PERM;
            }
            if (action == ConfigSetParams.ConfigSetAction.LIST) {
                return PermissionNameProvider.Name.CONFIG_READ_PERM;
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required parameter 'action' not provided");
    }
}

