/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.SourceEvaluator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrCore;

public class AnalyzeEvaluator
extends SourceEvaluator {
    private static final long serialVersionUID = 1L;
    private String fieldName;
    private String analyzerField;
    private Analyzer analyzer;

    public AnalyzeEvaluator(String _fieldName, String _analyzerField) {
        this.init(_fieldName, _analyzerField);
    }

    public AnalyzeEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        String _fieldName = factory.getValueOperand(expression, 0);
        String _analyzerField = factory.getValueOperand(expression, 1);
        this.init(_fieldName, _analyzerField);
    }

    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
        Object solrCoreObj = context.get((Object)"solr-core");
        if (solrCoreObj == null || !(solrCoreObj instanceof SolrCore)) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "StreamContext must have SolrCore in solr-core key");
        }
        this.analyzer = ((SolrCore)solrCoreObj).getLatestSchema().getFieldType(this.analyzerField).getIndexAnalyzer();
    }

    private void init(String fieldName, String analyzerField) {
        this.fieldName = fieldName;
        this.analyzerField = analyzerField == null ? fieldName : analyzerField;
    }

    public Object evaluate(Tuple tuple) throws IOException {
        String value = null;
        Object obj = tuple.get(this.fieldName);
        value = obj == null ? this.fieldName : obj.toString();
        ArrayList<String> tokens = new ArrayList<String>();
        try (TokenStream tokenStream = this.analyzer.tokenStream(this.analyzerField, value);){
            CharTermAttribute termAtt = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                tokens.add(termAtt.toString());
            }
            tokenStream.end();
        }
        return tokens;
    }

    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpressionValue(this.fieldName);
    }

    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

