/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.opentelemetry;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.opentracingshim.OpenTracingShim;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentracing.Tracer;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.TracerConfigurator;
import org.apache.solr.opentelemetry.ClosableTracerShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelTracerConfigurator
extends TracerConfigurator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    Map<String, String> currentEnv = System.getenv();

    public void init(NamedList<?> args) {
        this.injectPluginSettingsIfNotConfigured(args);
    }

    public Tracer getTracer() {
        this.setDefaultIfNotConfigured("OTEL_SERVICE_NAME", "solr");
        this.setDefaultIfNotConfigured("OTEL_TRACES_EXPORTER", "otlp");
        this.setDefaultIfNotConfigured("OTEL_EXPORTER_OTLP_PROTOCOL", "grpc");
        this.setDefaultIfNotConfigured("OTEL_TRACES_SAMPLER", "parentbased_always_on");
        if (EnvUtils.getProperty((String)"host") != null) {
            this.addOtelResourceAttributes(Map.of("host.name", EnvUtils.getProperty((String)"host")));
        }
        String currentConfig = this.getCurrentOtelConfigAsString();
        log.info("OpenTelemetry tracer enabled with configuration: {}", (Object)currentConfig);
        String metricsExporter = this.getEnvOrSysprop("OTEL_METRICS_EXPORTER");
        String logsExporter = this.getEnvOrSysprop("OTEL_LOGS_EXPORTER");
        if (metricsExporter != null && !Objects.equals(metricsExporter, "none") || logsExporter != null && !Objects.equals(logsExporter, "none")) {
            log.warn("The opentelemetry module does not support METRICS or LOGS. Ignoring faulty environment setting");
        }
        System.setProperty("otel.metrics.exporter", "none");
        System.setProperty("otel.logs.exporter", "none");
        OpenTelemetrySdk otelSdk = AutoConfiguredOpenTelemetrySdk.initialize().getOpenTelemetrySdk();
        Tracer shim = OpenTracingShim.createTracerShim((OpenTelemetry)otelSdk);
        return new ClosableTracerShim(shim, otelSdk.getSdkTracerProvider());
    }

    private void injectPluginSettingsIfNotConfigured(NamedList<?> args) {
        args.forEach((k, v) -> {
            String asSysName = OtelTracerConfigurator.envNameToSyspropName((String)k);
            if (asSysName.startsWith("otel.")) {
                this.setDefaultIfNotConfigured(asSysName, v.toString());
            }
        });
    }

    void addOtelResourceAttributes(Map<String, String> attrsToAdd) {
        String commaSepAttrs = this.getEnvOrSysprop("OTEL_RESOURCE_ATTRIBUTES");
        HashMap<String, String> attrs = new HashMap<String, String>(attrsToAdd);
        if (commaSepAttrs != null) {
            attrs.putAll(Arrays.stream(commaSepAttrs.split(",")).filter(e -> e.contains("=")).map(e -> e.strip().split("=")).collect(Collectors.toMap(kv -> kv[0], kv -> kv[1])));
        }
        System.setProperty(OtelTracerConfigurator.envNameToSyspropName((String)"OTEL_RESOURCE_ATTRIBUTES"), attrs.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")));
    }

    String getCurrentOtelConfigAsString() {
        return this.getCurrentOtelConfig().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("; "));
    }

    Map<String, String> getCurrentOtelConfig() {
        HashMap<String, String> currentConfig = new HashMap<String, String>();
        this.currentEnv.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("OTEL_")).forEach(entry -> currentConfig.put((String)entry.getKey(), (String)entry.getValue()));
        EnvUtils.getProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("otel.")).forEach(entry -> {
            String key = (String)entry.getKey();
            String envKey = key.toUpperCase(Locale.ROOT).replace('.', '_');
            String value = (String)entry.getValue();
            currentConfig.put(envKey, value);
        });
        return currentConfig;
    }

    String getEnvOrSysprop(String envName) {
        return OtelTracerConfigurator.getConfig((String)envName, this.currentEnv);
    }

    void setDefaultIfNotConfigured(String envName, String defaultValue) {
        String incomingValue = this.getEnvOrSysprop(envName);
        if (incomingValue == null) {
            EnvUtils.setProperty((String)OtelTracerConfigurator.envNameToSyspropName((String)envName), (String)defaultValue);
            if (log.isDebugEnabled()) {
                log.debug("Using default setting {}={}", (Object)envName, (Object)this.getEnvOrSysprop(envName));
            }
        }
    }
}

