// Copyright (c) 2008 Roberto Raggi <roberto.raggi@gmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

//
//  W A R N I N G
//  -------------
//
// This file is automatically generated by "cplusplus-update-frontend".
// Changes will be lost.
//

#pragma once

#include "CPlusPlusForwardDeclarations.h"
#include "AST.h"
#include "MemoryPool.h"

namespace CPlusPlus {

class CPLUSPLUS_EXPORT ASTPatternBuilder
{
    MemoryPool pool;

public:
    ASTPatternBuilder() {}

    void reset() { pool.reset(); }

    ObjCSelectorArgumentAST *ObjCSelectorArgument()
    {
        ObjCSelectorArgumentAST *ast = new (&pool) ObjCSelectorArgumentAST;
        return ast;
    }

    ObjCSelectorAST *ObjCSelector(ObjCSelectorArgumentListAST *selector_argument_list = nullptr)
    {
        ObjCSelectorAST *ast = new (&pool) ObjCSelectorAST;
        ast->selector_argument_list = selector_argument_list;
        return ast;
    }

    SimpleSpecifierAST *SimpleSpecifier()
    {
        SimpleSpecifierAST *ast = new (&pool) SimpleSpecifierAST;
        return ast;
    }

    AlignmentSpecifierAST *AlignmentSpecifier(ExpressionAST *typeIdExprOrAlignmentExpr = nullptr)
    {
        AlignmentSpecifierAST *ast = new (&pool) AlignmentSpecifierAST;
        ast->typeIdExprOrAlignmentExpr = typeIdExprOrAlignmentExpr;
        return ast;
    }

    GnuAttributeSpecifierAST *GnuAttributeSpecifier(GnuAttributeListAST *attribute_list = nullptr)
    {
        GnuAttributeSpecifierAST *ast = new (&pool) GnuAttributeSpecifierAST;
        ast->attribute_list = attribute_list;
        return ast;
    }

    MsvcDeclspecSpecifierAST *MsvcDeclspecSpecifier(GnuAttributeListAST *attribute_list = nullptr)
    {
        MsvcDeclspecSpecifierAST *ast = new (&pool) MsvcDeclspecSpecifierAST;
        ast->attribute_list = attribute_list;
        return ast;
    }

    StdAttributeSpecifierAST *StdAttributeSpecifier(GnuAttributeListAST *attribute_list = nullptr)
    {
        StdAttributeSpecifierAST *ast = new (&pool) StdAttributeSpecifierAST;
        ast->attribute_list = attribute_list;
        return ast;
    }

    GnuAttributeAST *GnuAttribute(ExpressionListAST *expression_list = nullptr)
    {
        GnuAttributeAST *ast = new (&pool) GnuAttributeAST;
        ast->expression_list = expression_list;
        return ast;
    }

    TypeofSpecifierAST *TypeofSpecifier(ExpressionAST *expression = nullptr)
    {
        TypeofSpecifierAST *ast = new (&pool) TypeofSpecifierAST;
        ast->expression = expression;
        return ast;
    }

    DecltypeSpecifierAST *DecltypeSpecifier(ExpressionAST *expression = nullptr)
    {
        DecltypeSpecifierAST *ast = new (&pool) DecltypeSpecifierAST;
        ast->expression = expression;
        return ast;
    }

    DeclaratorAST *Declarator(SpecifierListAST *attribute_list = nullptr, PtrOperatorListAST *ptr_operator_list = nullptr, CoreDeclaratorAST *core_declarator = nullptr, PostfixDeclaratorListAST *postfix_declarator_list = nullptr, SpecifierListAST *post_attribute_list = nullptr, ExpressionAST *initializer = nullptr)
    {
        DeclaratorAST *ast = new (&pool) DeclaratorAST;
        ast->attribute_list = attribute_list;
        ast->ptr_operator_list = ptr_operator_list;
        ast->core_declarator = core_declarator;
        ast->postfix_declarator_list = postfix_declarator_list;
        ast->post_attribute_list = post_attribute_list;
        ast->initializer = initializer;
        return ast;
    }

    SimpleDeclarationAST *SimpleDeclaration(SpecifierListAST *decl_specifier_list = nullptr, DeclaratorListAST *declarator_list = nullptr)
    {
        SimpleDeclarationAST *ast = new (&pool) SimpleDeclarationAST;
        ast->decl_specifier_list = decl_specifier_list;
        ast->declarator_list = declarator_list;
        return ast;
    }

    EmptyDeclarationAST *EmptyDeclaration()
    {
        EmptyDeclarationAST *ast = new (&pool) EmptyDeclarationAST;
        return ast;
    }

    AccessDeclarationAST *AccessDeclaration()
    {
        AccessDeclarationAST *ast = new (&pool) AccessDeclarationAST;
        return ast;
    }

    QtObjectTagAST *QtObjectTag()
    {
        QtObjectTagAST *ast = new (&pool) QtObjectTagAST;
        return ast;
    }

    QtPrivateSlotAST *QtPrivateSlot(SpecifierListAST *type_specifier_list = nullptr, DeclaratorAST *declarator = nullptr)
    {
        QtPrivateSlotAST *ast = new (&pool) QtPrivateSlotAST;
        ast->type_specifier_list = type_specifier_list;
        ast->declarator = declarator;
        return ast;
    }

    QtPropertyDeclarationItemAST *QtPropertyDeclarationItem(ExpressionAST *expression = nullptr)
    {
        QtPropertyDeclarationItemAST *ast = new (&pool) QtPropertyDeclarationItemAST;
        ast->expression = expression;
        return ast;
    }

    QtPropertyDeclarationAST *QtPropertyDeclaration(ExpressionAST *expression = nullptr, ExpressionAST *type_id = nullptr, NameAST *property_name = nullptr, QtPropertyDeclarationItemListAST *property_declaration_item_list = nullptr)
    {
        QtPropertyDeclarationAST *ast = new (&pool) QtPropertyDeclarationAST;
        ast->expression = expression;
        ast->type_id = type_id;
        ast->property_name = property_name;
        ast->property_declaration_item_list = property_declaration_item_list;
        return ast;
    }

    QtEnumDeclarationAST *QtEnumDeclaration(NameListAST *enumerator_list = nullptr)
    {
        QtEnumDeclarationAST *ast = new (&pool) QtEnumDeclarationAST;
        ast->enumerator_list = enumerator_list;
        return ast;
    }

    QtFlagsDeclarationAST *QtFlagsDeclaration(NameListAST *flag_enums_list = nullptr)
    {
        QtFlagsDeclarationAST *ast = new (&pool) QtFlagsDeclarationAST;
        ast->flag_enums_list = flag_enums_list;
        return ast;
    }

    QtInterfaceNameAST *QtInterfaceName(NameAST *interface_name = nullptr, NameListAST *constraint_list = nullptr)
    {
        QtInterfaceNameAST *ast = new (&pool) QtInterfaceNameAST;
        ast->interface_name = interface_name;
        ast->constraint_list = constraint_list;
        return ast;
    }

    QtInterfacesDeclarationAST *QtInterfacesDeclaration(QtInterfaceNameListAST *interface_name_list = nullptr)
    {
        QtInterfacesDeclarationAST *ast = new (&pool) QtInterfacesDeclarationAST;
        ast->interface_name_list = interface_name_list;
        return ast;
    }

    AsmDefinitionAST *AsmDefinition()
    {
        AsmDefinitionAST *ast = new (&pool) AsmDefinitionAST;
        return ast;
    }

    BaseSpecifierAST *BaseSpecifier(NameAST *name = nullptr)
    {
        BaseSpecifierAST *ast = new (&pool) BaseSpecifierAST;
        ast->name = name;
        return ast;
    }

    IdExpressionAST *IdExpression(NameAST *name = nullptr)
    {
        IdExpressionAST *ast = new (&pool) IdExpressionAST;
        ast->name = name;
        return ast;
    }

    CompoundExpressionAST *CompoundExpression(CompoundStatementAST *statement = nullptr)
    {
        CompoundExpressionAST *ast = new (&pool) CompoundExpressionAST;
        ast->statement = statement;
        return ast;
    }

    CompoundLiteralAST *CompoundLiteral(ExpressionAST *type_id = nullptr, ExpressionAST *initializer = nullptr)
    {
        CompoundLiteralAST *ast = new (&pool) CompoundLiteralAST;
        ast->type_id = type_id;
        ast->initializer = initializer;
        return ast;
    }

    QtMethodAST *QtMethod(DeclaratorAST *declarator = nullptr)
    {
        QtMethodAST *ast = new (&pool) QtMethodAST;
        ast->declarator = declarator;
        return ast;
    }

    QtMemberDeclarationAST *QtMemberDeclaration(ExpressionAST *type_id = nullptr)
    {
        QtMemberDeclarationAST *ast = new (&pool) QtMemberDeclarationAST;
        ast->type_id = type_id;
        return ast;
    }

    BinaryExpressionAST *BinaryExpression(ExpressionAST *left_expression = nullptr, ExpressionAST *right_expression = nullptr)
    {
        BinaryExpressionAST *ast = new (&pool) BinaryExpressionAST;
        ast->left_expression = left_expression;
        ast->right_expression = right_expression;
        return ast;
    }

    CastExpressionAST *CastExpression(ExpressionAST *type_id = nullptr, ExpressionAST *expression = nullptr)
    {
        CastExpressionAST *ast = new (&pool) CastExpressionAST;
        ast->type_id = type_id;
        ast->expression = expression;
        return ast;
    }

    ClassSpecifierAST *ClassSpecifier(SpecifierListAST *attribute_list = nullptr, NameAST *name = nullptr, BaseSpecifierListAST *base_clause_list = nullptr, DeclarationListAST *member_specifier_list = nullptr)
    {
        ClassSpecifierAST *ast = new (&pool) ClassSpecifierAST;
        ast->attribute_list = attribute_list;
        ast->name = name;
        ast->base_clause_list = base_clause_list;
        ast->member_specifier_list = member_specifier_list;
        return ast;
    }

    CaseStatementAST *CaseStatement(ExpressionAST *expression = nullptr, StatementAST *statement = nullptr)
    {
        CaseStatementAST *ast = new (&pool) CaseStatementAST;
        ast->expression = expression;
        ast->statement = statement;
        return ast;
    }

    CompoundStatementAST *CompoundStatement(StatementListAST *statement_list = nullptr)
    {
        CompoundStatementAST *ast = new (&pool) CompoundStatementAST;
        ast->statement_list = statement_list;
        return ast;
    }

    ConditionAST *Condition(SpecifierListAST *type_specifier_list = nullptr, DeclaratorAST *declarator = nullptr)
    {
        ConditionAST *ast = new (&pool) ConditionAST;
        ast->type_specifier_list = type_specifier_list;
        ast->declarator = declarator;
        return ast;
    }

    ConditionalExpressionAST *ConditionalExpression(ExpressionAST *condition = nullptr, ExpressionAST *left_expression = nullptr, ExpressionAST *right_expression = nullptr)
    {
        ConditionalExpressionAST *ast = new (&pool) ConditionalExpressionAST;
        ast->condition = condition;
        ast->left_expression = left_expression;
        ast->right_expression = right_expression;
        return ast;
    }

    CppCastExpressionAST *CppCastExpression(ExpressionAST *type_id = nullptr, ExpressionAST *expression = nullptr)
    {
        CppCastExpressionAST *ast = new (&pool) CppCastExpressionAST;
        ast->type_id = type_id;
        ast->expression = expression;
        return ast;
    }

    CtorInitializerAST *CtorInitializer(MemInitializerListAST *member_initializer_list = nullptr)
    {
        CtorInitializerAST *ast = new (&pool) CtorInitializerAST;
        ast->member_initializer_list = member_initializer_list;
        return ast;
    }

    DeclarationStatementAST *DeclarationStatement(DeclarationAST *declaration = nullptr)
    {
        DeclarationStatementAST *ast = new (&pool) DeclarationStatementAST;
        ast->declaration = declaration;
        return ast;
    }

    DeclaratorIdAST *DeclaratorId(NameAST *name = nullptr)
    {
        DeclaratorIdAST *ast = new (&pool) DeclaratorIdAST;
        ast->name = name;
        return ast;
    }

    DecompositionDeclaratorAST *DecompositionDeclarator(NameListAST *names = nullptr)
    {
        const auto ast = new (&pool) DecompositionDeclaratorAST;
        ast->identifiers = names;
        return ast;
    }

    NestedDeclaratorAST *NestedDeclarator(DeclaratorAST *declarator = nullptr)
    {
        NestedDeclaratorAST *ast = new (&pool) NestedDeclaratorAST;
        ast->declarator = declarator;
        return ast;
    }

    FunctionDeclaratorAST *FunctionDeclarator(ParameterDeclarationClauseAST *parameter_declaration_clause = nullptr, SpecifierListAST *cv_qualifier_list = nullptr, ExceptionSpecificationAST *exception_specification = nullptr, TrailingReturnTypeAST *trailing_return_type = nullptr, ExpressionAST *as_cpp_initializer = nullptr)
    {
        FunctionDeclaratorAST *ast = new (&pool) FunctionDeclaratorAST;
        ast->parameter_declaration_clause = parameter_declaration_clause;
        ast->cv_qualifier_list = cv_qualifier_list;
        ast->exception_specification = exception_specification;
        ast->trailing_return_type = trailing_return_type;
        ast->as_cpp_initializer = as_cpp_initializer;
        return ast;
    }

    ArrayDeclaratorAST *ArrayDeclarator(ExpressionAST *expression = nullptr)
    {
        ArrayDeclaratorAST *ast = new (&pool) ArrayDeclaratorAST;
        ast->expression = expression;
        return ast;
    }

    DeleteExpressionAST *DeleteExpression(ExpressionAST *expression = nullptr)
    {
        DeleteExpressionAST *ast = new (&pool) DeleteExpressionAST;
        ast->expression = expression;
        return ast;
    }

    DoStatementAST *DoStatement(StatementAST *statement = nullptr, ExpressionAST *expression = nullptr)
    {
        DoStatementAST *ast = new (&pool) DoStatementAST;
        ast->statement = statement;
        ast->expression = expression;
        return ast;
    }

    NamedTypeSpecifierAST *NamedTypeSpecifier(NameAST *name = nullptr)
    {
        NamedTypeSpecifierAST *ast = new (&pool) NamedTypeSpecifierAST;
        ast->name = name;
        return ast;
    }

    ElaboratedTypeSpecifierAST *ElaboratedTypeSpecifier(SpecifierListAST *attribute_list = nullptr, NameAST *name = nullptr)
    {
        ElaboratedTypeSpecifierAST *ast = new (&pool) ElaboratedTypeSpecifierAST;
        ast->attribute_list = attribute_list;
        ast->name = name;
        return ast;
    }

    EnumSpecifierAST *EnumSpecifier(NameAST *name = nullptr, SpecifierListAST *type_specifier_list = nullptr, EnumeratorListAST *enumerator_list = nullptr)
    {
        EnumSpecifierAST *ast = new (&pool) EnumSpecifierAST;
        ast->name = name;
        ast->type_specifier_list = type_specifier_list;
        ast->enumerator_list = enumerator_list;
        return ast;
    }

    EnumeratorAST *Enumerator(ExpressionAST *expression = nullptr)
    {
        EnumeratorAST *ast = new (&pool) EnumeratorAST;
        ast->expression = expression;
        return ast;
    }

    ExceptionDeclarationAST *ExceptionDeclaration(SpecifierListAST *type_specifier_list = nullptr, DeclaratorAST *declarator = nullptr)
    {
        ExceptionDeclarationAST *ast = new (&pool) ExceptionDeclarationAST;
        ast->type_specifier_list = type_specifier_list;
        ast->declarator = declarator;
        return ast;
    }

    DynamicExceptionSpecificationAST *DynamicExceptionSpecification(ExpressionListAST *type_id_list = nullptr)
    {
        DynamicExceptionSpecificationAST *ast = new (&pool) DynamicExceptionSpecificationAST;
        ast->type_id_list = type_id_list;
        return ast;
    }

    NoExceptSpecificationAST *NoExceptSpecification(ExpressionAST *expression = nullptr)
    {
        NoExceptSpecificationAST *ast = new (&pool) NoExceptSpecificationAST;
        ast->expression = expression;
        return ast;
    }

    ExpressionOrDeclarationStatementAST *ExpressionOrDeclarationStatement(ExpressionStatementAST *expression = nullptr, DeclarationStatementAST *declaration = nullptr)
    {
        ExpressionOrDeclarationStatementAST *ast = new (&pool) ExpressionOrDeclarationStatementAST;
        ast->expression = expression;
        ast->declaration = declaration;
        return ast;
    }

    ExpressionStatementAST *ExpressionStatement(ExpressionAST *expression = nullptr)
    {
        ExpressionStatementAST *ast = new (&pool) ExpressionStatementAST;
        ast->expression = expression;
        return ast;
    }

    FunctionDefinitionAST *FunctionDefinition(SpecifierListAST *decl_specifier_list = nullptr, DeclaratorAST *declarator = nullptr, CtorInitializerAST *ctor_initializer = nullptr, StatementAST *function_body = nullptr)
    {
        FunctionDefinitionAST *ast = new (&pool) FunctionDefinitionAST;
        ast->decl_specifier_list = decl_specifier_list;
        ast->declarator = declarator;
        ast->ctor_initializer = ctor_initializer;
        ast->function_body = function_body;
        return ast;
    }

    ForeachStatementAST *ForeachStatement(SpecifierListAST *type_specifier_list = nullptr, DeclaratorAST *declarator = nullptr, ExpressionAST *initializer = nullptr, ExpressionAST *expression = nullptr, StatementAST *statement = nullptr)
    {
        ForeachStatementAST *ast = new (&pool) ForeachStatementAST;
        ast->type_specifier_list = type_specifier_list;
        ast->declarator = declarator;
        ast->initializer = initializer;
        ast->expression = expression;
        ast->statement = statement;
        return ast;
    }

    RangeBasedForStatementAST *RangeBasedForStatement(SpecifierListAST *type_specifier_list = nullptr, DeclaratorAST *declarator = nullptr, ExpressionAST *expression = nullptr, StatementAST *statement = nullptr)
    {
        RangeBasedForStatementAST *ast = new (&pool) RangeBasedForStatementAST;
        ast->type_specifier_list = type_specifier_list;
        ast->declarator = declarator;
        ast->expression = expression;
        ast->statement = statement;
        return ast;
    }

    ForStatementAST *ForStatement(StatementAST *initializer = nullptr, ExpressionAST *condition = nullptr, ExpressionAST *expression = nullptr, StatementAST *statement = nullptr)
    {
        ForStatementAST *ast = new (&pool) ForStatementAST;
        ast->initializer = initializer;
        ast->condition = condition;
        ast->expression = expression;
        ast->statement = statement;
        return ast;
    }

    IfStatementAST *IfStatement(ExpressionAST *condition = nullptr, StatementAST *statement = nullptr, StatementAST *else_statement = nullptr)
    {
        IfStatementAST *ast = new (&pool) IfStatementAST;
        ast->condition = condition;
        ast->statement = statement;
        ast->else_statement = else_statement;
        return ast;
    }

    ArrayInitializerAST *ArrayInitializer(ExpressionListAST *expression_list = nullptr)
    {
        ArrayInitializerAST *ast = new (&pool) ArrayInitializerAST;
        ast->expression_list = expression_list;
        return ast;
    }

    LabeledStatementAST *LabeledStatement(StatementAST *statement = nullptr)
    {
        LabeledStatementAST *ast = new (&pool) LabeledStatementAST;
        ast->statement = statement;
        return ast;
    }

    LinkageBodyAST *LinkageBody(DeclarationListAST *declaration_list = nullptr)
    {
        LinkageBodyAST *ast = new (&pool) LinkageBodyAST;
        ast->declaration_list = declaration_list;
        return ast;
    }

    LinkageSpecificationAST *LinkageSpecification(DeclarationAST *declaration = nullptr)
    {
        LinkageSpecificationAST *ast = new (&pool) LinkageSpecificationAST;
        ast->declaration = declaration;
        return ast;
    }

    MemInitializerAST *MemInitializer(NameAST *name = nullptr, ExpressionAST *expression = nullptr)
    {
        MemInitializerAST *ast = new (&pool) MemInitializerAST;
        ast->name = name;
        ast->expression = expression;
        return ast;
    }

    NestedNameSpecifierAST *NestedNameSpecifier(NameAST *class_or_namespace_name = nullptr)
    {
        NestedNameSpecifierAST *ast = new (&pool) NestedNameSpecifierAST;
        ast->class_or_namespace_name = class_or_namespace_name;
        return ast;
    }

    QualifiedNameAST *QualifiedName(NestedNameSpecifierListAST *nested_name_specifier_list = nullptr, NameAST *unqualified_name = nullptr)
    {
        QualifiedNameAST *ast = new (&pool) QualifiedNameAST;
        ast->nested_name_specifier_list = nested_name_specifier_list;
        ast->unqualified_name = unqualified_name;
        return ast;
    }

    OperatorFunctionIdAST *OperatorFunctionId(OperatorAST *op = nullptr)
    {
        OperatorFunctionIdAST *ast = new (&pool) OperatorFunctionIdAST;
        ast->op = op;
        return ast;
    }

    ConversionFunctionIdAST *ConversionFunctionId(SpecifierListAST *type_specifier_list = nullptr, PtrOperatorListAST *ptr_operator_list = nullptr)
    {
        ConversionFunctionIdAST *ast = new (&pool) ConversionFunctionIdAST;
        ast->type_specifier_list = type_specifier_list;
        ast->ptr_operator_list = ptr_operator_list;
        return ast;
    }

    AnonymousNameAST *AnonymousName()
    {
        AnonymousNameAST *ast = new (&pool) AnonymousNameAST;
        return ast;
    }

    SimpleNameAST *SimpleName()
    {
        SimpleNameAST *ast = new (&pool) SimpleNameAST;
        return ast;
    }

    DestructorNameAST *DestructorName(NameAST *unqualified_name = nullptr)
    {
        DestructorNameAST *ast = new (&pool) DestructorNameAST;
        ast->unqualified_name = unqualified_name;
        return ast;
    }

    TemplateIdAST *TemplateId(ExpressionListAST *template_argument_list = nullptr)
    {
        TemplateIdAST *ast = new (&pool) TemplateIdAST;
        ast->template_argument_list = template_argument_list;
        return ast;
    }

    NamespaceAST *Namespace(SpecifierListAST *attribute_list = nullptr, DeclarationAST *linkage_body = nullptr)
    {
        NamespaceAST *ast = new (&pool) NamespaceAST;
        ast->attribute_list = attribute_list;
        ast->linkage_body = linkage_body;
        return ast;
    }

    NamespaceAliasDefinitionAST *NamespaceAliasDefinition(NameAST *name = nullptr)
    {
        NamespaceAliasDefinitionAST *ast = new (&pool) NamespaceAliasDefinitionAST;
        ast->name = name;
        return ast;
    }

    AliasDeclarationAST *AliasDeclaration(NameAST *name = nullptr, TypeIdAST *typeId = nullptr)
    {
        AliasDeclarationAST *ast = new (&pool) AliasDeclarationAST;
        ast->name = name;
        ast->typeId = typeId;
        return ast;
    }

    ExpressionListParenAST *ExpressionListParen(ExpressionListAST *expression_list = nullptr)
    {
        ExpressionListParenAST *ast = new (&pool) ExpressionListParenAST;
        ast->expression_list = expression_list;
        return ast;
    }

    NewArrayDeclaratorAST *NewArrayDeclarator(ExpressionAST *expression = nullptr)
    {
        NewArrayDeclaratorAST *ast = new (&pool) NewArrayDeclaratorAST;
        ast->expression = expression;
        return ast;
    }

    NewExpressionAST *NewExpression(ExpressionListParenAST *new_placement = nullptr, ExpressionAST *type_id = nullptr, NewTypeIdAST *new_type_id = nullptr, ExpressionAST *new_initializer = nullptr)
    {
        NewExpressionAST *ast = new (&pool) NewExpressionAST;
        ast->new_placement = new_placement;
        ast->type_id = type_id;
        ast->new_type_id = new_type_id;
        ast->new_initializer = new_initializer;
        return ast;
    }

    NewTypeIdAST *NewTypeId(SpecifierListAST *type_specifier_list = nullptr, PtrOperatorListAST *ptr_operator_list = nullptr, NewArrayDeclaratorListAST *new_array_declarator_list = nullptr)
    {
        NewTypeIdAST *ast = new (&pool) NewTypeIdAST;
        ast->type_specifier_list = type_specifier_list;
        ast->ptr_operator_list = ptr_operator_list;
        ast->new_array_declarator_list = new_array_declarator_list;
        return ast;
    }

    OperatorAST *Operator()
    {
        OperatorAST *ast = new (&pool) OperatorAST;
        return ast;
    }

    ParameterDeclarationAST *ParameterDeclaration(SpecifierListAST *type_specifier_list = nullptr, DeclaratorAST *declarator = nullptr, ExpressionAST *expression = nullptr)
    {
        ParameterDeclarationAST *ast = new (&pool) ParameterDeclarationAST;
        ast->type_specifier_list = type_specifier_list;
        ast->declarator = declarator;
        ast->expression = expression;
        return ast;
    }

    ParameterDeclarationClauseAST *ParameterDeclarationClause(ParameterDeclarationListAST *parameter_declaration_list = nullptr)
    {
        ParameterDeclarationClauseAST *ast = new (&pool) ParameterDeclarationClauseAST;
        ast->parameter_declaration_list = parameter_declaration_list;
        return ast;
    }

    CallAST *Call(ExpressionAST *base_expression = nullptr, ExpressionListAST *expression_list = nullptr)
    {
        CallAST *ast = new (&pool) CallAST;
        ast->base_expression = base_expression;
        ast->expression_list = expression_list;
        return ast;
    }

    ArrayAccessAST *ArrayAccess(ExpressionAST *base_expression = nullptr, ExpressionAST *expression = nullptr)
    {
        ArrayAccessAST *ast = new (&pool) ArrayAccessAST;
        ast->base_expression = base_expression;
        ast->expression = expression;
        return ast;
    }

    PostIncrDecrAST *PostIncrDecr(ExpressionAST *base_expression = nullptr)
    {
        PostIncrDecrAST *ast = new (&pool) PostIncrDecrAST;
        ast->base_expression = base_expression;
        return ast;
    }

    MemberAccessAST *MemberAccess(ExpressionAST *base_expression = nullptr, NameAST *member_name = nullptr)
    {
        MemberAccessAST *ast = new (&pool) MemberAccessAST;
        ast->base_expression = base_expression;
        ast->member_name = member_name;
        return ast;
    }

    TypeidExpressionAST *TypeidExpression(ExpressionAST *expression = nullptr)
    {
        TypeidExpressionAST *ast = new (&pool) TypeidExpressionAST;
        ast->expression = expression;
        return ast;
    }

    TypenameCallExpressionAST *TypenameCallExpression(NameAST *name = nullptr, ExpressionAST *expression = nullptr)
    {
        TypenameCallExpressionAST *ast = new (&pool) TypenameCallExpressionAST;
        ast->name = name;
        ast->expression = expression;
        return ast;
    }

    TypeConstructorCallAST *TypeConstructorCall(SpecifierListAST *type_specifier_list = nullptr, ExpressionAST *expression = nullptr)
    {
        TypeConstructorCallAST *ast = new (&pool) TypeConstructorCallAST;
        ast->type_specifier_list = type_specifier_list;
        ast->expression = expression;
        return ast;
    }

    PointerToMemberAST *PointerToMember(NestedNameSpecifierListAST *nested_name_specifier_list = nullptr, SpecifierListAST *cv_qualifier_list = nullptr)
    {
        PointerToMemberAST *ast = new (&pool) PointerToMemberAST;
        ast->nested_name_specifier_list = nested_name_specifier_list;
        ast->cv_qualifier_list = cv_qualifier_list;
        return ast;
    }

    PointerAST *Pointer(SpecifierListAST *cv_qualifier_list = nullptr)
    {
        PointerAST *ast = new (&pool) PointerAST;
        ast->cv_qualifier_list = cv_qualifier_list;
        return ast;
    }

    ReferenceAST *Reference()
    {
        ReferenceAST *ast = new (&pool) ReferenceAST;
        return ast;
    }

    BreakStatementAST *BreakStatement()
    {
        BreakStatementAST *ast = new (&pool) BreakStatementAST;
        return ast;
    }

    ContinueStatementAST *ContinueStatement()
    {
        ContinueStatementAST *ast = new (&pool) ContinueStatementAST;
        return ast;
    }

    GotoStatementAST *GotoStatement()
    {
        GotoStatementAST *ast = new (&pool) GotoStatementAST;
        return ast;
    }

    ReturnStatementAST *ReturnStatement(ExpressionAST *expression = nullptr)
    {
        ReturnStatementAST *ast = new (&pool) ReturnStatementAST;
        ast->expression = expression;
        return ast;
    }

    SizeofExpressionAST *SizeofExpression(ExpressionAST *expression = nullptr)
    {
        SizeofExpressionAST *ast = new (&pool) SizeofExpressionAST;
        ast->expression = expression;
        return ast;
    }

    AlignofExpressionAST *AlignofExpression(TypeIdAST *typeId = nullptr)
    {
        AlignofExpressionAST *ast = new (&pool) AlignofExpressionAST;
        ast->typeId = typeId;
        return ast;
    }

    PointerLiteralAST *PointerLiteral()
    {
        PointerLiteralAST *ast = new (&pool) PointerLiteralAST;
        return ast;
    }

    NumericLiteralAST *NumericLiteral()
    {
        NumericLiteralAST *ast = new (&pool) NumericLiteralAST;
        return ast;
    }

    BoolLiteralAST *BoolLiteral()
    {
        BoolLiteralAST *ast = new (&pool) BoolLiteralAST;
        return ast;
    }

    ThisExpressionAST *ThisExpression()
    {
        ThisExpressionAST *ast = new (&pool) ThisExpressionAST;
        return ast;
    }

    NestedExpressionAST *NestedExpression(ExpressionAST *expression = nullptr)
    {
        NestedExpressionAST *ast = new (&pool) NestedExpressionAST;
        ast->expression = expression;
        return ast;
    }

    StaticAssertDeclarationAST *StaticAssertDeclaration(ExpressionAST *expression = nullptr, ExpressionAST *string_literal = nullptr)
    {
        StaticAssertDeclarationAST *ast = new (&pool) StaticAssertDeclarationAST;
        ast->expression = expression;
        ast->string_literal = string_literal;
        return ast;
    }

    StringLiteralAST *StringLiteral(StringLiteralAST *next = nullptr)
    {
        StringLiteralAST *ast = new (&pool) StringLiteralAST;
        ast->next = next;
        return ast;
    }

    SwitchStatementAST *SwitchStatement(ExpressionAST *condition = nullptr, StatementAST *statement = nullptr)
    {
        SwitchStatementAST *ast = new (&pool) SwitchStatementAST;
        ast->condition = condition;
        ast->statement = statement;
        return ast;
    }

    TemplateDeclarationAST *TemplateDeclaration(DeclarationListAST *template_parameter_list = nullptr, DeclarationAST *declaration = nullptr)
    {
        TemplateDeclarationAST *ast = new (&pool) TemplateDeclarationAST;
        ast->template_parameter_list = template_parameter_list;
        ast->declaration = declaration;
        return ast;
    }

    ThrowExpressionAST *ThrowExpression(ExpressionAST *expression = nullptr)
    {
        ThrowExpressionAST *ast = new (&pool) ThrowExpressionAST;
        ast->expression = expression;
        return ast;
    }

    NoExceptOperatorExpressionAST *NoExceptOperatorExpression(ExpressionAST *expression = nullptr)
    {
        NoExceptOperatorExpressionAST *ast = new (&pool) NoExceptOperatorExpressionAST;
        ast->expression = expression;
        return ast;
    }

    TranslationUnitAST *TranslationUnit(DeclarationListAST *declaration_list = nullptr)
    {
        TranslationUnitAST *ast = new (&pool) TranslationUnitAST;
        ast->declaration_list = declaration_list;
        return ast;
    }

    TryBlockStatementAST *TryBlockStatement(StatementAST *statement = nullptr, CatchClauseListAST *catch_clause_list = nullptr)
    {
        TryBlockStatementAST *ast = new (&pool) TryBlockStatementAST;
        ast->statement = statement;
        ast->catch_clause_list = catch_clause_list;
        return ast;
    }

    CatchClauseAST *CatchClause(ExceptionDeclarationAST *exception_declaration = nullptr, StatementAST *statement = nullptr)
    {
        CatchClauseAST *ast = new (&pool) CatchClauseAST;
        ast->exception_declaration = exception_declaration;
        ast->statement = statement;
        return ast;
    }

    TypeIdAST *TypeId(SpecifierListAST *type_specifier_list = nullptr, DeclaratorAST *declarator = nullptr)
    {
        TypeIdAST *ast = new (&pool) TypeIdAST;
        ast->type_specifier_list = type_specifier_list;
        ast->declarator = declarator;
        return ast;
    }

    TypenameTypeParameterAST *TypenameTypeParameter(NameAST *name = nullptr, ExpressionAST *type_id = nullptr)
    {
        TypenameTypeParameterAST *ast = new (&pool) TypenameTypeParameterAST;
        ast->name = name;
        ast->type_id = type_id;
        return ast;
    }

    TemplateTypeParameterAST *TemplateTypeParameter(DeclarationListAST *template_parameter_list = nullptr, NameAST *name = nullptr, ExpressionAST *type_id = nullptr)
    {
        TemplateTypeParameterAST *ast = new (&pool) TemplateTypeParameterAST;
        ast->template_parameter_list = template_parameter_list;
        ast->name = name;
        ast->type_id = type_id;
        return ast;
    }

    UnaryExpressionAST *UnaryExpression(ExpressionAST *expression = nullptr)
    {
        UnaryExpressionAST *ast = new (&pool) UnaryExpressionAST;
        ast->expression = expression;
        return ast;
    }

    UsingAST *Using(NameAST *name = nullptr)
    {
        UsingAST *ast = new (&pool) UsingAST;
        ast->name = name;
        return ast;
    }

    UsingDirectiveAST *UsingDirective(NameAST *name = nullptr)
    {
        UsingDirectiveAST *ast = new (&pool) UsingDirectiveAST;
        ast->name = name;
        return ast;
    }

    WhileStatementAST *WhileStatement(ExpressionAST *condition = nullptr, StatementAST *statement = nullptr)
    {
        WhileStatementAST *ast = new (&pool) WhileStatementAST;
        ast->condition = condition;
        ast->statement = statement;
        return ast;
    }

    ObjCClassForwardDeclarationAST *ObjCClassForwardDeclaration(SpecifierListAST *attribute_list = nullptr, NameListAST *identifier_list = nullptr)
    {
        ObjCClassForwardDeclarationAST *ast = new (&pool) ObjCClassForwardDeclarationAST;
        ast->attribute_list = attribute_list;
        ast->identifier_list = identifier_list;
        return ast;
    }

    ObjCClassDeclarationAST *ObjCClassDeclaration(SpecifierListAST *attribute_list = nullptr, NameAST *class_name = nullptr, NameAST *category_name = nullptr, NameAST *superclass = nullptr, ObjCProtocolRefsAST *protocol_refs = nullptr, ObjCInstanceVariablesDeclarationAST *inst_vars_decl = nullptr, DeclarationListAST *member_declaration_list = nullptr)
    {
        ObjCClassDeclarationAST *ast = new (&pool) ObjCClassDeclarationAST;
        ast->attribute_list = attribute_list;
        ast->class_name = class_name;
        ast->category_name = category_name;
        ast->superclass = superclass;
        ast->protocol_refs = protocol_refs;
        ast->inst_vars_decl = inst_vars_decl;
        ast->member_declaration_list = member_declaration_list;
        return ast;
    }

    ObjCProtocolForwardDeclarationAST *ObjCProtocolForwardDeclaration(SpecifierListAST *attribute_list = nullptr, NameListAST *identifier_list = nullptr)
    {
        ObjCProtocolForwardDeclarationAST *ast = new (&pool) ObjCProtocolForwardDeclarationAST;
        ast->attribute_list = attribute_list;
        ast->identifier_list = identifier_list;
        return ast;
    }

    ObjCProtocolDeclarationAST *ObjCProtocolDeclaration(SpecifierListAST *attribute_list = nullptr, NameAST *name = nullptr, ObjCProtocolRefsAST *protocol_refs = nullptr, DeclarationListAST *member_declaration_list = nullptr)
    {
        ObjCProtocolDeclarationAST *ast = new (&pool) ObjCProtocolDeclarationAST;
        ast->attribute_list = attribute_list;
        ast->name = name;
        ast->protocol_refs = protocol_refs;
        ast->member_declaration_list = member_declaration_list;
        return ast;
    }

    ObjCProtocolRefsAST *ObjCProtocolRefs(NameListAST *identifier_list = nullptr)
    {
        ObjCProtocolRefsAST *ast = new (&pool) ObjCProtocolRefsAST;
        ast->identifier_list = identifier_list;
        return ast;
    }

    ObjCMessageArgumentAST *ObjCMessageArgument(ExpressionAST *parameter_value_expression = nullptr)
    {
        ObjCMessageArgumentAST *ast = new (&pool) ObjCMessageArgumentAST;
        ast->parameter_value_expression = parameter_value_expression;
        return ast;
    }

    ObjCMessageExpressionAST *ObjCMessageExpression(ExpressionAST *receiver_expression = nullptr, ObjCSelectorAST *selector = nullptr, ObjCMessageArgumentListAST *argument_list = nullptr)
    {
        ObjCMessageExpressionAST *ast = new (&pool) ObjCMessageExpressionAST;
        ast->receiver_expression = receiver_expression;
        ast->selector = selector;
        ast->argument_list = argument_list;
        return ast;
    }

    ObjCProtocolExpressionAST *ObjCProtocolExpression()
    {
        ObjCProtocolExpressionAST *ast = new (&pool) ObjCProtocolExpressionAST;
        return ast;
    }

    ObjCTypeNameAST *ObjCTypeName(ExpressionAST *type_id = nullptr)
    {
        ObjCTypeNameAST *ast = new (&pool) ObjCTypeNameAST;
        ast->type_id = type_id;
        return ast;
    }

    ObjCEncodeExpressionAST *ObjCEncodeExpression(ObjCTypeNameAST *type_name = nullptr)
    {
        ObjCEncodeExpressionAST *ast = new (&pool) ObjCEncodeExpressionAST;
        ast->type_name = type_name;
        return ast;
    }

    ObjCSelectorExpressionAST *ObjCSelectorExpression(ObjCSelectorAST *selector = nullptr)
    {
        ObjCSelectorExpressionAST *ast = new (&pool) ObjCSelectorExpressionAST;
        ast->selector = selector;
        return ast;
    }

    ObjCInstanceVariablesDeclarationAST *ObjCInstanceVariablesDeclaration(DeclarationListAST *instance_variable_list = nullptr)
    {
        ObjCInstanceVariablesDeclarationAST *ast = new (&pool) ObjCInstanceVariablesDeclarationAST;
        ast->instance_variable_list = instance_variable_list;
        return ast;
    }

    ObjCVisibilityDeclarationAST *ObjCVisibilityDeclaration()
    {
        ObjCVisibilityDeclarationAST *ast = new (&pool) ObjCVisibilityDeclarationAST;
        return ast;
    }

    ObjCPropertyAttributeAST *ObjCPropertyAttribute(ObjCSelectorAST *method_selector = nullptr)
    {
        ObjCPropertyAttributeAST *ast = new (&pool) ObjCPropertyAttributeAST;
        ast->method_selector = method_selector;
        return ast;
    }

    ObjCPropertyDeclarationAST *ObjCPropertyDeclaration(SpecifierListAST *attribute_list = nullptr, ObjCPropertyAttributeListAST *property_attribute_list = nullptr, DeclarationAST *simple_declaration = nullptr)
    {
        ObjCPropertyDeclarationAST *ast = new (&pool) ObjCPropertyDeclarationAST;
        ast->attribute_list = attribute_list;
        ast->property_attribute_list = property_attribute_list;
        ast->simple_declaration = simple_declaration;
        return ast;
    }

    ObjCMessageArgumentDeclarationAST *ObjCMessageArgumentDeclaration(ObjCTypeNameAST *type_name = nullptr, SpecifierListAST *attribute_list = nullptr, NameAST *param_name = nullptr)
    {
        ObjCMessageArgumentDeclarationAST *ast = new (&pool) ObjCMessageArgumentDeclarationAST;
        ast->type_name = type_name;
        ast->attribute_list = attribute_list;
        ast->param_name = param_name;
        return ast;
    }

    ObjCMethodPrototypeAST *ObjCMethodPrototype(ObjCTypeNameAST *type_name = nullptr, ObjCSelectorAST *selector = nullptr, ObjCMessageArgumentDeclarationListAST *argument_list = nullptr, SpecifierListAST *attribute_list = nullptr)
    {
        ObjCMethodPrototypeAST *ast = new (&pool) ObjCMethodPrototypeAST;
        ast->type_name = type_name;
        ast->selector = selector;
        ast->argument_list = argument_list;
        ast->attribute_list = attribute_list;
        return ast;
    }

    ObjCMethodDeclarationAST *ObjCMethodDeclaration(ObjCMethodPrototypeAST *method_prototype = nullptr, StatementAST *function_body = nullptr)
    {
        ObjCMethodDeclarationAST *ast = new (&pool) ObjCMethodDeclarationAST;
        ast->method_prototype = method_prototype;
        ast->function_body = function_body;
        return ast;
    }

    ObjCSynthesizedPropertyAST *ObjCSynthesizedProperty()
    {
        ObjCSynthesizedPropertyAST *ast = new (&pool) ObjCSynthesizedPropertyAST;
        return ast;
    }

    ObjCSynthesizedPropertiesDeclarationAST *ObjCSynthesizedPropertiesDeclaration(ObjCSynthesizedPropertyListAST *property_identifier_list = nullptr)
    {
        ObjCSynthesizedPropertiesDeclarationAST *ast = new (&pool) ObjCSynthesizedPropertiesDeclarationAST;
        ast->property_identifier_list = property_identifier_list;
        return ast;
    }

    ObjCDynamicPropertiesDeclarationAST *ObjCDynamicPropertiesDeclaration(NameListAST *property_identifier_list = nullptr)
    {
        ObjCDynamicPropertiesDeclarationAST *ast = new (&pool) ObjCDynamicPropertiesDeclarationAST;
        ast->property_identifier_list = property_identifier_list;
        return ast;
    }

    ObjCFastEnumerationAST *ObjCFastEnumeration(SpecifierListAST *type_specifier_list = nullptr, DeclaratorAST *declarator = nullptr, ExpressionAST *initializer = nullptr, ExpressionAST *fast_enumeratable_expression = nullptr, StatementAST *statement = nullptr)
    {
        ObjCFastEnumerationAST *ast = new (&pool) ObjCFastEnumerationAST;
        ast->type_specifier_list = type_specifier_list;
        ast->declarator = declarator;
        ast->initializer = initializer;
        ast->fast_enumeratable_expression = fast_enumeratable_expression;
        ast->statement = statement;
        return ast;
    }

    ObjCSynchronizedStatementAST *ObjCSynchronizedStatement(ExpressionAST *synchronized_object = nullptr, StatementAST *statement = nullptr)
    {
        ObjCSynchronizedStatementAST *ast = new (&pool) ObjCSynchronizedStatementAST;
        ast->synchronized_object = synchronized_object;
        ast->statement = statement;
        return ast;
    }

    LambdaExpressionAST *LambdaExpression(LambdaIntroducerAST *lambda_introducer = nullptr, LambdaDeclaratorAST *lambda_declarator = nullptr, StatementAST *statement = nullptr)
    {
        LambdaExpressionAST *ast = new (&pool) LambdaExpressionAST;
        ast->lambda_introducer = lambda_introducer;
        ast->lambda_declarator = lambda_declarator;
        ast->statement = statement;
        return ast;
    }

    LambdaIntroducerAST *LambdaIntroducer(LambdaCaptureAST *lambda_capture = nullptr)
    {
        LambdaIntroducerAST *ast = new (&pool) LambdaIntroducerAST;
        ast->lambda_capture = lambda_capture;
        return ast;
    }

    LambdaCaptureAST *LambdaCapture(CaptureListAST *capture_list = nullptr)
    {
        LambdaCaptureAST *ast = new (&pool) LambdaCaptureAST;
        ast->capture_list = capture_list;
        return ast;
    }

    CaptureAST *Capture(NameAST *identifier = nullptr)
    {
        CaptureAST *ast = new (&pool) CaptureAST;
        ast->identifier = identifier;
        return ast;
    }

    LambdaDeclaratorAST *LambdaDeclarator(ParameterDeclarationClauseAST *parameter_declaration_clause = nullptr, SpecifierListAST *attributes = nullptr, ExceptionSpecificationAST *exception_specification = nullptr, TrailingReturnTypeAST *trailing_return_type = nullptr)
    {
        LambdaDeclaratorAST *ast = new (&pool) LambdaDeclaratorAST;
        ast->parameter_declaration_clause = parameter_declaration_clause;
        ast->attributes = attributes;
        ast->exception_specification = exception_specification;
        ast->trailing_return_type = trailing_return_type;
        return ast;
    }

    TrailingReturnTypeAST *TrailingReturnType(SpecifierListAST *attributes = nullptr, SpecifierListAST *type_specifier_list = nullptr, DeclaratorAST *declarator = nullptr)
    {
        TrailingReturnTypeAST *ast = new (&pool) TrailingReturnTypeAST;
        ast->attributes = attributes;
        ast->type_specifier_list = type_specifier_list;
        ast->declarator = declarator;
        return ast;
    }

    BracedInitializerAST *BracedInitializer(ExpressionListAST *expression_list = nullptr)
    {
        BracedInitializerAST *ast = new (&pool) BracedInitializerAST;
        ast->expression_list = expression_list;
        return ast;
    }

    DotDesignatorAST *DotDesignator()
    {
        DotDesignatorAST *ast = new (&pool) DotDesignatorAST;
        return ast;
    }

    BracketDesignatorAST *BracketDesignator(ExpressionAST *expression = nullptr)
    {
        BracketDesignatorAST *ast = new (&pool) BracketDesignatorAST;
        ast->expression = expression;
        return ast;
    }

    DesignatedInitializerAST *DesignatedInitializer(DesignatorListAST *designator_list = nullptr, ExpressionAST *initializer = nullptr)
    {
        DesignatedInitializerAST *ast = new (&pool) DesignatedInitializerAST;
        ast->designator_list = designator_list;
        ast->initializer = initializer;
        return ast;
    }

    BaseSpecifierListAST *BaseSpecifierList(BaseSpecifierAST *value, BaseSpecifierListAST *next = nullptr)
    {
        BaseSpecifierListAST *list = new (&pool) BaseSpecifierListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    CaptureListAST *CaptureList(CaptureAST *value, CaptureListAST *next = nullptr)
    {
        CaptureListAST *list = new (&pool) CaptureListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    CatchClauseListAST *CatchClauseList(CatchClauseAST *value, CatchClauseListAST *next = nullptr)
    {
        CatchClauseListAST *list = new (&pool) CatchClauseListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    DeclarationListAST *DeclarationList(DeclarationAST *value, DeclarationListAST *next = nullptr)
    {
        DeclarationListAST *list = new (&pool) DeclarationListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    DeclaratorListAST *DeclaratorList(DeclaratorAST *value, DeclaratorListAST *next = nullptr)
    {
        DeclaratorListAST *list = new (&pool) DeclaratorListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    DesignatorListAST *DesignatorList(DesignatorAST *value, DesignatorListAST *next = nullptr)
    {
        DesignatorListAST *list = new (&pool) DesignatorListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    EnumeratorListAST *EnumeratorList(EnumeratorAST *value, EnumeratorListAST *next = nullptr)
    {
        EnumeratorListAST *list = new (&pool) EnumeratorListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    ExpressionListAST *ExpressionList(ExpressionAST *value, ExpressionListAST *next = nullptr)
    {
        ExpressionListAST *list = new (&pool) ExpressionListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    GnuAttributeListAST *GnuAttributeList(GnuAttributeAST *value, GnuAttributeListAST *next = nullptr)
    {
        GnuAttributeListAST *list = new (&pool) GnuAttributeListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    MemInitializerListAST *MemInitializerList(MemInitializerAST *value, MemInitializerListAST *next = nullptr)
    {
        MemInitializerListAST *list = new (&pool) MemInitializerListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    NameListAST *NameList(NameAST *value, NameListAST *next = nullptr)
    {
        NameListAST *list = new (&pool) NameListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    NestedNameSpecifierListAST *NestedNameSpecifierList(NestedNameSpecifierAST *value, NestedNameSpecifierListAST *next = nullptr)
    {
        NestedNameSpecifierListAST *list = new (&pool) NestedNameSpecifierListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    NewArrayDeclaratorListAST *NewArrayDeclaratorList(NewArrayDeclaratorAST *value, NewArrayDeclaratorListAST *next = nullptr)
    {
        NewArrayDeclaratorListAST *list = new (&pool) NewArrayDeclaratorListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    ObjCMessageArgumentDeclarationListAST *ObjCMessageArgumentDeclarationList(ObjCMessageArgumentDeclarationAST *value, ObjCMessageArgumentDeclarationListAST *next = nullptr)
    {
        ObjCMessageArgumentDeclarationListAST *list = new (&pool) ObjCMessageArgumentDeclarationListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    ObjCMessageArgumentListAST *ObjCMessageArgumentList(ObjCMessageArgumentAST *value, ObjCMessageArgumentListAST *next = nullptr)
    {
        ObjCMessageArgumentListAST *list = new (&pool) ObjCMessageArgumentListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    ObjCPropertyAttributeListAST *ObjCPropertyAttributeList(ObjCPropertyAttributeAST *value, ObjCPropertyAttributeListAST *next = nullptr)
    {
        ObjCPropertyAttributeListAST *list = new (&pool) ObjCPropertyAttributeListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    ObjCSelectorArgumentListAST *ObjCSelectorArgumentList(ObjCSelectorArgumentAST *value, ObjCSelectorArgumentListAST *next = nullptr)
    {
        ObjCSelectorArgumentListAST *list = new (&pool) ObjCSelectorArgumentListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    ObjCSynthesizedPropertyListAST *ObjCSynthesizedPropertyList(ObjCSynthesizedPropertyAST *value, ObjCSynthesizedPropertyListAST *next = nullptr)
    {
        ObjCSynthesizedPropertyListAST *list = new (&pool) ObjCSynthesizedPropertyListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    ParameterDeclarationListAST *ParameterDeclarationList(ParameterDeclarationAST *value, ParameterDeclarationListAST *next = nullptr)
    {
        ParameterDeclarationListAST *list = new (&pool) ParameterDeclarationListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    PostfixDeclaratorListAST *PostfixDeclaratorList(PostfixDeclaratorAST *value, PostfixDeclaratorListAST *next = nullptr)
    {
        PostfixDeclaratorListAST *list = new (&pool) PostfixDeclaratorListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    PtrOperatorListAST *PtrOperatorList(PtrOperatorAST *value, PtrOperatorListAST *next = nullptr)
    {
        PtrOperatorListAST *list = new (&pool) PtrOperatorListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    QtInterfaceNameListAST *QtInterfaceNameList(QtInterfaceNameAST *value, QtInterfaceNameListAST *next = nullptr)
    {
        QtInterfaceNameListAST *list = new (&pool) QtInterfaceNameListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    QtPropertyDeclarationItemListAST *QtPropertyDeclarationItemList(QtPropertyDeclarationItemAST *value, QtPropertyDeclarationItemListAST *next = nullptr)
    {
        QtPropertyDeclarationItemListAST *list = new (&pool) QtPropertyDeclarationItemListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    SpecifierListAST *SpecifierList(SpecifierAST *value, SpecifierListAST *next = nullptr)
    {
        SpecifierListAST *list = new (&pool) SpecifierListAST;
        list->next = next;
        list->value = value;
        return list;
    }

    StatementListAST *StatementList(StatementAST *value, StatementListAST *next = nullptr)
    {
        StatementListAST *list = new (&pool) StatementListAST;
        list->next = next;
        list->value = value;
        return list;
    }

};

} // end of namespace CPlusPlus
