/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.ngm.math;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Iterator;
import net.sourceforge.plantuml.project.ngm.NGMTotalEffort;
import net.sourceforge.plantuml.project.ngm.math.Fraction;
import net.sourceforge.plantuml.project.ngm.math.PiecewiseConstant;
import net.sourceforge.plantuml.project.ngm.math.Segment;
import net.sourceforge.plantuml.project.ngm.math.TimeDirection;

public class LoadIntegrator {
    private final PiecewiseConstant loadFunction;
    private final NGMTotalEffort totalLoad;

    public LoadIntegrator(PiecewiseConstant loadFunction, NGMTotalEffort totalLoad) {
        this.loadFunction = loadFunction;
        this.totalLoad = totalLoad;
    }

    public LocalDateTime computeEnd(LocalDateTime start) {
        return this.integrate(start, TimeDirection.FORWARD);
    }

    public LocalDateTime computeStart(LocalDateTime end) {
        return this.integrate(end, TimeDirection.BACKWARD);
    }

    private LocalDateTime integrate(LocalDateTime startTime, TimeDirection direction) {
        Fraction remainingLoad = this.totalLoad.toSeconds();
        LocalDateTime currentTime = startTime;
        Iterator<Segment> iter = this.loadFunction.iterateSegmentsFrom(startTime, direction);
        while (iter.hasNext()) {
            Segment segment = iter.next();
            if (remainingLoad.equals(Fraction.ZERO)) break;
            Fraction loadRate = segment.getValue();
            if (loadRate.equals(Fraction.ZERO)) {
                currentTime = segment.endExclusive();
                continue;
            }
            LocalDateTime effectiveStart = segment.computeClampedStart(currentTime);
            long segmentSeconds = Math.abs(Duration.between(effectiveStart, segment.endExclusive()).getSeconds());
            Fraction segmentLoad = loadRate.multiply(new Fraction(segmentSeconds, 1L));
            if (segmentLoad.compareTo(remainingLoad) >= 0) {
                Fraction secondsNeeded = remainingLoad.divide(loadRate);
                return direction.adjustBySeconds(effectiveStart, secondsNeeded.wholePart());
            }
            remainingLoad = remainingLoad.subtract(segmentLoad);
            currentTime = segment.endExclusive();
        }
        return currentTime;
    }
}

