/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.AutomatonProvider;
import org.apache.lucene.util.automaton.CaseFolding;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.apache.lucene.util.automaton.Transition;

public class RegExp {
    public static final int INTERSECTION = 1;
    public static final int EMPTY = 4;
    public static final int ANYSTRING = 8;
    public static final int AUTOMATON = 16;
    public static final int INTERVAL = 32;
    public static final int ALL = 255;
    public static final int NONE = 0;
    @Deprecated
    public static final int ASCII_CASE_INSENSITIVE = 256;
    public static final int CASE_INSENSITIVE = 512;
    public static final int CASE_INSENSITIVE_RANGE = 1024;
    @Deprecated
    public static final int DEPRECATED_COMPLEMENT = 65536;
    public final Kind kind;
    public final RegExp exp1;
    public final RegExp exp2;
    public final String s;
    public final int c;
    public final int min;
    public final int max;
    public final int digits;
    public final int[] from;
    public final int[] to;
    private final String originalString;
    final int flags;
    int pos;

    public RegExp(String s) throws IllegalArgumentException {
        this(s, 255);
    }

    public RegExp(String s, int syntax_flags) throws IllegalArgumentException {
        this(s, syntax_flags, 0);
    }

    public RegExp(String s, int syntax_flags, int match_flags) throws IllegalArgumentException {
        RegExp e;
        if ((syntax_flags & 0xFFFEFFFF) > 255) {
            throw new IllegalArgumentException("Illegal syntax flag");
        }
        if (match_flags > 0 && match_flags <= 255) {
            throw new IllegalArgumentException("Illegal match flag");
        }
        this.flags = syntax_flags | match_flags;
        this.originalString = s;
        if (s.length() == 0) {
            e = RegExp.makeString(this.flags, "");
        } else {
            e = this.parseUnionExp();
            if (this.pos < this.originalString.length()) {
                throw new IllegalArgumentException("end-of-string expected at position " + this.pos);
            }
        }
        this.kind = e.kind;
        this.exp1 = e.exp1;
        this.exp2 = e.exp2;
        this.s = e.s;
        this.c = e.c;
        this.min = e.min;
        this.max = e.max;
        this.digits = e.digits;
        this.from = e.from;
        this.to = e.to;
    }

    RegExp(int flags, Kind kind, RegExp exp1, RegExp exp2, String s, int c, int min, int max, int digits, int[] from, int[] to) {
        this.originalString = null;
        this.kind = kind;
        this.flags = flags;
        this.exp1 = exp1;
        this.exp2 = exp2;
        this.s = s;
        this.c = c;
        this.min = min;
        this.max = max;
        this.digits = digits;
        this.from = from;
        this.to = to;
    }

    static RegExp newContainerNode(int flags, Kind kind, RegExp exp1, RegExp exp2) {
        return new RegExp(flags, kind, exp1, exp2, null, 0, 0, 0, 0, null, null);
    }

    static RegExp newRepeatingNode(int flags, Kind kind, RegExp exp, int min, int max) {
        return new RegExp(flags, kind, exp, null, null, 0, min, max, 0, null, null);
    }

    static RegExp newLeafNode(int flags, Kind kind, String s, int c, int min, int max, int digits, int[] from, int[] to) {
        return new RegExp(flags, kind, null, null, s, c, min, max, digits, from, to);
    }

    public Automaton toAutomaton() {
        return this.toAutomaton(null, null);
    }

    public Automaton toAutomaton(AutomatonProvider automaton_provider) throws IllegalArgumentException, TooComplexToDeterminizeException {
        return this.toAutomaton(null, automaton_provider);
    }

    public Automaton toAutomaton(Map<String, Automaton> automata) throws IllegalArgumentException, TooComplexToDeterminizeException {
        return this.toAutomaton(automata, null);
    }

    private Automaton toAutomaton(Map<String, Automaton> automata, AutomatonProvider automaton_provider) throws IllegalArgumentException {
        Automaton a = null;
        switch (this.kind.ordinal()) {
            case 0: {
                ArrayList<Automaton> list = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_UNION, list, automata, automaton_provider);
                this.findLeaves(this.exp2, Kind.REGEXP_UNION, list, automata, automaton_provider);
                a = Operations.union(list);
                break;
            }
            case 1: {
                ArrayList<Automaton> list = new ArrayList<Automaton>();
                this.findLeaves(this.exp1, Kind.REGEXP_CONCATENATION, list, automata, automaton_provider);
                this.findLeaves(this.exp2, Kind.REGEXP_CONCATENATION, list, automata, automaton_provider);
                a = Operations.concatenate(list);
                break;
            }
            case 2: {
                a = Operations.intersection(this.exp1.toAutomaton(automata, automaton_provider), this.exp2.toAutomaton(automata, automaton_provider));
                break;
            }
            case 3: {
                a = Operations.optional(this.exp1.toAutomaton(automata, automaton_provider));
                break;
            }
            case 4: {
                a = Operations.repeat(this.exp1.toAutomaton(automata, automaton_provider));
                break;
            }
            case 5: {
                a = this.exp1.toAutomaton(automata, automaton_provider);
                a = Operations.repeat(a, this.min);
                break;
            }
            case 6: {
                a = this.exp1.toAutomaton(automata, automaton_provider);
                a = Operations.repeat(a, this.min, this.max);
                break;
            }
            case 7: {
                a = this.exp1.toAutomaton(automata, automaton_provider);
                a = Operations.complement(a, Integer.MAX_VALUE);
                break;
            }
            case 17: {
                a = this.exp1.toAutomaton(automata, automaton_provider);
                a = Operations.complement(a, 10000);
                break;
            }
            case 8: {
                if (this.check(768)) {
                    a = Automata.makeCharSet(this.toCaseInsensitiveChar(this.c));
                    break;
                }
                a = Automata.makeChar(this.c);
                break;
            }
            case 9: {
                a = Automata.makeCharRange(this.from[0], this.to[0]);
                break;
            }
            case 10: {
                a = Automata.makeCharClass(this.from, this.to);
                break;
            }
            case 11: {
                a = Automata.makeAnyChar();
                break;
            }
            case 12: {
                a = Automata.makeEmpty();
                break;
            }
            case 13: {
                if (this.check(768)) {
                    a = this.toCaseInsensitiveString();
                    break;
                }
                a = Automata.makeString(this.s);
                break;
            }
            case 14: {
                a = Automata.makeAnyString();
                break;
            }
            case 15: {
                Automaton aa = null;
                if (automata != null) {
                    aa = automata.get(this.s);
                }
                if (aa == null && automaton_provider != null) {
                    try {
                        aa = automaton_provider.getAutomaton(this.s);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                if (aa == null) {
                    throw new IllegalArgumentException("'" + this.s + "' not found");
                }
                a = aa;
                break;
            }
            case 16: {
                a = Automata.makeDecimalInterval(this.min, this.max, this.digits);
            }
        }
        return a;
    }

    private int[] toCaseInsensitiveChar(int codepoint) {
        IntArrayList list = new IntArrayList();
        CaseFolding.expand(codepoint, variant -> list.add(variant));
        list.sort();
        return list.toArray();
    }

    private void expandCaseInsensitiveRange(int start, int end, IntArrayList rangeStarts, IntArrayList rangeEnds) {
        if (start > end) {
            throw new IllegalArgumentException("invalid range: from (" + start + ") cannot be > to (" + end + ")");
        }
        Automaton scratch = new Automaton();
        int state = scratch.createState();
        for (int i = start; i <= end; ++i) {
            CaseFolding.expand(i, ch -> scratch.addTransition(state, state, ch));
        }
        scratch.finishState();
        Transition transition = new Transition();
        int numTransitions = scratch.initTransition(state, transition);
        for (int i = 0; i < numTransitions; ++i) {
            scratch.getNextTransition(transition);
            rangeStarts.add(transition.min);
            rangeEnds.add(transition.max);
        }
    }

    private Automaton toCaseInsensitiveString() {
        ArrayList<Automaton> list = new ArrayList<Automaton>();
        PrimitiveIterator.OfInt iter = this.s.codePoints().iterator();
        while (iter.hasNext()) {
            int[] points = this.toCaseInsensitiveChar((Integer)iter.next());
            list.add(Automata.makeCharSet(points));
        }
        return Operations.concatenate(list);
    }

    private void findLeaves(RegExp exp, Kind kind, List<Automaton> list, Map<String, Automaton> automata, AutomatonProvider automaton_provider) {
        if (exp.kind == kind) {
            this.findLeaves(exp.exp1, kind, list, automata, automaton_provider);
            this.findLeaves(exp.exp2, kind, list, automata, automaton_provider);
        } else {
            list.add(exp.toAutomaton(automata, automaton_provider));
        }
    }

    public String getOriginalString() {
        return this.originalString;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toStringBuilder(b);
        return b.toString();
    }

    void toStringBuilder(StringBuilder b) {
        switch (this.kind.ordinal()) {
            case 0: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("|");
                this.exp2.toStringBuilder(b);
                b.append(")");
                break;
            }
            case 1: {
                this.exp1.toStringBuilder(b);
                this.exp2.toStringBuilder(b);
                break;
            }
            case 2: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("&");
                this.exp2.toStringBuilder(b);
                b.append(")");
                break;
            }
            case 3: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append(")?");
                break;
            }
            case 4: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append(")*");
                break;
            }
            case 5: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("){").append(this.min).append(",}");
                break;
            }
            case 6: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("){").append(this.min).append(",").append(this.max).append("}");
                break;
            }
            case 7: 
            case 17: {
                b.append("~(");
                this.exp1.toStringBuilder(b);
                b.append(")");
                break;
            }
            case 8: {
                b.append("\\").appendCodePoint(this.c);
                break;
            }
            case 9: {
                b.append("[\\").appendCodePoint(this.from[0]).append("-\\").appendCodePoint(this.to[0]).append("]");
                break;
            }
            case 10: {
                b.append("[");
                for (int i = 0; i < this.from.length; ++i) {
                    if (this.from[i] == this.to[i]) {
                        b.append("\\").appendCodePoint(this.from[i]);
                        continue;
                    }
                    b.append("\\").appendCodePoint(this.from[i]);
                    b.append("-\\").appendCodePoint(this.to[i]);
                }
                b.append("]");
                break;
            }
            case 11: {
                b.append(".");
                break;
            }
            case 12: {
                b.append("#");
                break;
            }
            case 13: {
                b.append("\"").append(this.s).append("\"");
                break;
            }
            case 14: {
                b.append("@");
                break;
            }
            case 15: {
                b.append("<").append(this.s).append(">");
                break;
            }
            case 16: {
                int i;
                String s1 = Integer.toString(this.min);
                String s2 = Integer.toString(this.max);
                b.append("<");
                if (this.digits > 0) {
                    for (i = s1.length(); i < this.digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s1).append("-");
                if (this.digits > 0) {
                    for (i = s2.length(); i < this.digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s2).append(">");
            }
        }
    }

    public String toStringTree() {
        StringBuilder b = new StringBuilder();
        this.toStringTree(b, "");
        return b.toString();
    }

    void toStringTree(StringBuilder b, String indent) {
        switch (this.kind.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append('\n');
                this.exp1.toStringTree(b, indent + "  ");
                this.exp2.toStringTree(b, indent + "  ");
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 17: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append('\n');
                this.exp1.toStringTree(b, indent + "  ");
                break;
            }
            case 5: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append(" min=");
                b.append(this.min);
                b.append('\n');
                this.exp1.toStringTree(b, indent + "  ");
                break;
            }
            case 6: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append(" min=");
                b.append(this.min);
                b.append(" max=");
                b.append(this.max);
                b.append('\n');
                this.exp1.toStringTree(b, indent + "  ");
                break;
            }
            case 8: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append(" char=");
                b.appendCodePoint(this.c);
                b.append('\n');
                break;
            }
            case 9: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append(" from=");
                b.appendCodePoint(this.from[0]);
                b.append(" to=");
                b.appendCodePoint(this.to[0]);
                b.append('\n');
                break;
            }
            case 10: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append(" starts=");
                b.append((CharSequence)this.toHexString(this.from));
                b.append(" ends=");
                b.append((CharSequence)this.toHexString(this.to));
                b.append('\n');
                break;
            }
            case 11: 
            case 12: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append('\n');
                break;
            }
            case 13: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append(" string=");
                b.append(this.s);
                b.append('\n');
                break;
            }
            case 14: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append('\n');
                break;
            }
            case 15: {
                b.append(indent);
                b.append((Object)this.kind);
                b.append('\n');
                break;
            }
            case 16: {
                int i;
                b.append(indent);
                b.append((Object)this.kind);
                String s1 = Integer.toString(this.min);
                String s2 = Integer.toString(this.max);
                b.append("<");
                if (this.digits > 0) {
                    for (i = s1.length(); i < this.digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s1).append("-");
                if (this.digits > 0) {
                    for (i = s2.length(); i < this.digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s2).append(">");
                b.append('\n');
            }
        }
    }

    private StringBuilder toHexString(int[] range) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int codepoint : range) {
            if (sb.length() > 1) {
                sb.append(' ');
            }
            sb.append(String.format(Locale.ROOT, "U+%04X", codepoint));
        }
        sb.append(']');
        return sb;
    }

    public Set<String> getIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        this.getIdentifiers(set);
        return set;
    }

    void getIdentifiers(Set<String> set) {
        switch (this.kind.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                this.exp1.getIdentifiers(set);
                this.exp2.getIdentifiers(set);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: {
                this.exp1.getIdentifiers(set);
                break;
            }
            case 15: {
                set.add(this.s);
                break;
            }
        }
    }

    static RegExp makeUnion(int flags, RegExp exp1, RegExp exp2) {
        return RegExp.newContainerNode(flags, Kind.REGEXP_UNION, exp1, exp2);
    }

    static RegExp makeConcatenation(int flags, RegExp exp1, RegExp exp2) {
        RegExp rexp2;
        RegExp rexp1;
        if (!(exp1.kind != Kind.REGEXP_CHAR && exp1.kind != Kind.REGEXP_STRING || exp2.kind != Kind.REGEXP_CHAR && exp2.kind != Kind.REGEXP_STRING)) {
            return RegExp.makeString(flags, exp1, exp2);
        }
        if (!(exp1.kind != Kind.REGEXP_CONCATENATION || exp1.exp2.kind != Kind.REGEXP_CHAR && exp1.exp2.kind != Kind.REGEXP_STRING || exp2.kind != Kind.REGEXP_CHAR && exp2.kind != Kind.REGEXP_STRING)) {
            rexp1 = exp1.exp1;
            rexp2 = RegExp.makeString(flags, exp1.exp2, exp2);
        } else if (!(exp1.kind != Kind.REGEXP_CHAR && exp1.kind != Kind.REGEXP_STRING || exp2.kind != Kind.REGEXP_CONCATENATION || exp2.exp1.kind != Kind.REGEXP_CHAR && exp2.exp1.kind != Kind.REGEXP_STRING)) {
            rexp1 = RegExp.makeString(flags, exp1, exp2.exp1);
            rexp2 = exp2.exp2;
        } else {
            rexp1 = exp1;
            rexp2 = exp2;
        }
        return RegExp.newContainerNode(flags, Kind.REGEXP_CONCATENATION, rexp1, rexp2);
    }

    private static RegExp makeString(int flags, RegExp exp1, RegExp exp2) {
        StringBuilder b = new StringBuilder();
        if (exp1.kind == Kind.REGEXP_STRING) {
            b.append(exp1.s);
        } else {
            b.appendCodePoint(exp1.c);
        }
        if (exp2.kind == Kind.REGEXP_STRING) {
            b.append(exp2.s);
        } else {
            b.appendCodePoint(exp2.c);
        }
        return RegExp.makeString(flags, b.toString());
    }

    static RegExp makeIntersection(int flags, RegExp exp1, RegExp exp2) {
        return RegExp.newContainerNode(flags, Kind.REGEXP_INTERSECTION, exp1, exp2);
    }

    static RegExp makeOptional(int flags, RegExp exp) {
        return RegExp.newContainerNode(flags, Kind.REGEXP_OPTIONAL, exp, null);
    }

    static RegExp makeRepeat(int flags, RegExp exp) {
        return RegExp.newContainerNode(flags, Kind.REGEXP_REPEAT, exp, null);
    }

    static RegExp makeRepeat(int flags, RegExp exp, int min) {
        return RegExp.newRepeatingNode(flags, Kind.REGEXP_REPEAT_MIN, exp, min, 0);
    }

    static RegExp makeRepeat(int flags, RegExp exp, int min, int max) {
        return RegExp.newRepeatingNode(flags, Kind.REGEXP_REPEAT_MINMAX, exp, min, max);
    }

    static RegExp makeComplement(int flags, RegExp exp) {
        return RegExp.newContainerNode(flags, Kind.REGEXP_COMPLEMENT, exp, null);
    }

    @Deprecated
    static RegExp makeDeprecatedComplement(int flags, RegExp exp) {
        return RegExp.newContainerNode(flags, Kind.REGEXP_DEPRECATED_COMPLEMENT, exp, null);
    }

    static RegExp makeChar(int flags, int c) {
        return RegExp.newLeafNode(flags, Kind.REGEXP_CHAR, null, c, 0, 0, 0, null, null);
    }

    static RegExp makeCharRange(int flags, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("invalid range: from (" + from + ") cannot be > to (" + to + ")");
        }
        return RegExp.newLeafNode(flags, Kind.REGEXP_CHAR_RANGE, null, 0, 0, 0, 0, new int[]{from}, new int[]{to});
    }

    static RegExp makeCharClass(int flags, int[] from, int[] to) {
        if (from.length != to.length) {
            throw new IllegalStateException(String.format(Locale.ROOT, "invalid class: from.length (%d) != to.length (%d)", from.length, to.length));
        }
        for (int i = 0; i < from.length; ++i) {
            if (from[i] <= to[i]) continue;
            throw new IllegalArgumentException("invalid range: from (" + from[i] + ") cannot be > to (" + to[i] + ")");
        }
        return RegExp.newLeafNode(flags, Kind.REGEXP_CHAR_CLASS, null, 0, 0, 0, 0, from, to);
    }

    static RegExp makeAnyChar(int flags) {
        return RegExp.newContainerNode(flags, Kind.REGEXP_ANYCHAR, null, null);
    }

    static RegExp makeEmpty(int flags) {
        return RegExp.newContainerNode(flags, Kind.REGEXP_EMPTY, null, null);
    }

    static RegExp makeString(int flags, String s) {
        return RegExp.newLeafNode(flags, Kind.REGEXP_STRING, s, 0, 0, 0, 0, null, null);
    }

    static RegExp makeAnyString(int flags) {
        return RegExp.newContainerNode(flags, Kind.REGEXP_ANYSTRING, null, null);
    }

    static RegExp makeAutomaton(int flags, String s) {
        return RegExp.newLeafNode(flags, Kind.REGEXP_AUTOMATON, s, 0, 0, 0, 0, null, null);
    }

    static RegExp makeInterval(int flags, int min, int max, int digits) {
        return RegExp.newLeafNode(flags, Kind.REGEXP_INTERVAL, null, 0, min, max, digits, null, null);
    }

    private boolean peek(String s) {
        return this.more() && s.indexOf(this.originalString.codePointAt(this.pos)) != -1;
    }

    private boolean match(int c) {
        if (this.pos >= this.originalString.length()) {
            return false;
        }
        if (this.originalString.codePointAt(this.pos) == c) {
            this.pos += Character.charCount(c);
            return true;
        }
        return false;
    }

    private boolean more() {
        return this.pos < this.originalString.length();
    }

    private int next() throws IllegalArgumentException {
        if (!this.more()) {
            throw new IllegalArgumentException("unexpected end-of-string");
        }
        int ch = this.originalString.codePointAt(this.pos);
        this.pos += Character.charCount(ch);
        return ch;
    }

    private boolean check(int flag) {
        return (this.flags & flag) != 0;
    }

    final RegExp parseUnionExp() throws IllegalArgumentException {
        return this.iterativeParseExp(this::parseInterExp, () -> this.match(124), RegExp::makeUnion);
    }

    final RegExp parseInterExp() throws IllegalArgumentException {
        return this.iterativeParseExp(this::parseConcatExp, () -> this.check(1) && this.match(38), RegExp::makeIntersection);
    }

    final RegExp parseConcatExp() throws IllegalArgumentException {
        return this.iterativeParseExp(this::parseRepeatExp, () -> this.more() && !this.peek(")|") && (!this.check(1) || !this.peek("&")), RegExp::makeConcatenation);
    }

    final RegExp iterativeParseExp(Supplier<RegExp> gather, BooleanSupplier stop, MakeRegexGroup associativeReduce) throws IllegalArgumentException {
        RegExp result = gather.get();
        while (stop.getAsBoolean()) {
            RegExp e = gather.get();
            result = associativeReduce.get(this.flags, result, e);
        }
        return result;
    }

    final RegExp parseRepeatExp() throws IllegalArgumentException {
        RegExp e = this.parseComplExp();
        while (this.peek("?*+{")) {
            if (this.match(63)) {
                e = RegExp.makeOptional(this.flags, e);
                continue;
            }
            if (this.match(42)) {
                e = RegExp.makeRepeat(this.flags, e);
                continue;
            }
            if (this.match(43)) {
                e = RegExp.makeRepeat(this.flags, e, 1);
                continue;
            }
            if (!this.match(123)) continue;
            int start = this.pos;
            while (this.peek("0123456789")) {
                this.next();
            }
            if (start == this.pos) {
                throw new IllegalArgumentException("integer expected at position " + this.pos);
            }
            int n = Integer.parseInt(this.originalString.substring(start, this.pos));
            int m = -1;
            if (this.match(44)) {
                start = this.pos;
                while (this.peek("0123456789")) {
                    this.next();
                }
                if (start != this.pos) {
                    m = Integer.parseInt(this.originalString.substring(start, this.pos));
                }
            } else {
                m = n;
            }
            if (!this.match(125)) {
                throw new IllegalArgumentException("expected '}' at position " + this.pos);
            }
            if (m != -1 && n > m) {
                throw new IllegalArgumentException("invalid repetition range(out of order): " + n + ".." + m);
            }
            if (m == -1) {
                e = RegExp.makeRepeat(this.flags, e, n);
                continue;
            }
            e = RegExp.makeRepeat(this.flags, e, n, m);
        }
        return e;
    }

    final RegExp parseComplExp() throws IllegalArgumentException {
        if (this.check(65536) && this.match(126)) {
            return RegExp.makeDeprecatedComplement(this.flags, this.parseComplExp());
        }
        return this.parseCharClassExp();
    }

    final RegExp parseCharClassExp() throws IllegalArgumentException {
        if (this.match(91)) {
            boolean negate = false;
            if (this.match(94)) {
                negate = true;
            }
            RegExp e = this.parseCharClasses();
            if (negate) {
                e = RegExp.makeIntersection(this.flags, RegExp.makeAnyChar(this.flags), RegExp.makeComplement(this.flags, e));
            }
            if (!this.match(93)) {
                throw new IllegalArgumentException("expected ']' at position " + this.pos);
            }
            return e;
        }
        return this.parseSimpleExp();
    }

    final RegExp parseCharClasses() throws IllegalArgumentException {
        IntArrayList starts = new IntArrayList();
        IntArrayList ends = new IntArrayList();
        do {
            int c;
            if (this.match(92)) {
                if (this.peek("\\ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz")) {
                    this.expandPreDefined(starts, ends);
                    continue;
                }
                c = this.next();
                starts.add(c);
                ends.add(c);
                continue;
            }
            c = this.parseCharExp();
            if (this.match(45)) {
                if (this.check(1024)) {
                    this.expandCaseInsensitiveRange(c, this.parseCharExp(), starts, ends);
                    continue;
                }
                starts.add(c);
                ends.add(this.parseCharExp());
                continue;
            }
            if (this.check(768)) {
                for (int form : this.toCaseInsensitiveChar(c)) {
                    starts.add(form);
                    ends.add(form);
                }
            } else {
                starts.add(c);
                ends.add(c);
            }
        } while (this.more() && !this.peek("]"));
        if (starts.size() == 1) {
            if (starts.get(0) == ends.get(0)) {
                return RegExp.makeChar(this.flags, starts.get(0));
            }
            return RegExp.makeCharRange(this.flags, starts.get(0), ends.get(0));
        }
        return RegExp.makeCharClass(this.flags, starts.toArray(), ends.toArray());
    }

    void expandPreDefined(IntArrayList starts, IntArrayList ends) {
        if (this.peek("\\")) {
            starts.add(92);
            ends.add(92);
            this.next();
        } else if (this.peek("d")) {
            starts.add(48);
            ends.add(57);
            this.next();
        } else if (this.peek("D")) {
            starts.add(0);
            ends.add(47);
            starts.add(58);
            ends.add(0x10FFFF);
            this.next();
        } else if (this.peek("s")) {
            starts.add(9);
            ends.add(10);
            starts.add(13);
            ends.add(13);
            starts.add(32);
            ends.add(32);
            this.next();
        } else if (this.peek("S")) {
            starts.add(0);
            ends.add(8);
            starts.add(11);
            ends.add(12);
            starts.add(14);
            ends.add(31);
            starts.add(33);
            ends.add(0x10FFFF);
            this.next();
        } else if (this.peek("w")) {
            starts.add(48);
            ends.add(57);
            starts.add(65);
            ends.add(90);
            starts.add(95);
            ends.add(95);
            starts.add(97);
            ends.add(122);
            this.next();
        } else if (this.peek("W")) {
            starts.add(0);
            ends.add(47);
            starts.add(58);
            ends.add(64);
            starts.add(91);
            ends.add(94);
            starts.add(96);
            ends.add(96);
            starts.add(123);
            ends.add(0x10FFFF);
            this.next();
        } else if (this.peek("abcefghijklmnopqrtuvxyz") || this.peek("ABCEFGHIJKLMNOPQRTUVXYZ")) {
            throw new IllegalArgumentException("invalid character class \\" + this.next());
        }
    }

    final RegExp matchPredefinedCharacterClass() {
        if (this.match(92) && this.peek("\\ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz")) {
            IntArrayList starts = new IntArrayList();
            IntArrayList ends = new IntArrayList();
            this.expandPreDefined(starts, ends);
            return RegExp.makeCharClass(this.flags, starts.toArray(), ends.toArray());
        }
        return null;
    }

    final RegExp parseSimpleExp() throws IllegalArgumentException {
        if (this.match(46)) {
            return RegExp.makeAnyChar(this.flags);
        }
        if (this.check(4) && this.match(35)) {
            return RegExp.makeEmpty(this.flags);
        }
        if (this.check(8) && this.match(64)) {
            return RegExp.makeAnyString(this.flags);
        }
        if (this.match(34)) {
            int start = this.pos;
            while (this.more() && !this.peek("\"")) {
                this.next();
            }
            if (!this.match(34)) {
                throw new IllegalArgumentException("expected '\"' at position " + this.pos);
            }
            return RegExp.makeString(this.flags, this.originalString.substring(start, this.pos - 1));
        }
        if (this.match(40)) {
            if (this.match(41)) {
                return RegExp.makeString(this.flags, "");
            }
            RegExp e = this.parseUnionExp();
            if (!this.match(41)) {
                throw new IllegalArgumentException("expected ')' at position " + this.pos);
            }
            return e;
        }
        if ((this.check(16) || this.check(32)) && this.match(60)) {
            int start = this.pos;
            while (this.more() && !this.peek(">")) {
                this.next();
            }
            if (!this.match(62)) {
                throw new IllegalArgumentException("expected '>' at position " + this.pos);
            }
            String s = this.originalString.substring(start, this.pos - 1);
            int i = s.indexOf(45);
            if (i == -1) {
                if (!this.check(16)) {
                    throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1));
                }
                return RegExp.makeAutomaton(this.flags, s);
            }
            if (!this.check(32)) {
                throw new IllegalArgumentException("illegal identifier at position " + (this.pos - 1));
            }
            try {
                if (i == 0 || i == s.length() - 1 || i != s.lastIndexOf(45)) {
                    throw new NumberFormatException();
                }
                String smin = s.substring(0, i);
                String smax = s.substring(i + 1);
                int imin = Integer.parseInt(smin);
                int imax = Integer.parseInt(smax);
                int digits = smin.length() == smax.length() ? smin.length() : 0;
                if (imin > imax) {
                    int t = imin;
                    imin = imax;
                    imax = t;
                }
                return RegExp.makeInterval(this.flags, imin, imax, digits);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("interval syntax error at position " + (this.pos - 1), e);
            }
        }
        RegExp predefined = this.matchPredefinedCharacterClass();
        if (predefined != null) {
            return predefined;
        }
        return RegExp.makeChar(this.flags, this.parseCharExp());
    }

    final int parseCharExp() throws IllegalArgumentException {
        this.match(92);
        return this.next();
    }

    public static enum Kind {
        REGEXP_UNION,
        REGEXP_CONCATENATION,
        REGEXP_INTERSECTION,
        REGEXP_OPTIONAL,
        REGEXP_REPEAT,
        REGEXP_REPEAT_MIN,
        REGEXP_REPEAT_MINMAX,
        REGEXP_COMPLEMENT,
        REGEXP_CHAR,
        REGEXP_CHAR_RANGE,
        REGEXP_CHAR_CLASS,
        REGEXP_ANYCHAR,
        REGEXP_EMPTY,
        REGEXP_STRING,
        REGEXP_ANYSTRING,
        REGEXP_AUTOMATON,
        REGEXP_INTERVAL,
        REGEXP_DEPRECATED_COMPLEMENT;

    }

    @FunctionalInterface
    private static interface MakeRegexGroup {
        public RegExp get(int var1, RegExp var2, RegExp var3);
    }
}

