/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.opensearch.OpenSearchException;
import org.opensearch.common.CheckedBiFunction;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.common.util.concurrent.KeyedLock;
import org.opensearch.common.util.concurrent.ReleasableLock;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.Assertions;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.engine.DocumentIndexWriter;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.engine.EngineException;
import org.opensearch.index.engine.IndexWriterFactory;
import org.opensearch.index.engine.OpenSearchConcurrentMergeScheduler;
import org.opensearch.index.engine.SoftDeletesPolicy;
import org.opensearch.index.mapper.IdFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.store.Store;

public class CompositeIndexWriter
implements DocumentIndexWriter {
    private final KeyedLock<BytesRef> keyedLock = new KeyedLock();
    private final EngineConfig engineConfig;
    private final IndexWriter accumulatingIndexWriter;
    private final CheckedBiFunction<String, CriteriaBasedIndexWriterLookup, DisposableIndexWriter, IOException> childIndexWriterFactory;
    private final NumericDocValuesField softDeletesField;
    protected final Logger logger;
    private volatile AtomicBoolean closed;
    private final SoftDeletesPolicy softDeletesPolicy;
    private final Store store;
    private static final String DUMMY_TOMBSTONE_DOC_ID = "-2";
    private final IndexWriterFactory nativeIndexWriterFactory;
    private final AtomicLong childWriterPendingNumDocs = new AtomicLong();
    private volatile LiveIndexWriterDeletesMap liveIndexWriterDeletesMap = new LiveIndexWriterDeletesMap();

    public CompositeIndexWriter(EngineConfig engineConfig, IndexWriter accumulatingIndexWriter, SoftDeletesPolicy softDeletesPolicy, NumericDocValuesField softDeletesField, IndexWriterFactory nativeIndexWriterFactory) {
        this.engineConfig = engineConfig;
        this.accumulatingIndexWriter = accumulatingIndexWriter;
        this.softDeletesPolicy = softDeletesPolicy;
        this.childIndexWriterFactory = this::createChildWriterUtil;
        this.softDeletesField = softDeletesField;
        this.store = engineConfig.getStore();
        this.logger = Loggers.getLogger(Engine.class, engineConfig.getShardId(), new String[0]);
        this.closed = new AtomicBoolean(false);
        this.nativeIndexWriterFactory = nativeIndexWriterFactory;
    }

    public void beforeRefresh() throws IOException {
        this.liveIndexWriterDeletesMap = this.liveIndexWriterDeletesMap.buildTransitionMap();
        this.logger.debug("Trying to acquire write lock during refresh of composite IndexWriter. ");
        try (ReleasableLock ignore = this.liveIndexWriterDeletesMap.old.mapWriteLock.acquire();
             CriteriaBasedIndexWriterLookup oldMap = this.liveIndexWriterDeletesMap.old;){
            this.logger.debug("Acquired write lock during refresh of composite IndexWriter.");
            this.refreshDocumentsForParentDirectory(oldMap);
        }
        catch (Throwable ex) {
            this.rollback();
            throw ex;
        }
    }

    private void refreshDocumentsForParentDirectory(CriteriaBasedIndexWriterLookup oldMap) throws IOException {
        Map<String, DisposableIndexWriter> markForRefreshIndexWritersMap = oldMap.criteriaBasedIndexWriterMap;
        this.deletePreviousVersionsForUpdatedDocuments();
        for (DisposableIndexWriter childDisposableWriter : markForRefreshIndexWritersMap.values()) {
            Directory directoryToCombine = childDisposableWriter.getIndexWriter().getDirectory();
            childDisposableWriter.getIndexWriter().close();
            long pendingNumDocsByOldChildWriter = childDisposableWriter.getIndexWriter().getPendingNumDocs();
            this.accumulatingIndexWriter.addIndexes(new Directory[]{directoryToCombine});
            Path childDirectoryPath = this.getLocalFSDirectory(directoryToCombine).getDirectory();
            IOUtils.closeWhileHandlingException((Closeable)directoryToCombine);
            this.childWriterPendingNumDocs.addAndGet(-pendingNumDocsByOldChildWriter);
            IOUtils.rm((Path[])new Path[]{childDirectoryPath});
        }
        this.deleteDummyTombstoneEntry();
    }

    private FSDirectory getLocalFSDirectory(Directory localDirectory) {
        assert (localDirectory instanceof FSDirectory);
        return (FSDirectory)localDirectory;
    }

    private void deleteDummyTombstoneEntry() throws IOException {
        Term uid = new Term("_id", DUMMY_TOMBSTONE_DOC_ID);
        this.accumulatingIndexWriter.deleteDocuments(new Term[]{uid});
    }

    private void deletePreviousVersionsForUpdatedDocuments() throws IOException {
        Map<BytesRef, DeleteEntry> deleteEntrySet = this.getLastDeleteEntrySet();
        for (DeleteEntry deleteEntry : deleteEntrySet.values()) {
            this.addDeleteEntryToWriter(deleteEntry, this.accumulatingIndexWriter);
        }
    }

    private void addDeleteEntryToWriter(DeleteEntry deleteEntry, IndexWriter currentWriter) throws IOException {
        Document document = new Document();
        document.add((IndexableField)new Field("_id", (CharSequence)DUMMY_TOMBSTONE_DOC_ID, (IndexableFieldType)IdFieldMapper.Defaults.FIELD_TYPE));
        document.add((IndexableField)new NumericDocValuesField("_version", deleteEntry.version));
        document.add((IndexableField)new NumericDocValuesField("_primary_term", deleteEntry.primaryTerm));
        currentWriter.softUpdateDocument(deleteEntry.term, (Iterable)document, new Field[]{this.softDeletesField});
    }

    public ReleasableLock getOldWriteLock() {
        return this.liveIndexWriterDeletesMap.old.mapWriteLock;
    }

    public ReleasableLock getNewWriteLock() {
        return this.liveIndexWriterDeletesMap.current.mapWriteLock;
    }

    CriteriaBasedIndexWriterLookup acquireNewReadLock() {
        return this.liveIndexWriterDeletesMap.current.mapReadLock.acquire();
    }

    public void afterRefresh(boolean didRefresh) throws IOException {
        this.liveIndexWriterDeletesMap = this.liveIndexWriterDeletesMap.invalidateOldMap();
    }

    Releasable acquireLock(BytesRef uid) {
        return this.keyedLock.acquire(uid);
    }

    public Map<BytesRef, DeleteEntry> getLastDeleteEntrySet() {
        return this.liveIndexWriterDeletesMap.old.lastDeleteEntrySet;
    }

    void putLastDeleteEntryUnderLockInNewMap(BytesRef uid, DeleteEntry entry) {
        this.liveIndexWriterDeletesMap.putLastDeleteEntryInCurrentMap(uid, entry);
    }

    void putCriteria(BytesRef uid, String criteria) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        this.liveIndexWriterDeletesMap.putCriteriaForDoc(uid, criteria);
    }

    DisposableIndexWriter getIndexWriterForIdFromCurrent(BytesRef uid) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        return this.getIndexWriterForIdFromLookup(uid, this.liveIndexWriterDeletesMap.current);
    }

    DisposableIndexWriter getIndexWriterForIdFromOld(BytesRef uid) {
        assert (this.assertKeyedLockHeldByCurrentThread(uid));
        assert (uid.bytes.length == uid.length) : "Oversized _uid! UID length: " + uid.length + ", bytes length: " + uid.bytes.length;
        return this.getIndexWriterForIdFromLookup(uid, this.liveIndexWriterDeletesMap.old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisposableIndexWriter getIndexWriterForIdFromLookup(BytesRef uid, CriteriaBasedIndexWriterLookup indexWriterLookup) {
        boolean isCriteriaNotNull = false;
        try {
            DisposableIndexWriter disposableIndexWriter;
            indexWriterLookup.mapReadLock.acquire();
            String criteria = indexWriterLookup.getCriteriaForDoc(uid);
            if (criteria != null && (disposableIndexWriter = indexWriterLookup.getIndexWriterForCriteria(criteria)) != null) {
                isCriteriaNotNull = true;
                DisposableIndexWriter disposableIndexWriter2 = disposableIndexWriter;
                return disposableIndexWriter2;
            }
            DisposableIndexWriter disposableIndexWriter3 = null;
            return disposableIndexWriter3;
        }
        finally {
            if (!isCriteriaNotNull) {
                indexWriterLookup.mapReadLock.close();
            }
        }
    }

    @Override
    public boolean hasNewIndexingOrUpdates() {
        return this.liveIndexWriterDeletesMap.hasNewIndexingOrUpdates();
    }

    String getCriteriaForDoc(BytesRef uid) {
        return this.liveIndexWriterDeletesMap.getCriteriaForDoc(uid);
    }

    boolean assertKeyedLockHeldByCurrentThread(BytesRef uid) {
        assert (this.keyedLock.isHeldByCurrentThread(uid)) : "Thread [" + Thread.currentThread().getName() + "], uid [" + uid.utf8ToString() + "]";
        return true;
    }

    DisposableIndexWriter computeIndexWriterIfAbsentForCriteria(String criteria, CheckedBiFunction<String, CriteriaBasedIndexWriterLookup, DisposableIndexWriter, IOException> indexWriterSupplier) throws IOException {
        return this.computeIndexWriterIfAbsentForCriteria(criteria, this.liveIndexWriterDeletesMap, indexWriterSupplier);
    }

    DisposableIndexWriter computeIndexWriterIfAbsentForCriteria(String criteria, LiveIndexWriterDeletesMap currentLiveIndexWriterDeletesMap, CheckedBiFunction<String, CriteriaBasedIndexWriterLookup, DisposableIndexWriter, IOException> indexWriterSupplier) {
        return currentLiveIndexWriterDeletesMap.computeIndexWriterIfAbsentForCriteria(criteria, indexWriterSupplier, this.engineConfig.getShardId());
    }

    public Map<String, DisposableIndexWriter> getMarkForRefreshIndexWriterMap() {
        return this.liveIndexWriterDeletesMap.old.criteriaBasedIndexWriterMap;
    }

    @Override
    public long getFlushingBytes() {
        this.ensureOpen();
        return this.getFlushingBytesUtil(this.liveIndexWriterDeletesMap);
    }

    public long getFlushingBytesUtil(LiveIndexWriterDeletesMap currentLiveIndexWriterDeletesMap) {
        long flushingBytes = 0L;
        for (DisposableIndexWriter disposableIndexWriter : currentLiveIndexWriterDeletesMap.current.criteriaBasedIndexWriterMap.values()) {
            try {
                flushingBytes += disposableIndexWriter.getIndexWriter().getFlushingBytes();
            }
            catch (AlreadyClosedException e) {
                if (disposableIndexWriter.getIndexWriter().getTragicException() == null) continue;
                throw e;
            }
        }
        for (DisposableIndexWriter disposableIndexWriter : currentLiveIndexWriterDeletesMap.old.criteriaBasedIndexWriterMap.values()) {
            try {
                flushingBytes += disposableIndexWriter.getIndexWriter().getFlushingBytes();
            }
            catch (AlreadyClosedException e) {
                if (disposableIndexWriter.getIndexWriter().getTragicException() == null) continue;
                throw e;
            }
        }
        return flushingBytes + this.accumulatingIndexWriter.getFlushingBytes();
    }

    @Override
    public long getPendingNumDocs() {
        this.ensureOpen();
        return this.childWriterPendingNumDocs.get() + this.accumulatingIndexWriter.getPendingNumDocs();
    }

    @Override
    public LiveIndexWriterConfig getConfig() {
        this.ensureOpen();
        return this.accumulatingIndexWriter.getConfig();
    }

    @Override
    public synchronized boolean hasPendingMerges() {
        return this.accumulatingIndexWriter.hasPendingMerges();
    }

    @Override
    public boolean hasUncommittedChanges() {
        return this.hasNewIndexingOrUpdates() || this.accumulatingIndexWriter.hasUncommittedChanges();
    }

    @Override
    public Throwable getTragicException() {
        for (DisposableIndexWriter disposableIndexWriter : this.liveIndexWriterDeletesMap.current.criteriaBasedIndexWriterMap.values()) {
            if (disposableIndexWriter.getIndexWriter().getTragicException() == null) continue;
            return disposableIndexWriter.getIndexWriter().getTragicException();
        }
        for (DisposableIndexWriter disposableIndexWriter : this.liveIndexWriterDeletesMap.old.criteriaBasedIndexWriterMap.values()) {
            if (disposableIndexWriter.getIndexWriter().getTragicException() == null) continue;
            return disposableIndexWriter.getIndexWriter().getTragicException();
        }
        return this.accumulatingIndexWriter.getTragicException();
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.ramBytesUsedUtil(this.liveIndexWriterDeletesMap);
    }

    private long ramBytesUsedUtil(LiveIndexWriterDeletesMap currentLiveIndexWriterDeletesMap) {
        long ramBytesUsed = 0L;
        for (DisposableIndexWriter disposableIndexWriter : currentLiveIndexWriterDeletesMap.current.criteriaBasedIndexWriterMap.values()) {
            try {
                ramBytesUsed += disposableIndexWriter.getIndexWriter().ramBytesUsed();
            }
            catch (AlreadyClosedException e) {
                if (disposableIndexWriter.getIndexWriter().getTragicException() == null) continue;
                throw e;
            }
        }
        for (DisposableIndexWriter disposableIndexWriter : currentLiveIndexWriterDeletesMap.old.criteriaBasedIndexWriterMap.values()) {
            try {
                ramBytesUsed += disposableIndexWriter.getIndexWriter().ramBytesUsed();
            }
            catch (AlreadyClosedException e) {
                if (disposableIndexWriter.getIndexWriter().getTragicException() == null) continue;
                throw e;
            }
        }
        return ramBytesUsed + this.accumulatingIndexWriter.ramBytesUsed();
    }

    @Override
    public final synchronized void setLiveCommitData(Iterable<Map.Entry<String, String>> commitUserData) {
        this.accumulatingIndexWriter.setLiveCommitData(commitUserData);
    }

    @Override
    public final long commit() throws IOException {
        this.ensureOpen();
        return this.accumulatingIndexWriter.commit();
    }

    @Override
    public final synchronized Iterable<Map.Entry<String, String>> getLiveCommitData() {
        return this.accumulatingIndexWriter.getLiveCommitData();
    }

    @Override
    public void rollback() throws IOException {
        if (this.shouldClose()) {
            for (DisposableIndexWriter disposableIndexWriter : this.liveIndexWriterDeletesMap.current.criteriaBasedIndexWriterMap.values()) {
                disposableIndexWriter.getIndexWriter().rollback();
            }
            for (DisposableIndexWriter disposableIndexWriter : this.liveIndexWriterDeletesMap.old.criteriaBasedIndexWriterMap.values()) {
                disposableIndexWriter.getIndexWriter().rollback();
            }
            this.accumulatingIndexWriter.rollback();
            this.closed.set(true);
        }
    }

    private boolean shouldClose() {
        return !this.closed.get();
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed.get()) {
            throw new AlreadyClosedException("CompositeIndexWriter is closed");
        }
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public boolean isWriteLockedByCurrentThread() {
        return this.liveIndexWriterDeletesMap.current.mapLock.isWriteLockedByCurrentThread() || this.liveIndexWriterDeletesMap.old.mapLock.isWriteLockedByCurrentThread();
    }

    @Override
    public Releasable obtainWriteLockOnAllMap() {
        ReleasableLock lock1 = this.getOldWriteLock().acquire();
        ReleasableLock lock2 = this.getNewWriteLock().acquire();
        return () -> {
            lock1.close();
            lock2.close();
        };
    }

    @Override
    public void close() throws IOException {
        this.rollback();
        this.liveIndexWriterDeletesMap = new LiveIndexWriterDeletesMap();
    }

    @Override
    public synchronized void deleteUnusedFiles() throws IOException {
        this.accumulatingIndexWriter.deleteUnusedFiles();
    }

    @Override
    public IndexWriter getAccumulatingIndexWriter() {
        return this.accumulatingIndexWriter;
    }

    @Override
    public long addDocuments(List<ParseContext.Document> docs, Term uid) throws IOException {
        this.ensureOpen();
        String criteria = this.getGroupingCriteriaForDoc(docs.iterator().next());
        DisposableIndexWriter disposableIndexWriter = this.getAssociatedIndexWriterForCriteria(criteria);
        try (CriteriaBasedIndexWriterLookup.CriteriaBasedWriterLock ignoreLock = disposableIndexWriter.getLookupMap().getMapReadLock();){
            long l;
            block12: {
                Releasable ignore1 = this.acquireLock(uid.bytes());
                try {
                    this.putCriteria(uid.bytes(), criteria);
                    long seqNo = disposableIndexWriter.getIndexWriter().addDocuments(docs);
                    this.childWriterPendingNumDocs.addAndGet(docs.size());
                    l = seqNo;
                    if (ignore1 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ignore1 != null) {
                        try {
                            ignore1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore1.close();
            }
            return l;
        }
    }

    @Override
    public long addDocument(ParseContext.Document doc, Term uid) throws IOException {
        this.ensureOpen();
        String criteria = this.getGroupingCriteriaForDoc(doc);
        DisposableIndexWriter disposableIndexWriter = this.getAssociatedIndexWriterForCriteria(criteria);
        try (CriteriaBasedIndexWriterLookup.CriteriaBasedWriterLock ignoreLock = disposableIndexWriter.getLookupMap().getMapReadLock();){
            long l;
            block12: {
                Releasable ignore1 = this.acquireLock(uid.bytes());
                try {
                    this.putCriteria(uid.bytes(), criteria);
                    long seqNo = disposableIndexWriter.getIndexWriter().addDocument((Iterable)doc);
                    this.childWriterPendingNumDocs.incrementAndGet();
                    l = seqNo;
                    if (ignore1 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ignore1 != null) {
                        try {
                            ignore1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore1.close();
            }
            return l;
        }
    }

    @Override
    public void softUpdateDocuments(Term uid, List<ParseContext.Document> docs, long version, long seqNo, long primaryTerm, Field ... softDeletesField) throws IOException {
        this.ensureOpen();
        String criteria = this.getGroupingCriteriaForDoc(docs.iterator().next());
        DisposableIndexWriter disposableIndexWriter = this.getAssociatedIndexWriterForCriteria(criteria);
        try (CriteriaBasedIndexWriterLookup.CriteriaBasedWriterLock ignoreLock = disposableIndexWriter.getLookupMap().getMapReadLock();
             Releasable ignore1 = this.acquireLock(uid.bytes());){
            this.putCriteria(uid.bytes(), criteria);
            disposableIndexWriter.getIndexWriter().softUpdateDocuments(uid, docs, softDeletesField);
            this.childWriterPendingNumDocs.addAndGet(docs.size());
            disposableIndexWriter.getLookupMap().putLastDeleteEntry(uid.bytes(), new DeleteEntry(uid, version, seqNo, primaryTerm));
        }
    }

    @Override
    public void softUpdateDocument(Term uid, ParseContext.Document doc, long version, long seqNo, long primaryTerm, Field ... softDeletesField) throws IOException {
        this.ensureOpen();
        String criteria = this.getGroupingCriteriaForDoc(doc);
        DisposableIndexWriter disposableIndexWriter = this.getAssociatedIndexWriterForCriteria(criteria);
        try (CriteriaBasedIndexWriterLookup.CriteriaBasedWriterLock ignoreLock = disposableIndexWriter.getLookupMap().getMapReadLock();
             Releasable ignore1 = this.acquireLock(uid.bytes());){
            this.putCriteria(uid.bytes(), criteria);
            disposableIndexWriter.getIndexWriter().softUpdateDocument(uid, (Iterable)doc, softDeletesField);
            this.childWriterPendingNumDocs.incrementAndGet();
            disposableIndexWriter.getLookupMap().putLastDeleteEntry(uid.bytes(), new DeleteEntry(uid, version, seqNo, primaryTerm));
        }
    }

    @Override
    public void deleteDocument(Term uid, boolean isStaleOperation, ParseContext.Document doc, long version, long seqNo, long primaryTerm, Field ... softDeletesField) throws IOException {
        this.ensureOpen();
        try (Releasable ignore1 = this.acquireLock(uid.bytes());){
            DisposableIndexWriter oldDisposableWriter;
            DisposableIndexWriter currentDisposableWriter = this.getIndexWriterForIdFromCurrent(uid.bytes());
            if (currentDisposableWriter != null) {
                try (CriteriaBasedIndexWriterLookup.CriteriaBasedWriterLock ignore = currentDisposableWriter.getLookupMap().getMapReadLock();){
                    if (!currentDisposableWriter.getLookupMap().isClosed() && !isStaleOperation) {
                        this.addDeleteEntryToWriter(new DeleteEntry(uid, version, seqNo, primaryTerm), currentDisposableWriter.getIndexWriter());
                        this.childWriterPendingNumDocs.incrementAndGet();
                    }
                }
            }
            if ((oldDisposableWriter = this.getIndexWriterForIdFromOld(uid.bytes())) != null) {
                try (CriteriaBasedIndexWriterLookup.CriteriaBasedWriterLock ignore = oldDisposableWriter.getLookupMap().getMapReadLock();){
                    if (!oldDisposableWriter.getLookupMap().isClosed() && !isStaleOperation) {
                        this.addDeleteEntryToWriter(new DeleteEntry(uid, version, seqNo, primaryTerm), oldDisposableWriter.getIndexWriter());
                        this.childWriterPendingNumDocs.incrementAndGet();
                    }
                }
            }
            this.deleteInLucene(uid, isStaleOperation, this.accumulatingIndexWriter, doc, softDeletesField);
        }
    }

    private void deleteInLucene(Term uid, boolean isStaleOperation, IndexWriter currentWriter, Iterable<? extends IndexableField> doc, Field ... softDeletesField) throws IOException {
        if (isStaleOperation) {
            currentWriter.addDocument(doc);
        } else {
            currentWriter.softUpdateDocument(uid, doc, softDeletesField);
        }
        this.childWriterPendingNumDocs.incrementAndGet();
    }

    private DisposableIndexWriter getAssociatedIndexWriterForCriteria(String criteria) throws IOException {
        return this.computeIndexWriterIfAbsentForCriteria(criteria, this.childIndexWriterFactory);
    }

    private String getGroupingCriteriaForDoc(ParseContext.Document doc) {
        return doc == null ? null : doc.getGroupingCriteria();
    }

    @Override
    public void forceMergeDeletes(boolean doWait) throws IOException {
        this.accumulatingIndexWriter.forceMergeDeletes(doWait);
    }

    @Override
    public final void maybeMerge() throws IOException {
        this.ensureOpen();
        this.accumulatingIndexWriter.maybeMerge();
    }

    @Override
    public void forceMerge(int maxNumSegments, boolean doWait) throws IOException {
        this.ensureOpen();
        this.accumulatingIndexWriter.forceMerge(maxNumSegments, doWait);
    }

    DisposableIndexWriter createChildWriterUtil(String associatedCriteria, CriteriaBasedIndexWriterLookup lookup) throws IOException {
        return new DisposableIndexWriter(this.nativeIndexWriterFactory.createWriter(this.store.newTempDirectory("temp_" + associatedCriteria + "_" + String.valueOf(UUID.randomUUID())), (MergeScheduler)new OpenSearchConcurrentMergeScheduler(this.engineConfig.getShardId(), this.engineConfig.getIndexSettings(), this.engineConfig.getMergedSegmentTransferTracker()), true, IndexWriterConfig.OpenMode.CREATE, null, this.softDeletesPolicy, this.config(), this.logger, associatedCriteria), lookup);
    }

    private EngineConfig config() {
        return this.engineConfig;
    }

    static final class LiveIndexWriterDeletesMap {
        final CriteriaBasedIndexWriterLookup current;
        final CriteriaBasedIndexWriterLookup old;

        LiveIndexWriterDeletesMap(CriteriaBasedIndexWriterLookup current, CriteriaBasedIndexWriterLookup old) {
            this.current = current;
            this.old = old;
        }

        LiveIndexWriterDeletesMap() {
            this(new CriteriaBasedIndexWriterLookup(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(), ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(), ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency(), 0L), CriteriaBasedIndexWriterLookup.EMPTY);
        }

        LiveIndexWriterDeletesMap buildTransitionMap() {
            return new LiveIndexWriterDeletesMap(new CriteriaBasedIndexWriterLookup(ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency((int)this.current.sizeOfCriteriaBasedIndexWriterMap()), ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency((int)this.current.sizeOfLastDeleteEntrySet()), ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency((int)this.current.sizeOfLastDeleteEntrySet()), this.current.version + 1L), this.current);
        }

        LiveIndexWriterDeletesMap invalidateOldMap() {
            return new LiveIndexWriterDeletesMap(this.current, CriteriaBasedIndexWriterLookup.EMPTY);
        }

        void putLastDeleteEntryInCurrentMap(BytesRef uid, DeleteEntry deleteEntry) {
            this.current.putLastDeleteEntry(uid, deleteEntry);
        }

        void putCriteriaForDoc(BytesRef key, String criteria) {
            this.current.putCriteriaForDoc(key, criteria);
        }

        String getCriteriaForDoc(BytesRef key) {
            return this.current.getCriteriaForDoc(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DisposableIndexWriter computeIndexWriterIfAbsentForCriteria(String criteria, CheckedBiFunction<String, CriteriaBasedIndexWriterLookup, DisposableIndexWriter, IOException> indexWriterSupplier, ShardId shardId) {
            boolean success = false;
            CriteriaBasedIndexWriterLookup current = null;
            try {
                while (current == null || current.isClosed()) {
                    current = this.current.mapReadLock.tryAcquire();
                }
                DisposableIndexWriter writer = current.computeIndexWriterIfAbsentForCriteria(criteria, indexWriterSupplier);
                success = true;
                DisposableIndexWriter disposableIndexWriter = writer;
                return disposableIndexWriter;
            }
            finally {
                if (!success && current != null) {
                    assert (current.mapReadLock.isHeldByCurrentThread());
                    current.mapReadLock.close();
                }
            }
        }

        ReleasableLock acquireCurrentWriteLock() {
            return this.current.mapWriteLock.acquire();
        }

        boolean hasNewIndexingOrUpdates() {
            return this.current.hasNewChanges() || this.old.hasNewChanges();
        }
    }

    public static final class CriteriaBasedIndexWriterLookup
    implements Closeable {
        private final Map<String, DisposableIndexWriter> criteriaBasedIndexWriterMap;
        private final Map<BytesRef, DeleteEntry> lastDeleteEntrySet;
        private final Map<BytesRef, String> criteria;
        private final ReentrantReadWriteLock mapLock;
        private final CriteriaBasedWriterLock mapReadLock;
        private final ReleasableLock mapWriteLock;
        private final long version;
        private boolean closed;
        private static final CriteriaBasedIndexWriterLookup EMPTY = new CriteriaBasedIndexWriterLookup(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), 0L);

        private CriteriaBasedIndexWriterLookup(Map<String, DisposableIndexWriter> criteriaBasedIndexWriterMap, Map<BytesRef, DeleteEntry> lastDeleteEntrySet, Map<BytesRef, String> criteria, long version) {
            this.criteriaBasedIndexWriterMap = criteriaBasedIndexWriterMap;
            this.lastDeleteEntrySet = lastDeleteEntrySet;
            this.mapLock = new ReentrantReadWriteLock();
            this.mapReadLock = new CriteriaBasedWriterLock(this.mapLock.readLock(), this);
            this.mapWriteLock = new ReleasableLock(this.mapLock.writeLock());
            this.criteria = criteria;
            this.version = version;
            this.closed = false;
        }

        DisposableIndexWriter computeIndexWriterIfAbsentForCriteria(String criteria, CheckedBiFunction<String, CriteriaBasedIndexWriterLookup, DisposableIndexWriter, IOException> indexWriterSupplier) {
            return this.criteriaBasedIndexWriterMap.computeIfAbsent(criteria, key -> {
                try {
                    return (DisposableIndexWriter)indexWriterSupplier.apply((Object)criteria, (Object)this);
                }
                catch (IOException e) {
                    throw new OpenSearchException((Throwable)e);
                }
            });
        }

        DisposableIndexWriter getIndexWriterForCriteria(String criteria) {
            return this.criteriaBasedIndexWriterMap.get(criteria);
        }

        int sizeOfCriteriaBasedIndexWriterMap() {
            return this.criteriaBasedIndexWriterMap.size();
        }

        int sizeOfLastDeleteEntrySet() {
            return this.lastDeleteEntrySet.size();
        }

        void putLastDeleteEntry(BytesRef uid, DeleteEntry deleteEntry) {
            this.lastDeleteEntrySet.put(uid, deleteEntry);
        }

        void putCriteriaForDoc(BytesRef key, String criteria) {
            this.criteria.put(key, criteria);
        }

        String getCriteriaForDoc(BytesRef key) {
            return this.criteria.get(key);
        }

        void removeLastDeleteEntry(BytesRef key) {
            this.lastDeleteEntrySet.remove(key);
        }

        CriteriaBasedWriterLock getMapReadLock() {
            return this.mapReadLock;
        }

        boolean hasNewChanges() {
            return !this.criteriaBasedIndexWriterMap.isEmpty() || !this.lastDeleteEntrySet.isEmpty();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        private static final class CriteriaBasedWriterLock
        implements Releasable {
            private final Lock lock;
            private final ThreadLocal<Integer> holdingThreads;
            private final CriteriaBasedIndexWriterLookup lookup;

            public CriteriaBasedWriterLock(Lock lock, CriteriaBasedIndexWriterLookup lookup) {
                this.lock = lock;
                this.holdingThreads = Assertions.ENABLED ? new ThreadLocal() : null;
                this.lookup = lookup;
            }

            public void close() {
                this.lock.unlock();
                assert (this.removeCurrentThread());
            }

            public CriteriaBasedIndexWriterLookup acquire() throws EngineException {
                this.lock.lock();
                assert (this.addCurrentThread());
                return this.lookup;
            }

            public CriteriaBasedIndexWriterLookup tryAcquire() {
                boolean locked = this.lock.tryLock();
                if (locked) {
                    assert (this.addCurrentThread());
                    if (this.lookup.isClosed()) {
                        this.close();
                        return null;
                    }
                    return this.lookup;
                }
                return null;
            }

            public CriteriaBasedIndexWriterLookup tryAcquire(TimeValue timeout) throws InterruptedException {
                boolean locked = this.lock.tryLock(timeout.duration(), timeout.timeUnit());
                if (locked) {
                    assert (this.addCurrentThread());
                    return this.lookup;
                }
                return null;
            }

            private boolean addCurrentThread() {
                Integer current = this.holdingThreads.get();
                this.holdingThreads.set(current == null ? 1 : current + 1);
                return true;
            }

            private boolean removeCurrentThread() {
                Integer count = this.holdingThreads.get();
                assert (count != null && count > 0);
                if (count == 1) {
                    this.holdingThreads.remove();
                } else {
                    this.holdingThreads.set(count - 1);
                }
                return true;
            }

            public boolean isHeldByCurrentThread() {
                if (this.holdingThreads == null) {
                    throw new UnsupportedOperationException("asserts must be enabled");
                }
                Integer count = this.holdingThreads.get();
                return count != null && count > 0;
            }
        }
    }

    static class DisposableIndexWriter {
        private final IndexWriter indexWriter;
        private final CriteriaBasedIndexWriterLookup lookupMap;

        public DisposableIndexWriter(IndexWriter indexWriter, CriteriaBasedIndexWriterLookup lookupMap) {
            this.indexWriter = indexWriter;
            this.lookupMap = lookupMap;
        }

        public IndexWriter getIndexWriter() {
            return this.indexWriter;
        }

        public CriteriaBasedIndexWriterLookup getLookupMap() {
            return this.lookupMap;
        }
    }

    private static class DeleteEntry {
        private final Term term;
        private final long version;
        private final long seqNo;
        private final long primaryTerm;

        public DeleteEntry(Term term, long version, long seqNo, long primaryTerm) {
            this.term = term;
            this.version = version;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
        }

        public Term getTerm() {
            return this.term;
        }
    }
}

