RSpec.describe Mdm::ExploitedHost, type: :model do
  it_should_behave_like 'Metasploit::Concern.run'

  context 'associations' do
    it { is_expected.to belong_to(:host).class_name('Mdm::Host') }
    it { is_expected.to belong_to(:service).class_name('Mdm::Service') }
  end

  context 'database' do

    context 'timestamps'do
      it { is_expected.to have_db_column(:created_at).of_type(:datetime).with_options(:null => false) }
      it { is_expected.to have_db_column(:updated_at).of_type(:datetime).with_options(:null => false) }
    end

    context 'columns' do
      it { is_expected.to have_db_column(:host_id).of_type(:integer).with_options(:null => false) }
      it { is_expected.to have_db_column(:service_id).of_type(:integer) }
      it { is_expected.to have_db_column(:name).of_type(:string) }
      it { is_expected.to have_db_column(:session_uuid).of_type(:string) }
      it { is_expected.to have_db_column(:payload).of_type(:string) }
    end
  end

  context '#destroy' do
    it 'should successfully destroy the object and all dependent objects' do
      exploited_host = FactoryBot.create(:mdm_exploited_host)
      expect {
        exploited_host.destroy
      }.to_not raise_error
      expect {
        exploited_host.reload
      }.to raise_error(ActiveRecord::RecordNotFound)
    end
  end

  context 'factory' do
    it 'should be valid' do
      exploited_host = FactoryBot.build(:mdm_exploited_host)
      expect(exploited_host).to be_valid
    end
  end

end
