/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jboss.logging.Logger;
import org.jgroups.util.NameCache;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.sessions.StickySessionEncoderProvider;
import org.keycloak.sessions.StickySessionEncoderProviderFactory;

public class InfinispanStickySessionEncoderProviderFactory
implements StickySessionEncoderProviderFactory,
EnvironmentDependentProviderFactory,
StickySessionEncoderProvider {
    private static final Logger log = Logger.getLogger(InfinispanStickySessionEncoderProviderFactory.class);
    private static final char SEPARATOR = '.';
    private boolean shouldAttachRoute;
    private boolean clustered;
    private Cache<String, ?> authenticationCache;

    public StickySessionEncoderProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
        this.setShouldAttachRoute(config.getBoolean("shouldAttachRoute", Boolean.valueOf(true)));
    }

    public void setShouldAttachRoute(boolean shouldAttachRoute) {
        this.shouldAttachRoute = shouldAttachRoute;
        log.debugf("Should attach route to the sticky session cookie: %b", (Object)shouldAttachRoute);
    }

    public void postInit(KeycloakSessionFactory factory) {
        try (KeycloakSession session = factory.create();){
            InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            this.authenticationCache = provider.getCache("authenticationSessions");
            this.clustered = this.authenticationCache.getCacheConfiguration().clustering().cacheMode().isClustered();
        }
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(InfinispanConnectionProvider.class);
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("shouldAttachRoute").type("boolean").helpText("If the route should be attached to cookies to reflect the node that owns a particular session.").defaultValue((Object)true).add().build();
    }

    public boolean isSupported(Config.Scope config) {
        return InfinispanUtils.isEmbeddedInfinispan();
    }

    public String encodeSessionId(String message, String sessionId) {
        Objects.requireNonNull(message);
        String route = this.sessionIdRoute(sessionId);
        return route == null ? message : message + "." + route;
    }

    public StickySessionEncoderProvider.SessionIdAndRoute decodeSessionIdAndRoute(String encodedSessionId) {
        int index = encodedSessionId.indexOf(46);
        int length = encodedSessionId.length();
        if (index == -1 || index == length - 1) {
            return new StickySessionEncoderProvider.SessionIdAndRoute(encodedSessionId, null);
        }
        return new StickySessionEncoderProvider.SessionIdAndRoute(encodedSessionId.substring(0, index), encodedSessionId.substring(index + 1, length));
    }

    public boolean shouldAttachRoute() {
        return this.shouldAttachRoute;
    }

    public String sessionIdRoute(String sessionId) {
        return this.clustered && this.shouldAttachRoute ? this.ownerOf(sessionId) : null;
    }

    private String ownerOf(String sessionId) {
        String string;
        Address primaryOwner = this.authenticationCache.getAdvancedCache().getDistributionManager().getCacheTopology().getDistribution((Object)Objects.requireNonNull(sessionId)).primary();
        if (primaryOwner instanceof JGroupsAddress) {
            JGroupsAddress jgrpAddr = (JGroupsAddress)primaryOwner;
            string = NameCache.get((org.jgroups.Address)jgrpAddr.getJGroupsAddress());
        } else {
            string = null;
        }
        return string;
    }
}

