import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo, useState } from 'react';
import { usePopperTooltip } from 'react-popper-tooltip';
import { renderMarkdown } from '@grafana/data';
import { useStyles2, Button, Portal } from '@grafana/ui';
import { FlexItem } from '../../QueryEditor/FlexItem.js';

const OperationInfoButton = memo(({ definition, operation, innerQueryPlaceholder }) => {
  const styles = useStyles2(getStyles);
  const [show, setShow] = useState(false);
  const { getTooltipProps, setTooltipRef, setTriggerRef, visible } = usePopperTooltip({
    placement: "top",
    visible: show,
    offset: [0, 16],
    onVisibleChange: setShow,
    interactive: true,
    trigger: ["click"]
  });
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      Button,
      {
        title: "Click to show description",
        ref: setTriggerRef,
        icon: "info-circle",
        size: "sm",
        variant: "secondary",
        fill: "text"
      }
    ),
    visible && /* @__PURE__ */ jsx(Portal, { children: /* @__PURE__ */ jsxs("div", { ref: setTooltipRef, ...getTooltipProps(), className: styles.docBox, children: [
      /* @__PURE__ */ jsxs("div", { className: styles.docBoxHeader, children: [
        /* @__PURE__ */ jsx("span", { children: definition.renderer(operation, definition, innerQueryPlaceholder) }),
        /* @__PURE__ */ jsx(FlexItem, { grow: 1 }),
        /* @__PURE__ */ jsx(
          Button,
          {
            icon: "times",
            onClick: () => setShow(false),
            fill: "text",
            variant: "secondary",
            title: "Remove operation"
          }
        )
      ] }),
      /* @__PURE__ */ jsx(
        "div",
        {
          className: styles.docBoxBody,
          dangerouslySetInnerHTML: { __html: getOperationDocs(definition, operation) }
        }
      )
    ] }) })
  ] });
});
OperationInfoButton.displayName = "OperationDocs";
const getStyles = (theme) => {
  return {
    docBox: css({
      overflow: "hidden",
      background: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.strong}`,
      boxShadow: theme.shadows.z3,
      maxWidth: "600px",
      padding: theme.spacing(1),
      borderRadius: theme.shape.radius.default,
      zIndex: theme.zIndex.tooltip
    }),
    docBoxHeader: css({
      fontSize: theme.typography.h5.fontSize,
      fontFamily: theme.typography.fontFamilyMonospace,
      paddingBottom: theme.spacing(1),
      display: "flex",
      alignItems: "center"
    }),
    docBoxBody: css({
      // The markdown paragraph has a marginBottom this removes it
      marginBottom: theme.spacing(-1),
      color: theme.colors.text.secondary
    }),
    signature: css({
      fontSize: theme.typography.bodySmall.fontSize,
      fontFamily: theme.typography.fontFamilyMonospace
    }),
    dropdown: css({
      opacity: 0,
      color: theme.colors.text.secondary
    })
  };
};
function getOperationDocs(def, op) {
  var _a;
  return renderMarkdown(def.explainHandler ? def.explainHandler(op, def) : (_a = def.documentation) != null ? _a : "no docs");
}

export { OperationInfoButton };
//# sourceMappingURL=OperationInfoButton.js.map
