import { jsx } from 'react/jsx-runtime';
import '@grafana/data';
import { OrderByRow } from './OrderByRow.js';
import '../types.js';
import 'lodash';
import { useSqlChange } from '../utils/useSqlChange.js';

function SQLOrderByRow({ fields, query, onQueryChange, db }) {
  var _a, _b;
  const { onSqlChange } = useSqlChange({ query, onQueryChange, db });
  let columnsWithIndices = [];
  if (fields) {
    const options = (_b = (_a = query.sql) == null ? undefined : _a.columns) == null ? undefined : _b.map((c, i) => {
      var _a2, _b2;
      const value = c.name ? `${c.name}(${(_a2 = c.parameters) == null ? undefined : _a2.map((p) => p.name)})` : (_b2 = c.parameters) == null ? undefined : _b2.map((p) => p.name);
      return {
        value,
        label: `${i + 1} - ${value}`
      };
    });
    columnsWithIndices = [
      {
        value: "",
        label: "Selected columns",
        options,
        expanded: true
      },
      ...fields
    ];
  }
  return /* @__PURE__ */ jsx(OrderByRow, { sql: query.sql, onSqlChange, columns: columnsWithIndices });
}

export { SQLOrderByRow };
//# sourceMappingURL=SQLOrderByRow.js.map
