/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.internal.tasks.testing.filter.TestFilterSpec;

public class TestSelectionMatcher {
    private final List<TestPattern> buildScriptIncludePatterns;
    private final List<TestPattern> buildScriptExcludePatterns;
    private final List<TestPattern> commandLineIncludePatterns;

    public TestSelectionMatcher(TestFilterSpec filter) {
        this.buildScriptIncludePatterns = this.preparePatternList(filter.getIncludedTests());
        this.buildScriptExcludePatterns = this.preparePatternList(filter.getExcludedTests());
        this.commandLineIncludePatterns = this.preparePatternList(filter.getIncludedTestsCommandLine());
    }

    private List<TestPattern> preparePatternList(Collection<String> includedTests) {
        ArrayList<TestPattern> includePatterns = new ArrayList<TestPattern>(includedTests.size());
        for (String includedTest : includedTests) {
            includePatterns.add(new TestPattern(includedTest));
        }
        return includePatterns;
    }

    public boolean matchesTest(String className, String methodName) {
        return this.matchesPattern(this.buildScriptIncludePatterns, className, methodName) && this.matchesPattern(this.commandLineIncludePatterns, className, methodName) && !this.matchesExcludePattern(className, methodName);
    }

    public boolean mayIncludeClass(String fullQualifiedClassName) {
        return this.mayIncludeClass(this.buildScriptIncludePatterns, fullQualifiedClassName) && this.mayIncludeClass(this.commandLineIncludePatterns, fullQualifiedClassName) && !this.mayExcludeClass(fullQualifiedClassName);
    }

    private boolean mayIncludeClass(List<TestPattern> includePatterns, String fullQualifiedName) {
        if (includePatterns.isEmpty()) {
            return true;
        }
        return this.mayMatchClass(includePatterns, fullQualifiedName);
    }

    public boolean mayExcludeClass(String fullQualifiedName) {
        if (this.buildScriptExcludePatterns.isEmpty()) {
            return false;
        }
        return this.matchesClass(this.buildScriptExcludePatterns, fullQualifiedName);
    }

    private boolean matchesClass(List<TestPattern> patterns, String fullQualifiedName) {
        for (TestPattern pattern : patterns) {
            if (!pattern.matchesClass(fullQualifiedName)) continue;
            return true;
        }
        return false;
    }

    private boolean mayMatchClass(List<TestPattern> patterns, String fullQualifiedName) {
        for (TestPattern pattern : patterns) {
            if (!pattern.mayIncludeClass(fullQualifiedName)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPattern(List<TestPattern> includePatterns, String className, String methodName) {
        if (includePatterns.isEmpty()) {
            return true;
        }
        return this.matchesClassAndMethod(includePatterns, className, methodName);
    }

    private boolean matchesExcludePattern(String className, String methodName) {
        if (this.buildScriptExcludePatterns.isEmpty()) {
            return false;
        }
        if (this.mayMatchClass(this.buildScriptExcludePatterns, className) && methodName == null) {
            return true;
        }
        return this.matchesClassAndMethod(this.buildScriptExcludePatterns, className, methodName);
    }

    private boolean matchesClassAndMethod(List<TestPattern> patterns, String className, String methodName) {
        for (TestPattern pattern : patterns) {
            if (pattern.matchesClassAndMethod(className, methodName)) {
                return true;
            }
            if (!pattern.matchesClass(className)) continue;
            return true;
        }
        return false;
    }

    private static String getSimpleName(String fullQualifiedName) {
        String simpleName = StringUtils.substringAfterLast((String)fullQualifiedName, (String)".");
        if ("".equals(simpleName)) {
            return fullQualifiedName;
        }
        return simpleName;
    }

    private static boolean classNameMatch(String simpleClassName, String patternSimpleClassName) {
        if (simpleClassName.equals(patternSimpleClassName)) {
            return true;
        }
        if (patternSimpleClassName.contains("$")) {
            return simpleClassName.equals(patternSimpleClassName.substring(0, patternSimpleClassName.indexOf(36)));
        }
        return false;
    }

    private static class TestPattern {
        private Pattern pattern;
        private String[] segments;
        private LastElementMatcher lastElementMatcher;
        private ClassNameSelector classNameSelector;

        private TestPattern(String pattern) {
            this.pattern = TestPattern.preparePattern(pattern);
            this.classNameSelector = this.patternStartsWithUpperCase(pattern) ? new SimpleClassNameSelector() : new FullQualifiedClassNameSelector();
            int firstWildcardIndex = pattern.indexOf(42);
            int firstParametrizeIndex = pattern.indexOf(91);
            if (firstWildcardIndex == -1) {
                this.segments = StringUtils.splitPreserveAllTokens((String)pattern, (char)'.');
                if (firstParametrizeIndex == -1) {
                    this.lastElementMatcher = new NoWildcardMatcher();
                } else {
                    this.segments = StringUtils.splitPreserveAllTokens((String)pattern.substring(0, firstParametrizeIndex), (char)'.');
                    int n = this.segments.length - 1;
                    this.segments[n] = this.segments[n] + pattern.substring(firstParametrizeIndex);
                }
            } else {
                this.segments = StringUtils.splitPreserveAllTokens((String)pattern.substring(0, firstWildcardIndex), (char)'.');
                this.lastElementMatcher = new WildcardMatcher();
            }
        }

        private static Pattern preparePattern(String input) {
            String[] split;
            StringBuilder pattern = new StringBuilder();
            for (String s : split = StringUtils.splitPreserveAllTokens((String)input, (char)'*')) {
                if (s.equals("")) {
                    pattern.append(".*");
                    continue;
                }
                if (pattern.length() > 0) {
                    pattern.append(".*");
                }
                pattern.append(Pattern.quote(s));
            }
            return Pattern.compile(pattern.toString());
        }

        private boolean mayIncludeClass(String fullQualifiedName) {
            if (this.patternStartsWithWildcard()) {
                return true;
            }
            String[] classNameArray = this.classNameSelector.determineTargetClassName(fullQualifiedName).split("\\.");
            if (this.classNameIsShorterThanPattern(classNameArray)) {
                return false;
            }
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.lastClassNameElementMatchesPenultimatePatternElement(classNameArray, i)) {
                    return true;
                }
                if (this.lastClassNameElementMatchesLastPatternElement(classNameArray, i)) {
                    return true;
                }
                if (classNameArray[i].equals(this.segments[i])) continue;
                return false;
            }
            return false;
        }

        private boolean matchesClass(String fullQualifiedName) {
            return this.pattern.matcher(this.classNameSelector.determineTargetClassName(fullQualifiedName)).matches();
        }

        private boolean matchesClassAndMethod(String fullQualifiedName, String methodName) {
            if (methodName == null) {
                return false;
            }
            return this.pattern.matcher(this.classNameSelector.determineTargetClassName(fullQualifiedName) + "." + methodName).matches();
        }

        private boolean lastClassNameElementMatchesPenultimatePatternElement(String[] className, int index) {
            return index == this.segments.length - 2 && index == className.length - 1 && TestSelectionMatcher.classNameMatch(className[index], this.segments[index]);
        }

        private boolean lastClassNameElementMatchesLastPatternElement(String[] className, int index) {
            return index == this.segments.length - 1 && this.lastElementMatcher.match(className[index], this.segments[index]);
        }

        private boolean patternStartsWithWildcard() {
            return this.segments.length == 0;
        }

        private boolean classNameIsShorterThanPattern(String[] classNameArray) {
            return classNameArray.length < this.segments.length - 1;
        }

        private boolean patternStartsWithUpperCase(String pattern) {
            return pattern.length() > 0 && Character.isUpperCase(pattern.charAt(0));
        }
    }

    private static class SimpleClassNameSelector
    implements ClassNameSelector {
        private SimpleClassNameSelector() {
        }

        @Override
        public String determineTargetClassName(String fullQualifiedName) {
            return TestSelectionMatcher.getSimpleName(fullQualifiedName);
        }
    }

    private static class FullQualifiedClassNameSelector
    implements ClassNameSelector {
        private FullQualifiedClassNameSelector() {
        }

        @Override
        public String determineTargetClassName(String fullQualifiedName) {
            return fullQualifiedName;
        }
    }

    private static interface ClassNameSelector {
        public String determineTargetClassName(String var1);
    }

    private static class WildcardMatcher
    implements LastElementMatcher {
        private WildcardMatcher() {
        }

        @Override
        public boolean match(String classElement, String patternElement) {
            return classElement.startsWith(patternElement) || TestSelectionMatcher.classNameMatch(classElement, patternElement);
        }
    }

    private static class NoWildcardMatcher
    implements LastElementMatcher {
        private NoWildcardMatcher() {
        }

        @Override
        public boolean match(String classElement, String patternElement) {
            return TestSelectionMatcher.classNameMatch(classElement, patternElement);
        }
    }

    private static interface LastElementMatcher {
        public boolean match(String var1, String var2);
    }
}

