/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

public class DoubleRange {
    private boolean _empty = true;
    private double _min = 0.0;
    private double _max = 0.0;

    public DoubleRange() {
    }

    public DoubleRange(double d, double d2) {
        this.addValue(d);
        this.addValue(d2);
    }

    public void clear() {
        this._max = 0.0;
        this._min = 0.0;
        this._empty = true;
    }

    public void addValue(double d) {
        if (d < this._min || this._empty) {
            this._min = d;
        }
        if (d > this._max || this._empty) {
            this._max = d;
        }
        this._empty = false;
    }

    public void combine(DoubleRange doubleRange) {
        if (doubleRange != null && doubleRange.getRange() > 1.0) {
            this.addValue(doubleRange.getMinimum());
            this.addValue(doubleRange.getMaximum());
        }
    }

    public boolean hasData() {
        return !this._empty;
    }

    public double getMinimum() {
        return this._min;
    }

    public double getMaximum() {
        return this._max;
    }

    public double getRange() {
        return this._max - this._min;
    }

    public double getMidValue() {
        return (this._max + this._min) / 2.0;
    }

    public boolean includes(double d) {
        return this.hasData() && d >= this._min && d <= this._max;
    }

    public DoubleRange copy() {
        if (this._empty) {
            return new DoubleRange();
        }
        return new DoubleRange(this._min, this._max);
    }
}

